/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx,
MutableInterval {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.RangeMarkerImpl");
    private final DocumentEx myDocument;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private final long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    protected RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "<init>"));
        }
        this(document, start, end, register, false, false);
    }

    private RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register, boolean greedyToLeft, boolean greedyToRight) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "<init>"));
        }
        if (start < 0) {
            throw new IllegalArgumentException("Wrong start: " + start + "; end=" + end);
        }
        if (end > document.getTextLength()) {
            throw new IllegalArgumentException("Wrong end: " + end + "; document length=" + document.getTextLength() + "; start=" + start);
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end: start=" + start + "; end=" + end);
        }
        this.myDocument = document;
        this.myId = counter.next();
        if (register) {
            this.registerInTree(start, end, greedyToLeft, greedyToRight, 0);
        }
    }

    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.myDocument.registerRangeMarker(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        IntervalTreeImpl tree = this.myNode.getTree();
        tree.checkMax(true);
        boolean b = this.myDocument.removeRangeMarker(this);
        tree.checkMax(true);
        return b;
    }

    @Override
    public long getId() {
        return this.myId;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    void invalidate(final @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "invalidate"));
        }
        this.setValid(false);
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.processAliveKeys(new Processor<RangeMarkerEx>(){

                @Override
                public boolean process(RangeMarkerEx markerEx) {
                    RangeMarkerImpl.this.myNode.getTree().beforeRemove(markerEx, reason);
                    return true;
                }
            });
        }
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "getDocument"));
        }
        return documentEx;
    }

    public int getLayer() {
        return 0;
    }

    @Override
    public void setGreedyToLeft(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToLeft()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), greedy, this.isGreedyToRight(), this.getLayer());
    }

    @Override
    public void setGreedyToRight(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), greedy, this.getLayer());
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    @Override
    public final void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "documentChanged"));
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = this.myDocument.getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate(e);
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength)) {
            LOG.error("Update failed. Event = " + e + ". old doc length=" + docLength + "; real doc length = " + this.myDocument.getTextLength() + "; " + this.getClass() + ". After update: '" + this + "'");
            this.invalidate(e);
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "changedUpdateImpl"));
        }
        if (!this.isValid()) {
            return;
        }
        TextRange newRange = RangeMarkerImpl.applyChange(e, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight());
        if (newRange == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(newRange.getStartOffset());
        this.setIntervalEnd(newRange.getEndOffset());
    }

    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
    }

    @Nullable
    static TextRange applyChange(@NotNull DocumentEvent e, int intervalStart, int intervalEnd, boolean isGreedyToLeft, boolean isGreedyToRight) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "applyChange"));
        }
        if (intervalStart == intervalEnd) {
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (intervalEnd < offset) {
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (intervalStart > offset + oldLength) {
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (!isGreedyToLeft && intervalStart == offset + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset) {
                return new UnfairTextRange(intervalStart - oldLength, intervalEnd + newLength - oldLength);
            }
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (intervalStart <= offset && intervalEnd >= offset + oldLength) {
            return new ProperTextRange(intervalStart, intervalEnd + newLength - oldLength);
        }
        if (intervalStart >= offset && intervalStart <= offset + oldLength && intervalEnd > offset + oldLength) {
            return new ProperTextRange(offset + newLength, intervalEnd + newLength - oldLength);
        }
        if (intervalEnd >= offset && intervalEnd <= offset + oldLength && intervalStart < offset) {
            return new UnfairTextRange(intervalStart, offset);
        }
        return null;
    }

    @Nullable
    private static TextRange processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "processIfOnePoint"));
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < intervalStart && intervalStart < oldEnd) {
            return null;
        }
        if (offset == intervalStart && oldLength == 0 && greedyRight) {
            return new UnfairTextRange(intervalStart, intervalStart + e.getNewLength());
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            return new UnfairTextRange(intervalStart + e.getNewLength() - oldLength, intervalStart + e.getNewLength() - oldLength);
        }
        return new UnfairTextRange(intervalStart, intervalStart);
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    @Override
    public int setIntervalStart(int start) {
        if (start < 0) {
            LOG.error("Negative start: " + start);
        }
        return this.myNode.setIntervalStart(start);
    }

    @Override
    public int setIntervalEnd(int end) {
        if (end < 0) {
            LOG.error("Negative end: " + end);
        }
        return this.myNode.setIntervalEnd(end);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isValid();
    }

    @Override
    public boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value);
    }

    @Override
    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    @Override
    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }
}

