/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.project.ProjectBundle;
import java.io.File;

public class ModuleLoadingErrorDescription
extends ConfigurationErrorDescription {
    private static final ConfigurationErrorType INVALID_MODULE = new ConfigurationErrorType(ProjectBundle.message("element.kind.name.module", new Object[0]), false);
    private final ModulePath myModulePath;
    private final ModuleManagerImpl myModuleManager;

    private ModuleLoadingErrorDescription(String description, ModulePath modulePath, ModuleManagerImpl moduleManager, String elementName) {
        super(elementName, description, INVALID_MODULE);
        this.myModulePath = modulePath;
        this.myModuleManager = moduleManager;
    }

    public ModulePath getModulePath() {
        return this.myModulePath;
    }

    @Override
    public void ignoreInvalidElement() {
        this.myModuleManager.removeFailedModulePath(this.myModulePath);
    }

    @Override
    public String getIgnoreConfirmationMessage() {
        return ProjectBundle.message("module.remove.from.project.confirmation", this.getElementName());
    }

    public static ModuleLoadingErrorDescription create(String description, ModulePath modulePath, ModuleManagerImpl moduleManager) {
        String path = modulePath.getPath();
        int start = path.lastIndexOf(File.separatorChar) + 1;
        int finish = path.lastIndexOf(46);
        if (finish == -1 || finish <= start) {
            finish = path.length();
        }
        String moduleName = path.substring(start, finish);
        return new ModuleLoadingErrorDescription(description, modulePath, moduleManager, moduleName);
    }
}

