/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreVirtualFilePointerManager
extends VirtualFilePointerManager {
    @Override
    @NotNull
    public VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        LightFilePointer lightFilePointer = new LightFilePointer(url);
        if (lightFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        return lightFilePointer;
    }

    @Override
    @NotNull
    public VirtualFilePointer create(@NotNull VirtualFile file, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        LightFilePointer lightFilePointer = new LightFilePointer(file);
        if (lightFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        return lightFilePointer;
    }

    @Override
    @NotNull
    public VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "duplicate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "duplicate"));
        }
        LightFilePointer lightFilePointer = new LightFilePointer(pointer.getUrl());
        if (lightFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "duplicate"));
        }
        return lightFilePointer;
    }

    @Override
    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        return virtualFilePointerContainer;
    }

    @Override
    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = new VirtualFilePointerContainerImpl(this, parent, listener);
        if (virtualFilePointerContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        return virtualFilePointerContainerImpl;
    }

    @Override
    public void dispose() {
    }
}

