/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.google.common.base.MoreObjects;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.WeakInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Identikit {
    private static final WeakInterner<ByType> ourPlainInterner = new WeakInterner();
    private static final WeakInterner<ByAnchor> ourAnchorInterner = new WeakInterner();

    @Nullable
    public abstract PsiElement findPsiElement(@NotNull PsiFile var1, int var2, int var3);

    @NotNull
    public abstract Language getFileLanguage();

    public static ByType fromPsi(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/Identikit", "fromPsi"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "com/intellij/psi/impl/smartPointers/Identikit", "fromPsi"));
        }
        return Identikit.fromTypes(element.getClass(), PsiUtilCore.getElementType(element), fileLanguage);
    }

    @Nullable
    static Pair<ByAnchor, PsiElement> withAnchor(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/Identikit", "withAnchor"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "com/intellij/psi/impl/smartPointers/Identikit", "withAnchor"));
        }
        PsiUtilCore.ensureValid(element);
        if (element.isPhysical()) {
            for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
                PsiElement anchor = provider.getAnchor(element);
                if (anchor == null || !anchor.isPhysical() || provider.restoreElement(anchor) != element) continue;
                ByAnchor anchorKit = new ByAnchor(Identikit.fromPsi(element, fileLanguage), Identikit.fromPsi(anchor, fileLanguage), provider);
                return Pair.create(ourAnchorInterner.intern(anchorKit), anchor);
            }
        }
        return null;
    }

    @NotNull
    static ByType fromTypes(@NotNull Class elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/psi/impl/smartPointers/Identikit", "fromTypes"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "com/intellij/psi/impl/smartPointers/Identikit", "fromTypes"));
        }
        ByType byType = ourPlainInterner.intern(new ByType(elementClass, elementType, fileLanguage));
        if (byType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/Identikit", "fromTypes"));
        }
        return byType;
    }

    static class ByAnchor
    extends Identikit {
        private final ByType myElementInfo;
        private final ByType myAnchorInfo;
        private final SmartPointerAnchorProvider myAnchorProvider;

        ByAnchor(ByType elementInfo, ByType anchorInfo, SmartPointerAnchorProvider anchorProvider) {
            this.myElementInfo = elementInfo;
            this.myAnchorInfo = anchorInfo;
            this.myAnchorProvider = anchorProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByAnchor)) {
                return false;
            }
            ByAnchor anchor = (ByAnchor)o;
            if (!this.myElementInfo.equals(anchor.myElementInfo)) {
                return false;
            }
            if (!this.myAnchorInfo.equals(anchor.myAnchorInfo)) {
                return false;
            }
            return this.myAnchorProvider.equals(anchor.myAnchorProvider);
        }

        public int hashCode() {
            return this.myElementInfo.hashCode();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor", "findPsiElement"));
            }
            PsiElement anchor = this.myAnchorInfo.findPsiElement(file, startOffset, endOffset);
            PsiElement element = anchor == null ? null : this.myAnchorProvider.restoreElement(anchor);
            return element != null && this.myElementInfo.isAcceptable(element) ? element : null;
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myAnchorInfo.getFileLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/Identikit$ByAnchor", "getFileLanguage"));
            }
            return language;
        }
    }

    public static class ByType
    extends Identikit {
        private final Class myElementClass;
        private final IElementType myElementType;
        private final Language myFileLanguage;

        private ByType(@NotNull Class elementClass, @Nullable IElementType elementType, Language fileLanguage) {
            if (elementClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/psi/impl/smartPointers/Identikit$ByType", "<init>"));
            }
            this.myElementClass = elementClass;
            this.myElementType = elementType;
            this.myFileLanguage = fileLanguage;
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            PsiElement lastChild;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/Identikit$ByType", "findPsiElement"));
            }
            PsiElement anchor = file.getViewProvider().findElementAt(startOffset, this.myFileLanguage);
            if (anchor == null && startOffset == file.getTextLength() && (lastChild = file.getViewProvider().getPsi(this.myFileLanguage).getLastChild()) != null) {
                anchor = PsiTreeUtil.getDeepestLast(lastChild);
            }
            if (anchor == null) {
                return null;
            }
            PsiElement result = this.findParent(startOffset, endOffset, anchor);
            if (endOffset == startOffset) {
                while (result == null && anchor.getTextRange().getStartOffset() == endOffset && (anchor = PsiTreeUtil.prevLeaf(anchor, false)) != null) {
                    result = this.findParent(startOffset, endOffset, anchor);
                }
            }
            return result;
        }

        @Nullable
        private PsiElement findParent(int startOffset, int endOffset, PsiElement anchor) {
            TextRange range = anchor.getTextRange();
            if (range.getStartOffset() != startOffset) {
                return null;
            }
            while (range.getEndOffset() < endOffset) {
                if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) {
                    return null;
                }
                range = anchor.getTextRange();
            }
            while (range.getEndOffset() == endOffset) {
                if (this.isAcceptable(anchor)) {
                    return anchor;
                }
                if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) break;
                range = anchor.getTextRange();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByType)) {
                return false;
            }
            ByType info = (ByType)o;
            return this.myElementType == info.myElementType && this.myElementClass == info.myElementClass && this.myFileLanguage == info.myFileLanguage;
        }

        public int hashCode() {
            return (this.myElementType == null ? 0 : this.myElementType.hashCode() * 31 * 31) + 31 * this.myElementClass.getName().hashCode() + this.myFileLanguage.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("class", (Object)this.myElementClass).add("elementType", (Object)this.myElementType).add("fileLanguage", (Object)this.myFileLanguage).toString();
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myFileLanguage;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/Identikit$ByType", "getFileLanguage"));
            }
            return language;
        }

        private boolean isAcceptable(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/Identikit$ByType", "isAcceptable"));
            }
            return this.myElementClass == element.getClass() && this.myElementType == PsiUtilCore.getElementType(element);
        }
    }
}

