/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GraphGenerator<Node>
implements Graph<Node> {
    private final InboundSemiGraph<Node> myGraph;
    private final Map<Node, Set<Node>> myOuts;

    public static <T> Graph<T> generate(InboundSemiGraph<T> graph) {
        return new GraphGenerator<T>(graph);
    }

    private GraphGenerator(InboundSemiGraph<Node> graph) {
        this.myGraph = graph;
        this.myOuts = new LinkedHashMap<Node, Set<Node>>();
        this.buildOuts();
    }

    private void buildOuts() {
        Collection<Node> nodes = this.myGraph.getNodes();
        for (Node node : nodes) {
            this.myOuts.put(node, new LinkedHashSet());
        }
        for (Node node : nodes) {
            Iterator<Node> inIt = this.myGraph.getIn(node);
            while (inIt.hasNext()) {
                Node inNode = inIt.next();
                Set<Node> set = this.myOuts.get(inNode);
                if (set == null) {
                    throw new AssertionError((Object)("Unexpected node " + inNode + "; nodes=" + nodes));
                }
                set.add(node);
            }
        }
    }

    @Override
    public Collection<Node> getNodes() {
        return this.myGraph.getNodes();
    }

    @Override
    public Iterator<Node> getIn(Node n) {
        return this.myGraph.getIn(n);
    }

    @Override
    public Iterator<Node> getOut(Node n) {
        return this.myOuts.get(n).iterator();
    }

    public GraphGenerator(SemiGraph<Node> graph) {
        this((InboundSemiGraph<Node>)graph);
    }

    public static <T> GraphGenerator<T> create(SemiGraph<T> graph) {
        return new GraphGenerator<T>(graph);
    }

    public static interface SemiGraph<Node>
    extends InboundSemiGraph<Node> {
        @Override
        public Collection<Node> getNodes();

        @Override
        public Iterator<Node> getIn(Node var1);
    }
}

