/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.UpdateData;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class DiffUpdateData<Key, Value>
extends UpdateData<Key, Value> {
    public static final boolean ourDiffUpdateEnabled = SystemProperties.getBooleanProperty("idea.disable.diff.index.update", true);
    private static final AtomicInteger requests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();

    public DiffUpdateData(@NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<ForwardIndex.InputKeyIterator<Key, Value>, IOException> currentData, @NotNull ID<Key, Value> indexId, ThrowableRunnable<IOException> forwardIndexUpdate) {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/util/indexing/impl/DiffUpdateData", "<init>"));
        }
        if (currentData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentData", "com/intellij/util/indexing/impl/DiffUpdateData", "<init>"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/impl/DiffUpdateData", "<init>"));
        }
        super(newData, currentData, indexId, forwardIndexUpdate);
    }

    @Override
    public void iterateKeys(int inputId, UpdateData.KeyValueUpdateProcessor<Key, Value> addProcessor, UpdateData.KeyValueUpdateProcessor<Key, Value> updateProcessor, UpdateData.RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        ForwardIndex.InputKeyIterator currentData;
        THashSet processedKeys = new THashSet();
        int oldSize = 0;
        int addedKeys = 0;
        int removedKeys = 0;
        boolean newDataIsEmpty = this.myNewData.isEmpty();
        try {
            currentData = (ForwardIndex.InputKeyIterator)this.myCurrentData.compute();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        while (currentData.hasNext()) {
            ++oldSize;
            Object key = currentData.next();
            if (!newDataIsEmpty) {
                processedKeys.add(key);
            }
            if (newDataIsEmpty || !this.myNewData.containsKey(key)) {
                removeProcessor.process(key, inputId);
                ++removedKeys;
                continue;
            }
            Object v = this.myNewData.get(key);
            if (currentData.isAssociatedValueEqual(v)) continue;
            updateProcessor.process(key, v, inputId);
            ++removedKeys;
            ++addedKeys;
        }
        if (!newDataIsEmpty) {
            for (Map.Entry entry : this.myNewData.entrySet()) {
                if (processedKeys.contains(entry.getKey())) continue;
                addProcessor.process(entry.getKey(), entry.getValue(), inputId);
                ++addedKeys;
            }
        }
        int totalRequests = requests.incrementAndGet();
        totalRemovals.addAndGet(oldSize);
        totalAdditions.addAndGet(this.myNewData.size());
        incrementalAdditions.addAndGet(removedKeys);
        incrementalRemovals.addAndGet(addedKeys);
        if ((totalRequests & 0xFFF) == 0 && DebugAssertions.DEBUG) {
            Logger.getInstance(this.getClass()).info("Incremental index diff update:" + requests + ", removals:" + totalRemovals + "->" + incrementalRemovals + ", additions:" + totalAdditions + "->" + incrementalAdditions);
        }
    }

    @NotNull
    protected Map<Key, Value> getMap() {
        Map map = this.myNewData;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/DiffUpdateData", "getMap"));
        }
        return map;
    }
}

