/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nullable;

public class ScrollUtil {
    private ScrollUtil() {
    }

    @Nullable
    public static JScrollPane findScrollPane(JComponent c) {
        if (c == null) {
            return null;
        }
        return UIUtil.findComponentOfType(c, JScrollPane.class);
    }

    @Nullable
    public static JScrollBar findVerticalScrollBar(JComponent c) {
        return ScrollUtil.findScrollBar(c, 1);
    }

    @Nullable
    public static JScrollBar findHorizontalScrollBar(JComponent c) {
        return ScrollUtil.findScrollBar(c, 0);
    }

    @Nullable
    private static JScrollBar findScrollBar(JComponent c, @JdkConstants.AdjustableOrientation int orientation) {
        if (c == null) {
            return null;
        }
        if (c instanceof JScrollBar && ((JScrollBar)c).getOrientation() == orientation) {
            return (JScrollBar)c;
        }
        for (Component comp : c.getComponents()) {
            JScrollBar scrollBar;
            if (!(comp instanceof JComponent) || (scrollBar = ScrollUtil.findScrollBar((JComponent)comp, orientation)) == null) continue;
            return scrollBar;
        }
        return null;
    }

    public static void scrollVertically(JComponent c, int position) {
        JScrollPane pane = ScrollUtil.findScrollPane(c);
        if (pane != null) {
            JScrollBar bar = pane.getVerticalScrollBar();
            if (bar != null) {
                bar.setValue(position);
            }
        } else {
            JScrollBar scrollBar = ScrollUtil.findVerticalScrollBar(c);
            if (scrollBar != null) {
                scrollBar.setValue(position);
            }
        }
    }

    public static void scrollHorizontally(JComponent c, int position) {
        JScrollPane pane = ScrollUtil.findScrollPane(c);
        if (pane != null) {
            JScrollBar bar = pane.getHorizontalScrollBar();
            if (bar != null) {
                bar.setValue(position);
            }
        } else {
            JScrollBar scrollBar = ScrollUtil.findHorizontalScrollBar(c);
            if (scrollBar != null) {
                scrollBar.setValue(position);
            }
        }
    }

    public static void center(JComponent c, Rectangle r) {
        ScrollUtil.center(c, r, false);
    }

    public static void center(JComponent c, Rectangle r, boolean withInsets) {
        Rectangle visible = c.getVisibleRect();
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = c.getBounds();
        Insets i2 = withInsets ? new Insets(0, 0, 0, 0) : c.getInsets();
        bounds.x = i2.left;
        bounds.y = i2.top;
        bounds.width -= i2.left + i2.right;
        bounds.height -= i2.top + i2.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        c.scrollRectToVisible(visible);
    }

    public static void scroll(JComponent c, Rectangle r, ScrollBias horizontalBias, ScrollBias verticalBias) {
        Rectangle visible = c.getVisibleRect();
        Rectangle dest = new Rectangle(r);
        if (dest.width > visible.width && horizontalBias != ScrollBias.VIEWPORT) {
            if (horizontalBias == ScrollBias.UNCHANGED) {
                if (dest.x <= visible.x && dest.x + dest.width >= visible.x + visible.width) {
                    dest.width = visible.width;
                }
            } else {
                if (horizontalBias == ScrollBias.CENTER) {
                    dest.x += (dest.width - visible.width) / 2;
                } else if (horizontalBias == ScrollBias.LAST) {
                    dest.x += dest.width - visible.width;
                }
                dest.width = visible.width;
            }
        }
        if (dest.height > visible.height) {
            // empty if block
        }
        if (!visible.contains(dest)) {
            c.scrollRectToVisible(dest);
        }
    }

    public static enum ScrollBias {
        VIEWPORT,
        UNCHANGED,
        FIRST,
        CENTER,
        LAST;

    }
}

