/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ConvertToVarargsMethodFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MethodCanBeVariableArityMethodInspection
extends BaseInspection {
    public boolean ignoreByteAndShortArrayParameters = false;
    public boolean ignoreOverridingMethods = false;
    public boolean onlyReportPublicMethods = false;
    public boolean ignoreMultipleArrayParameters = false;
    public boolean ignoreMultiDimensionalArrayParameters = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.can.be.variable.arity.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.can.be.variable.arity.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.byte.short.option", new Object[0]), "ignoreByteAndShortArrayParameters");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), "ignoreOverridingMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("only.report.public.methods.option", new Object[0]), "onlyReportPublicMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.multiple.arrays.option", new Object[0]), "ignoreMultipleArrayParameters");
        panel.addCheckbox(InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.multidimensional.arrays.option", new Object[0]), "ignoreMultiDimensionalArrayParameters");
        return panel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConvertToVarargsMethodFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeVariableArityMethodVisitor();
    }

    private class MethodCanBeVariableArityMethodVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeVariableArityMethodVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiIdentifier nameIdentifier;
            super.visitMethod(method);
            if (MethodCanBeVariableArityMethodInspection.this.onlyReportPublicMethods && !method.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (NullableNotNullManager.isNullable(lastParameter)) {
                return;
            }
            PsiType type = lastParameter.getType();
            if (!(type instanceof PsiArrayType) || type instanceof PsiEllipsisType) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            if (MethodCanBeVariableArityMethodInspection.this.ignoreMultiDimensionalArrayParameters && componentType instanceof PsiArrayType) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreByteAndShortArrayParameters && (PsiType.BYTE.equals(componentType) || PsiType.SHORT.equals(componentType))) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreOverridingMethods && MethodUtils.hasSuper(method)) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreMultipleArrayParameters) {
                int length = parameters.length - 1;
                for (int i2 = 0; i2 < length; ++i2) {
                    PsiParameter parameter = parameters[i2];
                    if (!(parameter.getType() instanceof PsiArrayType)) continue;
                    return;
                }
            }
            if ((nameIdentifier = method.getNameIdentifier()) == null) {
                return;
            }
            if (this.isVisibleHighlight(method)) {
                this.registerErrorAtOffset((PsiElement)method, nameIdentifier.getStartOffsetInParent(), nameIdentifier.getTextLength(), new Object[0]);
            } else {
                int offset = nameIdentifier.getStartOffsetInParent();
                int length = parameterList.getStartOffsetInParent() + parameterList.getTextLength() - offset;
                this.registerErrorAtOffset((PsiElement)method, offset, length, new Object[0]);
            }
        }
    }
}

