/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualArrayToCollectionCopyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ManualArrayToCollectionCopyFix();
    }

    private static PsiArrayAccessExpression getArrayAccessExpression(PsiForStatement forStatement) {
        PsiExpression arrayAccessExpression;
        PsiStatement body = ManualArrayToCollectionCopyInspection.getBody(forStatement);
        if (body == null) {
            return null;
        }
        if (body instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            arrayAccessExpression = expressions.length == 0 ? null : expressions[0];
        } else if (body instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)body;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            arrayAccessExpression = variable.getInitializer();
        } else {
            return null;
        }
        PsiExpression deparenthesizedArgument = ParenthesesUtils.stripParentheses(arrayAccessExpression);
        if (!(deparenthesizedArgument instanceof PsiArrayAccessExpression)) {
            return null;
        }
        return (PsiArrayAccessExpression)deparenthesizedArgument;
    }

    @Nullable
    private static PsiStatement getBody(PsiLoopStatement forStatement) {
        PsiStatement body = forStatement.getBody();
        while (body instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            body = statements.length == 0 ? null : statements[0];
        }
        return body;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayToCollectionCopyVisitor();
    }

    private static class ManualArrayToCollectionCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayToCollectionCopyVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement);
            PsiStatement initialization = statement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (!ExpressionUtils.isVariableLessThanComparison(condition, variable)) {
                return;
            }
            PsiStatement update = statement.getUpdate();
            if (!VariableAccessUtils.variableIsIncremented(variable, update)) {
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = ManualArrayToCollectionCopyInspection.getArrayAccessExpression(statement);
            if (arrayAccessExpression == null) {
                return;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type = arrayExpression.getType();
            if (!(type instanceof PsiArrayType) || type.getDeepComponentType() instanceof PsiPrimitiveType) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body, variable, true)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType type = iteratedValue.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            PsiStatement body = statement.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body, parameter, false)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static boolean bodyIsArrayToCollectionCopy(PsiStatement body, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
                PsiExpression expression = expressionStatement.getExpression();
                return ManualArrayToCollectionCopyVisitor.expressionIsArrayToCollectionCopy(expression, variable, shouldBeOffsetArrayAccess);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1) {
                    return ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[0], variable, shouldBeOffsetArrayAccess);
                }
                if (statements.length == 2) {
                    PsiStatement statement = statements[0];
                    if (!(statement instanceof PsiDeclarationStatement)) {
                        return false;
                    }
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length != 1) {
                        return false;
                    }
                    PsiElement declaredElement = declaredElements[0];
                    if (!(declaredElement instanceof PsiVariable)) {
                        return false;
                    }
                    PsiVariable localVariable = (PsiVariable)declaredElement;
                    PsiExpression initializer = localVariable.getInitializer();
                    if (!ExpressionUtils.isOffsetArrayAccess(initializer, variable)) {
                        return false;
                    }
                    return ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[1], localVariable, false);
                }
            }
            return false;
        }

        private static boolean expressionIsArrayToCollectionCopy(PsiExpression expression, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
                return false;
            }
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType instanceof PsiPrimitiveType) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(argument)) {
                return false;
            }
            if (shouldBeOffsetArrayAccess ? !ExpressionUtils.isOffsetArrayAccess(argument, variable) : !VariableAccessUtils.evaluatesToVariable(argument, variable)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            String name = method.getName();
            if (!name.equals("add")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor(containingClass, "java.util.Collection");
        }
    }

    private static class ManualArrayToCollectionCopyFix
    extends InspectionGadgetsFix {
        private ManualArrayToCollectionCopyFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                String newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText(forStatement);
                if (newExpression == null) {
                    return;
                }
                PsiReplacementUtil.replaceStatementAndShortenClassNames(forStatement, newExpression);
            } else {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
                String newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText(foreachStatement);
                if (newExpression == null) {
                    return;
                }
                PsiReplacementUtil.replaceStatementAndShortenClassNames(foreachStatement, newExpression);
            }
        }

        @Nullable
        private static String getCollectionsAddAllText(PsiForeachStatement foreachStatement) throws IncorrectOperationException {
            PsiStatement body = ManualArrayToCollectionCopyInspection.getBody(foreachStatement);
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expressionStatement.getExpression();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement collection = methodExpression.getQualifier();
            if (collection == null) {
                return null;
            }
            String collectionText = collection.getText();
            PsiExpression iteratedValue = foreachStatement.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            String arrayText = iteratedValue.getText();
            StringBuilder buffer = new StringBuilder();
            if (PsiUtil.isLanguageLevel5OrHigher(foreachStatement)) {
                buffer.append("java.util.Collections.addAll(");
                buffer.append(collectionText);
                buffer.append(',');
                buffer.append(arrayText);
                buffer.append(");");
            } else {
                buffer.append(collectionText);
                buffer.append(".addAll(java.util.Arrays.asList(");
                buffer.append(arrayText);
                buffer.append("));");
            }
            return buffer.toString();
        }

        @Nullable
        private static String getCollectionsAddAllText(PsiForStatement forStatement) throws IncorrectOperationException {
            PsiExpression expression = forStatement.getCondition();
            PsiBinaryExpression condition = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(expression);
            if (condition == null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return null;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            String collectionText = ManualArrayToCollectionCopyFix.buildCollectionText(forStatement);
            PsiArrayAccessExpression arrayAccessExpression = ManualArrayToCollectionCopyInspection.getArrayAccessExpression(forStatement);
            if (arrayAccessExpression == null) {
                return null;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String arrayText = arrayExpression.getText();
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            String indexOffset = ManualArrayToCollectionCopyFix.getIndexOffset(indexExpression, variable);
            if (indexOffset == null) {
                return null;
            }
            String fromOffsetText = ManualArrayToCollectionCopyFix.addIndexOffset(variable.getInitializer(), indexOffset, false);
            if (fromOffsetText == null) {
                return null;
            }
            IElementType tokenType = condition.getOperationTokenType();
            PsiExpression limit = tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE ? condition.getROperand() : condition.getLOperand();
            String toOffsetText = ManualArrayToCollectionCopyFix.addIndexOffset(limit, indexOffset, tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GE);
            if (toOffsetText == null) {
                return null;
            }
            if (fromOffsetText.equals("0") && toOffsetText.equals(arrayText + ".length") && PsiUtil.isLanguageLevel5OrHigher(forStatement)) {
                return "java.util.Collections.addAll(" + collectionText + ',' + arrayText + ");";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(collectionText);
            buffer.append('.');
            buffer.append("addAll(java.util.Arrays.asList(");
            buffer.append(arrayText);
            buffer.append(')');
            if (!fromOffsetText.equals("0") || !toOffsetText.equals(arrayText + ".length")) {
                buffer.append(".subList(");
                buffer.append(fromOffsetText);
                buffer.append(", ");
                buffer.append(toOffsetText);
                buffer.append(')');
            }
            buffer.append(");");
            return buffer.toString();
        }

        public static String buildCollectionText(PsiForStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 2) {
                    body = statements[1];
                    continue;
                }
                if (statements.length == 1) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return null;
            }
            return qualifier.getText();
        }

        @Nullable
        private static String getIndexOffset(PsiExpression expression, PsiLocalVariable variable) {
            String variableName;
            if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
                return null;
            }
            if (ExpressionUtils.isZero(expression)) {
                return "0";
            }
            String expressionText = expression.getText();
            if (expressionText.equals(variableName = variable.getName())) {
                return "0";
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayToCollectionCopyFix.getIndexOffset(rhs, variable);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return '-' + rhsText;
                    }
                    return rhsText;
                }
                String lhsText = ManualArrayToCollectionCopyFix.getIndexOffset(lhs, variable);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayToCollectionCopyFix.collapseConstant(lhsText + " " + sign.getText() + " " + rhsText, variable);
            }
            return ManualArrayToCollectionCopyFix.collapseConstant(expressionText, variable);
        }

        private static String addIndexOffset(PsiExpression expression, String indexOffset, boolean plusOne) {
            if (expression == null) {
                return null;
            }
            if (plusOne) {
                indexOffset = ManualArrayToCollectionCopyFix.collapseConstant("(" + indexOffset + ") + 1", expression);
            }
            String expressionText = expression.getText();
            if ("0".equals(indexOffset)) {
                return expressionText;
            }
            if (expression instanceof PsiBinaryExpression) {
                Object lhConstant;
                Object rhConstant;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (tokenType == JavaTokenType.PLUS && (rhConstant = ExpressionUtils.computeConstantExpression(rhs)) != null) {
                    String rhText = ManualArrayToCollectionCopyFix.collapseConstant(rhConstant + " + (" + indexOffset + ")", expression);
                    if ("0".equals(rhText)) {
                        return lhs.getText();
                    }
                    return lhs.getText() + ManualArrayToCollectionCopyFix.getAddendum(rhText, expression);
                }
                if (tokenType == JavaTokenType.MINUS && (rhConstant = ExpressionUtils.computeConstantExpression(rhs)) != null) {
                    String rhText = ManualArrayToCollectionCopyFix.collapseConstant("(" + indexOffset + ") - " + rhConstant, expression);
                    if ("0".equals(rhText)) {
                        return lhs.getText();
                    }
                    return lhs.getText() + ManualArrayToCollectionCopyFix.getAddendum(rhText, expression);
                }
                if (rhs != null && (tokenType == JavaTokenType.PLUS || tokenType == JavaTokenType.MINUS) && (lhConstant = ExpressionUtils.computeConstantExpression(lhs)) != null) {
                    String lhText = ManualArrayToCollectionCopyFix.collapseConstant(lhConstant + " + (" + indexOffset + ")", expression);
                    if ("0".equals(lhText)) {
                        return tokenType == JavaTokenType.MINUS ? "-" + rhs.getText() : rhs.getText();
                    }
                    return lhText + (tokenType == JavaTokenType.MINUS ? " - " : " + ") + rhs.getText();
                }
            }
            String addendum = ManualArrayToCollectionCopyFix.getAddendum(indexOffset, expression);
            int precedence = ParenthesesUtils.getPrecedence(expression);
            String text = precedence > 6 ? '(' + expressionText + ")" + addendum : expressionText + addendum;
            return ManualArrayToCollectionCopyFix.collapseConstant(text, expression);
        }

        private static String getAddendum(String expressionText, PsiElement context) {
            if (expressionText.startsWith("-")) {
                String negatedExpressionText = expressionText.substring(1);
                Object lhConstant = ManualArrayToCollectionCopyFix.computeConstant(negatedExpressionText, context);
                if (lhConstant != null) {
                    return " - " + lhConstant.toString();
                }
                return " + (" + expressionText + ")";
            }
            return " + " + expressionText;
        }

        private static String collapseConstant(String expressionText, PsiElement context) throws IncorrectOperationException {
            Object fromOffsetConstant = ManualArrayToCollectionCopyFix.computeConstant(expressionText, context);
            return fromOffsetConstant != null ? fromOffsetConstant.toString() : expressionText;
        }

        private static Object computeConstant(String expressionText, PsiElement context) {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            return ExpressionUtils.computeConstantExpression(fromOffsetExpression);
        }
    }
}

