/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DEPENDENCY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("illegal.package.dependencies", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Dependency" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getShortName"));
        }
        return "Dependency";
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "checkFile"));
        }
        if (file.getViewProvider().getPsi(JavaLanguage.INSTANCE) == null) {
            return null;
        }
        final DependencyValidationManager validationManager = DependencyValidationManager.getInstance(file.getProject());
        if (!validationManager.hasRules() || validationManager.getApplicableRules(file).length == 0) {
            return null;
        }
        final List<ProblemDescriptor> problems = ContainerUtil.newSmartList();
        DependenciesBuilder.analyzeFileDependencies(file, new DependenciesBuilder.DependencyProcessor(){
            private final Map<PsiFile, DependencyRule[]> violations = new FactoryMap<PsiFile, DependencyRule[]>(){

                @Override
                @Nullable
                protected DependencyRule[] create(PsiFile dependencyFile) {
                    return validationManager.getViolatorDependencyRules(file, dependencyFile);
                }
            };

            @Override
            public void process(PsiElement place, PsiElement dependency) {
                PsiFile dependencyFile = dependency.getContainingFile();
                if (dependencyFile != null && dependencyFile.isPhysical() && dependencyFile.getVirtualFile() != null) {
                    for (DependencyRule dependencyRule : this.violations.get(dependencyFile)) {
                        String message = InspectionsBundle.message("inspection.dependency.violator.problem.descriptor", dependencyRule.getDisplayText());
                        LocalQuickFix[] fixes = DependencyInspectionBase.this.createEditDependencyFixes(dependencyRule);
                        problems.add(manager.createProblemDescriptor(place, message, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
            }
        });
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return null;
    }
}

