/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.project.ProjectBundle;
import org.jetbrains.annotations.NotNull;

class ModuleLoadingErrorDescription
extends ConfigurationErrorDescription {
    private static final ConfigurationErrorType INVALID_MODULE = new ConfigurationErrorType(ProjectBundle.message("element.kind.name.module", new Object[0]), false);
    private final ModulePath myModulePath;
    private final ModuleManagerImpl myModuleManager;

    ModuleLoadingErrorDescription(String description, @NotNull ModulePath modulePath, @NotNull ModuleManagerImpl moduleManager) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleLoadingErrorDescription", "<init>"));
        }
        if (moduleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleManager", "com/intellij/openapi/module/impl/ModuleLoadingErrorDescription", "<init>"));
        }
        super(modulePath.getModuleName(), description, INVALID_MODULE);
        this.myModulePath = modulePath;
        this.myModuleManager = moduleManager;
    }

    @NotNull
    public ModulePath getModulePath() {
        ModulePath modulePath = this.myModulePath;
        if (modulePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleLoadingErrorDescription", "getModulePath"));
        }
        return modulePath;
    }

    @Override
    public void ignoreInvalidElement() {
        this.myModuleManager.removeFailedModulePath(this.myModulePath);
    }

    @Override
    public String getIgnoreConfirmationMessage() {
        return ProjectBundle.message("module.remove.from.project.confirmation", this.getElementName());
    }
}

