/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;

public class Enumerator<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.Enumerator");
    private final TObjectIntHashMap<T> myNumbers;
    private int myNextNumber = 1;

    public Enumerator(int expectNumber, TObjectHashingStrategy<T> strategy) {
        this.myNumbers = new TObjectIntHashMap(expectNumber, strategy);
    }

    public void clear() {
        this.myNumbers.clear();
        this.myNextNumber = 1;
    }

    public int[] enumerate(T[] objects) {
        return this.enumerate(objects, 0, 0);
    }

    public int[] enumerate(T[] objects, int startShift, int endCut) {
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i2 = startShift; i2 < objects.length - endCut; ++i2) {
            int number;
            T object = objects[i2];
            idx[i2 - startShift] = number = this.enumerate(object);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res = this.enumerateImpl(object);
        return Math.max(res, -res);
    }

    public boolean add(T object) {
        int res = this.enumerateImpl(object);
        return res < 0;
    }

    public int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.get(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public int get(T object) {
        if (object == null) {
            return 0;
        }
        int res = this.myNumbers.get(object);
        if (res == 0) {
            LOG.error("Object " + object + " must be already added to enumerator!");
        }
        return res;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TObjectIntIterator iter = this.myNumbers.iterator();
        while (iter.hasNext()) {
            iter.advance();
            buffer.append(Integer.toString(iter.value()) + ": " + iter.key().toString() + "\n");
        }
        return buffer.toString();
    }
}

