/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInputOutputUtil {
    public static final long timeBase = 1040688000000L;

    private DataInputOutputUtil() {
    }

    @Nullable
    public static StringRef readNAME(@NotNull DataInput record, @NotNull AbstractStringEnumerator nameStore) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readNAME"));
        }
        if (nameStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStore", "com/intellij/util/io/DataInputOutputUtil", "readNAME"));
        }
        return StringRef.fromStream(record, nameStore);
    }

    public static void writeNAME(@NotNull DataOutput record, @Nullable String name, @NotNull AbstractStringEnumerator nameStore) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeNAME"));
        }
        if (nameStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStore", "com/intellij/util/io/DataInputOutputUtil", "writeNAME"));
        }
        int nameId = name != null ? nameStore.enumerate(name) : 0;
        DataInputOutputUtil.writeINT(record, nameId);
    }

    public static int readINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readINT"));
        }
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static long readLONG(@NotNull DataInput record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readLONG"));
        }
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeINT"));
        }
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }

    public static void writeLONG(@NotNull DataOutput record, long val) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeLONG"));
        }
        if (0L <= val && val < 192L) {
            record.writeByte((int)val);
        } else {
            record.writeByte(192 + (int)(val & 0x3FL));
            val >>>= 6;
            while (val >= 128L) {
                record.writeByte((int)(val & 0x7FL) | 0x80);
                val >>>= 7;
            }
            record.writeByte((int)val);
        }
    }

    public static int readSINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readSINT"));
        }
        return DataInputOutputUtil.readINT(record) - 64;
    }

    public static void writeSINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeSINT"));
        }
        DataInputOutputUtil.writeINT(record, val + 64);
    }

    public static void writeTIME(@NotNull DataOutput record, long timestamp) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "writeTIME"));
        }
        long relStamp = timestamp - 1040688000000L;
        if (relStamp < 0L || relStamp >= 0xFF00000000L) {
            record.writeByte(255);
            record.writeLong(timestamp);
        } else {
            record.writeByte((int)(relStamp >> 32));
            record.writeByte((int)(relStamp >> 24));
            record.writeByte((int)(relStamp >> 16));
            record.writeByte((int)(relStamp >> 8));
            record.writeByte((int)relStamp);
        }
    }

    public static long readTIME(@NotNull DataInput record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/util/io/DataInputOutputUtil", "readTIME"));
        }
        int first = record.readUnsignedByte();
        if (first == 255) {
            return record.readLong();
        }
        int second = record.readUnsignedByte();
        int third = record.readUnsignedByte() << 16;
        int fourth = record.readUnsignedByte() << 8;
        int fifth = record.readUnsignedByte();
        return ((long)(first << 8 | second) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/io/DataInputOutputUtil", "writeSeq"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/io/DataInputOutputUtil", "writeSeq"));
        }
        if (writeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeElement", "com/intellij/util/io/DataInputOutputUtil", "writeSeq"));
        }
        DataInputOutputUtil.writeINT(out, collection.size());
        for (T t : collection) {
            writeElement.consume(t);
        }
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<T, IOException> readElement) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/io/DataInputOutputUtil", "readSeq"));
        }
        if (readElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readElement", "com/intellij/util/io/DataInputOutputUtil", "readSeq"));
        }
        int size = DataInputOutputUtil.readINT(in);
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            result.add(readElement.compute());
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/DataInputOutputUtil", "readSeq"));
        }
        return arrayList;
    }

    public static <T> void writeNullable(@NotNull DataOutput out, @Nullable T value, @NotNull ThrowableConsumer<T, IOException> writeValue) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/io/DataInputOutputUtil", "writeNullable"));
        }
        if (writeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeValue", "com/intellij/util/io/DataInputOutputUtil", "writeNullable"));
        }
        out.writeBoolean(value != null);
        if (value != null) {
            writeValue.consume(value);
        }
    }

    @Nullable
    public static <T> T readNullable(@NotNull DataInput in, @NotNull ThrowableComputable<T, IOException> readValue) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/io/DataInputOutputUtil", "readNullable"));
        }
        if (readValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readValue", "com/intellij/util/io/DataInputOutputUtil", "readNullable"));
        }
        return in.readBoolean() ? (T)readValue.compute() : null;
    }
}

