/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlIncludeHandler;
import com.intellij.xml.util.XmlUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InclusionProvider
implements CachedValueProvider<PsiElement[]> {
    private final XmlTag myXincludeTag;

    public InclusionProvider(XmlTag xincludeTag) {
        this.myXincludeTag = xincludeTag;
    }

    @NotNull
    public static PsiElement[] getIncludedTags(XmlTag xincludeTag) {
        if (XmlUtil.isStubBuilding()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/InclusionProvider", "getIncludedTags"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = CachedValuesManager.getCachedValue(xincludeTag, new InclusionProvider(xincludeTag));
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/InclusionProvider", "getIncludedTags"));
        }
        return psiElementArray;
    }

    @Override
    public CachedValueProvider.Result<PsiElement[]> compute() {
        PsiElement[] result = RecursionManager.doPreventingRecursion(this.myXincludeTag, true, () -> InclusionProvider.computeInclusion(this.myXincludeTag));
        return CachedValueProvider.Result.create(result == null ? PsiElement.EMPTY_ARRAY : result, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
    }

    private static XmlTag[] extractXpointer(@NotNull XmlTag rootTag, @Nullable String xpointer) {
        String pointer;
        Matcher matcher;
        if (rootTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTag", "com/intellij/xml/util/InclusionProvider", "extractXpointer"));
        }
        if (xpointer != null && (matcher = JDOMXIncluder.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMXIncluder.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && matcher.group(1).equals(rootTag.getName())) {
            return rootTag.getSubTags();
        }
        return new XmlTag[]{rootTag};
    }

    @Nullable
    private static PsiElement[] computeInclusion(XmlTag xincludeTag) {
        XmlTag rootTag;
        XmlFile included = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
        XmlDocument document = included != null ? included.getDocument() : null;
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (rootTag != null) {
            String xpointer = xincludeTag.getAttributeValue("xpointer", "http://www.w3.org/2001/XInclude");
            XmlTag[] includeTag = InclusionProvider.extractXpointer(rootTag, xpointer);
            PsiElement[] result = new PsiElement[includeTag.length];
            for (int i2 = 0; i2 < includeTag.length; ++i2) {
                result[i2] = new IncludedXmlTag(includeTag[i2], (PsiElement)xincludeTag.getParentTag());
            }
            return result;
        }
        return null;
    }
}

