/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class MismatchedArrayReadWriteInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("MismatchedReadAndWriteOfArray" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "getID"));
        }
        return "MismatchedReadAndWriteOfArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean written = (Boolean)infos[0];
        if (written) {
            String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.write.not.read", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.read.not.write", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedArrayReadWriteVisitor();
    }

    private static class MismatchedArrayReadWriteVisitor
    extends BaseInspectionVisitor {
        private MismatchedArrayReadWriteVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "visitField"));
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!MismatchedArrayReadWriteVisitor.shouldCheckVariable(field, containingClass)) {
                return;
            }
            ArrayReadWriteVisitor visitor = new ArrayReadWriteVisitor(field, !MismatchedArrayReadWriteVisitor.isSimpleArrayExpression(field.getInitializer()));
            containingClass.accept(visitor);
            boolean written = visitor.isWritten();
            if (!visitor.isReferenced() || written == visitor.isRead()) {
                return;
            }
            this.registerFieldError(field, written);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedArrayReadWriteVisitor.shouldCheckVariable(variable, codeBlock)) {
                return;
            }
            ArrayReadWriteVisitor visitor = new ArrayReadWriteVisitor(variable, !MismatchedArrayReadWriteVisitor.isSimpleArrayExpression(variable.getInitializer()));
            codeBlock.accept(visitor);
            boolean written = visitor.isWritten();
            if (!visitor.isReferenced() || written == visitor.isRead()) {
                return;
            }
            this.registerVariableError(variable, written);
        }

        private static boolean shouldCheckVariable(PsiVariable variable, PsiElement context) {
            return context != null && variable.getType().getArrayDimensions() != 0 && !MismatchedArrayReadWriteVisitor.isComplexArrayExpression(variable.getInitializer());
        }

        static boolean isComplexArrayExpression(PsiExpression expression) {
            if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
                return false;
            }
            if (expression instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)expression;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return MismatchedArrayReadWriteVisitor.isComplexArrayExpression(arrayInitializer);
            }
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
                for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
                    if (!MismatchedArrayReadWriteVisitor.isComplexArrayExpression(initializer)) continue;
                    return true;
                }
                return false;
            }
            if (expression instanceof PsiReferenceExpression) {
                return expression.getType() instanceof PsiArrayType;
            }
            if (expression instanceof PsiArrayAccessExpression) {
                return true;
            }
            if (expression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
                return MismatchedArrayReadWriteVisitor.isComplexArrayExpression(typeCastExpression.getOperand());
            }
            if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
                return MismatchedArrayReadWriteVisitor.isComplexArrayExpression(conditionalExpression.getThenExpression()) || MismatchedArrayReadWriteVisitor.isComplexArrayExpression(conditionalExpression.getElseExpression());
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiClass aClass;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return false;
                }
                String name = method.getName();
                return !("copyOf".equals(name) || "copyOfRange".equals(name) ? (aClass = method.getContainingClass()) != null && "java.util.Arrays".equals(aClass.getQualifiedName()) : "toArray".equals(name) && InheritanceUtil.isInheritor(method.getContainingClass(), "java.util.Collection"));
            }
            return true;
        }

        static boolean isSimpleArrayExpression(PsiExpression initializer) {
            if (initializer == null) {
                return true;
            }
            if (initializer instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return arrayInitializer == null || MismatchedArrayReadWriteVisitor.isSimpleArrayExpression(arrayInitializer);
            }
            if (initializer instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                return initializers.length == 0;
            }
            return false;
        }

        private static class ArrayReadWriteVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable myVariable;
            private boolean myWritten;
            private boolean myRead;
            private boolean myIsReferenced;

            ArrayReadWriteVisitor(@NotNull PsiVariable variable, boolean written) {
                if (variable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$ArrayReadWriteVisitor", "<init>"));
                }
                this.myRead = false;
                this.myIsReferenced = false;
                this.myVariable = variable;
                this.myWritten = written;
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (this.myWritten && this.myRead) {
                    return;
                }
                super.visitReferenceExpression(expression);
                PsiElement target = expression.resolve();
                if (target != this.myVariable) {
                    return;
                }
                if (PsiUtil.isAccessedForWriting(expression)) {
                    PsiElement parent = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class);
                    if (parent instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                        PsiExpression rhs = assignmentExpression.getRExpression();
                        if (MismatchedArrayReadWriteVisitor.isComplexArrayExpression(rhs)) {
                            this.myWritten = true;
                            this.myRead = true;
                        } else if (!MismatchedArrayReadWriteVisitor.isSimpleArrayExpression(rhs)) {
                            this.myWritten = true;
                        }
                    }
                    return;
                }
                this.myIsReferenced = true;
                PsiElement parent = ArrayReadWriteVisitor.getParent(expression);
                if (parent instanceof PsiArrayAccessExpression) {
                    int dimensions;
                    PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
                    parent = ArrayReadWriteVisitor.getParent(parent);
                    while (parent instanceof PsiArrayAccessExpression) {
                        arrayAccessExpression = (PsiArrayAccessExpression)parent;
                        parent = ArrayReadWriteVisitor.getParent(parent);
                    }
                    PsiType type = arrayAccessExpression.getType();
                    if (type != null && (dimensions = type.getArrayDimensions()) > 0 && dimensions != this.myVariable.getType().getArrayDimensions()) {
                        this.myWritten = true;
                    }
                    if (PsiUtil.isAccessedForWriting(arrayAccessExpression)) {
                        this.myWritten = true;
                    }
                    if (PsiUtil.isAccessedForReading(arrayAccessExpression)) {
                        this.myRead = true;
                    }
                } else if (parent instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
                    String name = referenceExpression.getReferenceName();
                    if ("length".equals(name) || "clone".equals(name) && referenceExpression.getParent() instanceof PsiMethodCallExpression) {
                        this.myRead = true;
                    }
                } else if (parent instanceof PsiForeachStatement) {
                    PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
                    PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                    if (PsiTreeUtil.isAncestor(iteratedValue, expression, false)) {
                        this.myRead = true;
                    }
                } else if (parent instanceof PsiExpressionList) {
                    PsiClass aClass;
                    PsiMethodCallExpression methodCallExpression;
                    PsiMethod method;
                    PsiExpressionList expressionList = (PsiExpressionList)parent;
                    if ((parent = parent.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)parent).resolveMethod()) != null && (aClass = method.getContainingClass()) != null) {
                        String methodName = method.getName();
                        String qualifiedName = aClass.getQualifiedName();
                        if ("java.lang.System".equals(qualifiedName)) {
                            PsiExpression[] expressions;
                            if ("arraycopy".equals(methodName) && (expressions = expressionList.getExpressions()).length == 5) {
                                if (PsiTreeUtil.isAncestor(expressions[0], expression, false)) {
                                    this.myRead = true;
                                    return;
                                }
                                if (PsiTreeUtil.isAncestor(expressions[2], expression, false)) {
                                    this.myWritten = true;
                                    return;
                                }
                            }
                        } else if ("java.util.Arrays".equals(qualifiedName)) {
                            if ("fill".equals(methodName) || "parallelPrefix".equals(methodName) || "parallelSetAll".equals(methodName) || "parallelSort".equals(methodName) || "setAll".equals(methodName) || "sort".equals(methodName)) {
                                this.myWritten = true;
                            } else {
                                this.myRead = true;
                            }
                            return;
                        }
                    }
                    this.myRead = true;
                    this.myWritten = true;
                } else {
                    this.myWritten = true;
                    this.myRead = true;
                }
            }

            private static PsiElement getParent(PsiElement element) {
                PsiElement parent = element.getParent();
                while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression) {
                    parent = parent.getParent();
                }
                return parent;
            }

            public boolean isRead() {
                return this.myRead;
            }

            public boolean isWritten() {
                return this.myWritten;
            }

            public boolean isReferenced() {
                return this.myIsReferenced;
            }
        }
    }
}

