/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaModuleImpl
extends RefElementImpl
implements RefJavaModule {
    private final RefModule myRefModule;
    private Map<String, List<String>> myExportedPackageNames;
    private List<RefJavaModule.RequiredModule> myRequiredModules;

    public RefJavaModuleImpl(@NotNull PsiJavaModule javaModule, @NotNull RefManagerImpl manager) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "<init>"));
        }
        super(javaModule.getModuleName(), javaModule, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement(javaModule));
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "accept"));
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "lambda$accept$0"));
                }
                ((RefJavaVisitor)visitor).visitJavaModule(this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    @Nullable
    public PsiJavaModule getElement() {
        return (PsiJavaModule)super.getElement();
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getExportedPackageNames() {
        Map<String, List<String>> map = this.myExportedPackageNames != null ? this.myExportedPackageNames : Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "getExportedPackageNames"));
        }
        return map;
    }

    @Override
    @NotNull
    public List<RefJavaModule.RequiredModule> getRequiredModules() {
        List<RefJavaModule.RequiredModule> list = this.myRequiredModules != null ? this.myRequiredModules : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "getRequiredModules"));
        }
        return list;
    }

    @Override
    public void buildReferences() {
        PsiJavaModule javaModule = this.getElement();
        if (javaModule != null) {
            PsiElement element;
            for (PsiRequiresStatement statement : javaModule.getRequires()) {
                PsiJavaModuleReferenceElement referenceElement = statement.getReferenceElement();
                if (referenceElement == null || !((element = this.addReference(referenceElement.getReference())) instanceof PsiJavaModule)) continue;
                PsiJavaModule requiredModule = (PsiJavaModule)element;
                Map<String, List<String>> packagesExportedByModule = RefJavaModuleImpl.getPackagesExportedByModule(requiredModule);
                if (this.myRequiredModules == null) {
                    this.myRequiredModules = new ArrayList<RefJavaModule.RequiredModule>(1);
                }
                this.myRequiredModules.add(new RefJavaModule.RequiredModule(requiredModule.getModuleName(), packagesExportedByModule, statement.isPublic()));
            }
            List emptyList = Collections.emptyList();
            for (PsiExportsStatement statement : javaModule.getExports()) {
                element = this.addReference(statement.getPackageReference());
                String packageName = null;
                if (element instanceof PsiPackage) {
                    packageName = ((PsiPackage)element).getQualifiedName();
                    if (this.myExportedPackageNames == null) {
                        this.myExportedPackageNames = new THashMap(1);
                    }
                    this.myExportedPackageNames.put(packageName, emptyList);
                }
                for (PsiJavaModuleReferenceElement referenceElement : statement.getModuleReferences()) {
                    if (referenceElement == null) continue;
                    PsiElement moduleElement = this.addReference(referenceElement.getReference());
                    if (packageName == null || !(moduleElement instanceof PsiJavaModule)) continue;
                    List<String> toModuleNames = this.myExportedPackageNames.get(packageName);
                    if (toModuleNames == emptyList) {
                        toModuleNames = new ArrayList<String>(1);
                        this.myExportedPackageNames.put(packageName, toModuleNames);
                    }
                    toModuleNames.add(((PsiJavaModule)moduleElement).getModuleName());
                }
            }
            ((RefModuleImpl)this.myRefModule).add(this);
            this.getRefManager().fireBuildReferences(this);
        }
    }

    private PsiElement addReference(PsiPolyVariantReference reference) {
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        if (reference != null) {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
                PsiElement element = resolveResult.getElement();
                if (element == null) continue;
                resolvedElements.add(element);
                RefElement refElement = this.getRefManager().getReference(element);
                if (refElement == null) continue;
                this.addOutReference(refElement);
                ((RefElementImpl)refElement).addInReference(this);
            }
        }
        return resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
    }

    @NotNull
    private static Map<String, List<String>> getPackagesExportedByModule(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "getPackagesExportedByModule"));
        }
        THashMap exportedPackages = new THashMap();
        for (PsiExportsStatement statement : javaModule.getExports()) {
            String packageName = statement.getPackageName();
            if (packageName == null) continue;
            exportedPackages.put(packageName, statement.getModuleNames());
        }
        Object object = !exportedPackages.isEmpty() ? exportedPackages : Collections.emptyMap();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaModuleImpl", "getPackagesExportedByModule"));
        }
        return object;
    }
}

