/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryTableBase
implements PersistentStateComponentWithModificationTracker<Element>,
LibraryTable,
Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.libraries.LibraryTableBase");
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private LibraryModel myModel = new LibraryModel();
    private boolean myFirstLoad = true;
    private volatile long myModificationCount;

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        LibraryModel libraryModel = new LibraryModel(this.myModel);
        if (libraryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getModifiableModel"));
        }
        return libraryModel;
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        try {
            this.myModel.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error(e);
        }
        return element;
    }

    @Override
    public void loadState(Element element) {
        try {
            if (this.myFirstLoad) {
                this.myModel.readExternal(element);
            } else {
                LibraryModel model = new LibraryModel(this.myModel);
                WriteAction.run(() -> {
                    model.readExternal(element);
                    this.commit(model);
                });
            }
            this.myFirstLoad = false;
        }
        catch (InvalidDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getStateModificationCount() {
        return this.myModificationCount;
    }

    @Override
    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getLibraries"));
        }
        return libraryArray;
    }

    @Override
    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator = this.myModel.getLibraryIterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getLibraryIterator"));
        }
        return iterator;
    }

    @Override
    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "getLibraryByName"));
        }
        return this.myModel.getLibraryByName(name);
    }

    @Override
    public void addListener(@NotNull LibraryTable.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "addListener"));
        }
        this.myDispatcher.addListener(listener);
    }

    @Override
    public void addListener(@NotNull LibraryTable.Listener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "addListener"));
        }
        this.myDispatcher.addListener(listener, parentDisposable);
    }

    @Override
    public void removeListener(@NotNull LibraryTable.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "removeListener"));
        }
        this.myDispatcher.removeListener(listener);
    }

    private void fireLibraryAdded(Library library) {
        ++this.myModificationCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireLibraryAdded: " + library);
        }
        this.myDispatcher.getMulticaster().afterLibraryAdded(library);
    }

    private void fireBeforeLibraryRemoved(Library library) {
        ++this.myModificationCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireBeforeLibraryRemoved: " + library);
        }
        this.myDispatcher.getMulticaster().beforeLibraryRemoved(library);
    }

    @Override
    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose(library);
        }
    }

    @Override
    public Library createLibrary() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        return this.createLibrary(null);
    }

    public void fireLibraryRenamed(@NotNull LibraryImpl library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "fireLibraryRenamed"));
        }
        ++this.myModificationCount;
        this.myDispatcher.getMulticaster().afterLibraryRenamed(library);
    }

    @Override
    public Library createLibrary(String name) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        Library library = modifiableModel.createLibrary(name);
        modifiableModel.commit();
        return library;
    }

    @Override
    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase", "removeLibrary"));
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    private void commit(LibraryModel model) {
        this.myFirstLoad = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!model.isChanged()) {
            Disposer.dispose(model);
            return;
        }
        ++this.myModificationCount;
        THashSet addedLibraries = ContainerUtil.newIdentityTroveSet(model.myLibraries);
        addedLibraries.removeAll(this.myModel.myLibraries);
        THashSet removedLibraries = ContainerUtil.newIdentityTroveSet(this.myModel.myLibraries);
        removedLibraries.removeAll(model.myLibraries);
        for (Library library : removedLibraries) {
            this.fireBeforeLibraryRemoved(library);
        }
        this.myModel.copyFrom(model);
        for (Library library : removedLibraries) {
            Disposer.dispose(library);
            this.fireAfterLibraryRemoved(library);
        }
        for (Library library : addedLibraries) {
            this.fireLibraryAdded(library);
        }
        Disposer.dispose(model);
    }

    private void fireAfterLibraryRemoved(Library library) {
        this.myDispatcher.getMulticaster().afterLibraryRemoved(library);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myModel = new LibraryModel();
        this.myModel.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myModel.writeExternal(element);
    }

    public class LibraryModel
    implements LibraryTable.ModifiableModel,
    JDOMExternalizable,
    LibraryTable.Listener,
    Disposable {
        private final ArrayList<Library> myLibraries = new ArrayList();
        private volatile Map<String, Library> myLibraryByNameCache;
        private boolean myWritable;

        private LibraryModel() {
            LibraryTableBase.this.myDispatcher.addListener(this);
            this.myWritable = false;
        }

        private LibraryModel(LibraryModel that) {
            LibraryTableBase.this.myDispatcher.addListener(this);
            this.myWritable = true;
            this.myLibraries.addAll(that.myLibraries);
        }

        @Override
        public void commit() {
            LibraryTableBase.this.commit(this);
            this.myWritable = false;
        }

        @Override
        public void dispose() {
            LibraryTableBase.this.myDispatcher.removeListener(this);
        }

        @Override
        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<Library> iterator = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "getLibraryIterator"));
            }
            return iterator;
        }

        @Override
        @Nullable
        public Library getLibraryByName(@NotNull String name) {
            Library library;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "getLibraryByName"));
            }
            Map<String, Library> cache = this.myLibraryByNameCache;
            if (cache == null) {
                cache = new HashMap<String, Library>();
                for (Library library2 : this.myLibraries) {
                    cache.put(library2.getName(), library2);
                }
                this.myLibraryByNameCache = cache;
            }
            if ((library = cache.get(name)) != null) {
                return library;
            }
            String libraryPrefix = "library.";
            String libPath = System.getProperty("library." + name);
            if (libPath != null) {
                LibraryImpl libraryFromProperty = new LibraryImpl(name, null, LibraryTableBase.this, null);
                libraryFromProperty.addRoot(libPath, OrderRootType.CLASSES);
                return libraryFromProperty;
            }
            return null;
        }

        @Override
        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(new Library[this.myLibraries.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "getLibraries"));
            }
            return libraryArray;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myWritable);
        }

        @Override
        public Library createLibrary(String name) {
            return this.createLibrary(name, null);
        }

        @Override
        public Library createLibrary(String name, @Nullable PersistentLibraryKind kind) {
            this.assertWritable();
            LibraryImpl library = new LibraryImpl(name, kind, LibraryTableBase.this, null);
            this.myLibraries.add(library);
            this.myLibraryByNameCache = null;
            return library;
        }

        @Override
        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel", "removeLibrary"));
            }
            LibraryTableBase.this.myModificationCount++;
            this.assertWritable();
            this.myLibraries.remove(library);
            this.myLibraryByNameCache = null;
        }

        @Override
        public boolean isChanged() {
            if (!this.myWritable) {
                return false;
            }
            HashSet<Library> thisLibraries = new HashSet<Library>(this.myLibraries);
            HashSet<Library> thatLibraries = new HashSet<Library>(((LibraryTableBase)LibraryTableBase.this).myModel.myLibraries);
            return !thisLibraries.equals(thatLibraries);
        }

        @Override
        public void readExternal(Element element) throws InvalidDataException {
            this.myLibraries.clear();
            List libraryElements = element.getChildren("library");
            for (Element libraryElement : libraryElements) {
                LibraryImpl library = new LibraryImpl(LibraryTableBase.this, libraryElement, null);
                if (library.getName() != null) {
                    this.myLibraries.add(library);
                    LibraryTableBase.this.fireLibraryAdded(library);
                    continue;
                }
                Disposer.dispose(library);
            }
            this.myLibraryByNameCache = null;
        }

        @Override
        public void afterLibraryRenamed(Library library) {
            this.myLibraryByNameCache = null;
        }

        @Override
        public void writeExternal(Element element) throws WriteExternalException {
            List<Library> libraries = ContainerUtil.findAll(this.myLibraries, library -> !((LibraryEx)library).isDisposed());
            ContainerUtil.sort(libraries, (o1, o2) -> StringUtil.compare(o1.getName(), o2.getName(), true));
            for (Library library2 : libraries) {
                if (library2.getName() == null) continue;
                library2.writeExternal(element);
            }
        }

        void copyFrom(LibraryModel model) {
            this.myLibraries.clear();
            this.myLibraries.addAll(model.myLibraries);
            this.myLibraryByNameCache = null;
        }
    }
}

