/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceResolver
implements ResolveCache.PolyVariantContextResolver<PsiMethodReferenceExpressionImpl> {
    private static final Logger LOG = Logger.getInstance("#" + MethodReferenceResolver.class.getName());

    @NotNull
    public JavaResolveResult[] resolve(final @NotNull PsiMethodReferenceExpressionImpl reference, @NotNull PsiFile containingFile, boolean incompleteCode) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
        }
        final PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
        final PsiClass containingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor substitutor = qualifierResolveResult.getSubstitutor();
        if (containingClass != null) {
            PsiElement element = reference.getReferenceNameElement();
            boolean isConstructor = reference.isConstructor();
            if (element instanceof PsiIdentifier || isConstructor) {
                if (isConstructor && !MethodReferenceResolver.canBeConstructed(containingClass)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                final PsiType functionalInterfaceType = this.getInterfaceType(reference);
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor(interfaceMethod, resolveResult) : null;
                final MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                if (isConstructor && containingClass.getConstructors().length == 0) {
                    JavaResolveResult[] javaResolveResultArray;
                    if (interfaceMethod != null) {
                        PsiClassType returnType = MethodReferenceResolver.composeReturnType(containingClass, substitutor);
                        InferenceSession session = new InferenceSession(containingClass.getTypeParameters(), substitutor, reference.getManager(), null);
                        if (!session.isProperType(session.substituteWithInferenceVariables(returnType)) || !session.isProperType(interfaceMethodReturnType)) {
                            session.registerReturnTypeConstraints(returnType, interfaceMethodReturnType);
                            substitutor = session.infer();
                        }
                    }
                    ClassCandidateInfo candidateInfo = null;
                    boolean isArray = PsiEquivalenceUtil.areElementsEquivalent(containingClass, JavaPsiFacade.getElementFactory(reference.getProject()).getArrayClass(PsiUtil.getLanguageLevel(reference)));
                    if (signature == null || !isArray && (containingClass.getContainingClass() == null || !MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) && signature.getParameterTypes().length == 0 || isArray && MethodReferenceResolver.arrayCreationSignature(signature)) {
                        candidateInfo = new ClassCandidateInfo(containingClass, substitutor);
                    }
                    if (candidateInfo == null) {
                        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                    } else {
                        JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                        javaResolveResultArray = javaResolveResultArray2;
                        javaResolveResultArray2[0] = candidateInfo;
                    }
                    if (javaResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
                    }
                    return javaResolveResultArray;
                }
                PsiConflictResolver conflictResolver = this.createResolver(reference, qualifierResolveResult, interfaceMethod, signature);
                MethodCandidatesProcessor processor = new MethodCandidatesProcessor(reference, containingFile, new PsiConflictResolver[]{conflictResolver}, new SmartList()){

                    @Override
                    protected boolean acceptVarargs() {
                        return true;
                    }

                    @Override
                    protected MethodCandidateInfo createCandidateInfo(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, final boolean varargs) {
                        if (method == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1", "createCandidateInfo"));
                        }
                        if (substitutor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1", "createCandidateInfo"));
                        }
                        PsiExpressionList argumentList = this.getArgumentList();
                        PsiType[] typeParameters = reference.getTypeParameters();
                        return new MethodCandidateInfo(method, substitutor, !accessible, staticProblem, argumentList, this.myCurrentFileContext, argumentList != null ? argumentList.getExpressionTypes() : null, method.hasTypeParameters() && typeParameters.length > 0 ? typeParameters : null, this.getLanguageLevel()){

                            @Override
                            public boolean isVarargs() {
                                return varargs;
                            }

                            @Override
                            @NotNull
                            public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                if (policy == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1", "inferTypeArguments"));
                                }
                                PsiSubstitutor psiSubstitutor = this.inferTypeArguments(includeReturnConstraint);
                                if (psiSubstitutor == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1", "inferTypeArguments"));
                                }
                                return psiSubstitutor;
                            }

                            private PsiSubstitutor inferTypeArguments(boolean includeReturnConstraint) {
                                if (interfaceMethod == null) {
                                    return substitutor;
                                }
                                InferenceSession session = new InferenceSession(method.getTypeParameters(), substitutor, reference.getManager(), reference);
                                session.initThrowsConstraints(method);
                                PsiSubstitutor psiSubstitutor = session.collectApplicabilityConstraints(reference, this, functionalInterfaceType);
                                if (psiSubstitutor != null) {
                                    return psiSubstitutor;
                                }
                                if (!session.repeatInferencePhases()) {
                                    return substitutor;
                                }
                                if (includeReturnConstraint && !PsiType.VOID.equals(interfaceMethodReturnType) && interfaceMethodReturnType != null) {
                                    PsiType returnType;
                                    PsiSubstitutor subst = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, method, containingClass, reference);
                                    PsiType psiType = returnType = method.isConstructor() ? MethodReferenceResolver.composeReturnType(containingClass, subst) : subst.substitute(method.getReturnType());
                                    if (returnType != null) {
                                        session.registerReturnTypeConstraints(returnType, interfaceMethodReturnType);
                                    }
                                }
                                return session.infer(method.getParameterList().getParameters(), null, null);
                            }

                            @Override
                            public boolean isApplicable() {
                                boolean hasReceiver;
                                if (signature == null) {
                                    return false;
                                }
                                PsiType[] argTypes = signature.getParameterTypes();
                                return MethodReferenceConflictResolver.isApplicableByFirstSearch(this, argTypes, hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, qualifierResolveResult, reference), reference, interfaceMethod.isVarArgs()) != null;
                            }
                        };
                    }
                };
                processor.setIsConstructor(isConstructor);
                processor.setName(isConstructor ? containingClass.getName() : element.getText());
                PsiExpression expression = reference.getQualifierExpression();
                if (expression == null || !(expression.getType() instanceof PsiArrayType)) {
                    processor.setAccessClass(containingClass);
                }
                if (qualifierResolveResult.isReferenceTypeQualified() && MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) {
                    processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                }
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
                containingClass.processDeclarations(processor, state, reference, reference);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
                }
                return javaResolveResultArray;
            }
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public static boolean canBeConstructed(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "canBeConstructed"));
        }
        return !psiClass.isEnum() && !psiClass.hasModifierProperty("abstract") && !(psiClass instanceof PsiTypeParameter);
    }

    private static boolean isLocatedInStaticContext(PsiClass containingClass, PsiMethodReferenceExpression reference) {
        PsiClass gContainingClass = containingClass.getContainingClass();
        if (gContainingClass == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor(gContainingClass != null ? gContainingClass : containingClass, reference, false)) {
                PsiClass psiClass = aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            if (PsiUtil.getEnclosingStaticElement(reference, aClass) != null) {
                return true;
            }
        }
        return false;
    }

    protected PsiType getInterfaceType(PsiMethodReferenceExpression reference) {
        return reference.getFunctionalInterfaceType();
    }

    protected PsiConflictResolver createResolver(PsiMethodReferenceExpressionImpl referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
        return new MethodReferenceConflictResolver(referenceExpression, qualifierResolveResult, signature, interfaceMethod != null && interfaceMethod.isVarArgs());
    }

    private static PsiClassType composeReturnType(PsiClass containingClass, PsiSubstitutor substitutor) {
        boolean isRawSubst = PsiUtil.isRawSubstitutor(containingClass, substitutor);
        return JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor);
    }

    private static boolean arrayCreationSignature(MethodSignature signature) {
        PsiType[] parameterTypes = signature.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0] != null && TypeConversionUtil.isAssignable(PsiType.INT, parameterTypes[0]);
    }

    private static class MethodReferenceConflictResolver
    extends JavaMethodsConflictResolver {
        private final MethodSignature mySignature;
        private final PsiMethodReferenceExpressionImpl myReferenceExpression;
        private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
        private final boolean myFunctionalMethodVarArgs;

        private MethodReferenceConflictResolver(PsiMethodReferenceExpressionImpl referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature, boolean varArgs) {
            super(referenceExpression, signature != null ? signature.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel(referenceExpression));
            this.myReferenceExpression = referenceExpression;
            this.myQualifierResolveResult = qualifierResolveResult;
            this.myFunctionalMethodVarArgs = varArgs;
            this.mySignature = signature;
        }

        @Override
        protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
            if (conflict == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver", "getPertinentApplicabilityLevel"));
            }
            return conflict.isVarargs() ? 2 : 3;
        }

        @Override
        @Nullable
        protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
            if (conflicts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver", "guardedOverloadResolution"));
            }
            if (this.mySignature == null) {
                return null;
            }
            if (conflicts.isEmpty()) {
                return null;
            }
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            this.checkSameSignatures(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            PsiType[] argTypes = this.mySignature.getParameterTypes();
            boolean hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, this.myQualifierResolveResult, this.myReferenceExpression);
            ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
            ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo conflict : conflicts) {
                Boolean applicableByFirstSearch;
                if (!(conflict instanceof MethodCandidateInfo) || (applicableByFirstSearch = MethodReferenceConflictResolver.isApplicableByFirstSearch(conflict, argTypes, hasReceiver, this.myReferenceExpression, this.myFunctionalMethodVarArgs)) == null) continue;
                (applicableByFirstSearch != false ? firstCandidates : secondCandidates).add(conflict);
            }
            if (this.myQualifierResolveResult.isReferenceTypeQualified() && this.myReferenceExpression.getReferenceNameElement() instanceof PsiIdentifier) {
                CandidateInfo candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(firstCandidates, secondCandidates, true);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(secondCandidates, firstCandidates, false);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
            }
            if (this.resolveConflicts(firstCandidates, secondCandidates, 3)) {
                return !firstCandidates.isEmpty() ? (CandidateInfo)firstCandidates.get(0) : (CandidateInfo)secondCandidates.get(0);
            }
            if (this.resolveConflicts(firstCandidates, secondCandidates, 2)) {
                return !firstCandidates.isEmpty() ? (CandidateInfo)firstCandidates.get(0) : (CandidateInfo)secondCandidates.get(0);
            }
            if (firstCandidates.isEmpty() && secondCandidates.isEmpty()) {
                return null;
            }
            conflicts.clear();
            firstCandidates.addAll(secondCandidates);
            conflicts.addAll(firstCandidates);
            return null;
        }

        private static Boolean isApplicableByFirstSearch(CandidateInfo conflict, PsiType[] functionalInterfaceParamTypes, boolean hasReceiver, PsiMethodReferenceExpression referenceExpression, boolean functionalMethodVarArgs) {
            PsiMethod psiMethod = ((MethodCandidateInfo)conflict).getElement();
            PsiSubstitutor substitutor = ((MethodCandidateInfo)conflict).getSubstitutor(false);
            PsiType[] parameterTypes = psiMethod.getSignature(substitutor).getParameterTypes();
            boolean varargs = ((MethodCandidateInfo)conflict).isVarargs();
            if (varargs && (!psiMethod.isVarArgs() || functionalMethodVarArgs)) {
                return null;
            }
            if ((varargs || functionalInterfaceParamTypes.length == parameterTypes.length) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, varargs, referenceExpression, conflict, 0)) {
                return true;
            }
            if (hasReceiver && (varargs || functionalInterfaceParamTypes.length == parameterTypes.length + 1) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, varargs, referenceExpression, conflict, 1)) {
                return false;
            }
            return null;
        }

        private static boolean isCorrectAssignment(PsiType[] parameterTypes, PsiType[] functionalInterfaceParamTypes, boolean varargs, PsiMethodReferenceExpression referenceExpression, CandidateInfo conflict, int offset) {
            int min = Math.min(parameterTypes.length, functionalInterfaceParamTypes.length - offset);
            for (int i2 = 0; i2 < min; ++i2) {
                PsiType argType = PsiUtil.captureToplevelWildcards(functionalInterfaceParamTypes[i2 + offset], referenceExpression);
                PsiType parameterType = parameterTypes[i2];
                if (varargs && i2 == parameterTypes.length - 1) {
                    if (TypeConversionUtil.isAssignable(parameterType, argType) || TypeConversionUtil.isAssignable(((PsiArrayType)parameterType).getComponentType(), argType)) continue;
                    MethodReferenceConflictResolver.reportParameterConflict(referenceExpression, conflict, argType, parameterType);
                    return false;
                }
                if (TypeConversionUtil.isAssignable(parameterType, argType)) continue;
                MethodReferenceConflictResolver.reportParameterConflict(referenceExpression, conflict, argType, parameterType);
                return false;
            }
            return !varargs || parameterTypes.length - 1 <= functionalInterfaceParamTypes.length - offset;
        }

        private static void reportParameterConflict(PsiMethodReferenceExpression referenceExpression, CandidateInfo conflict, PsiType argType, PsiType parameterType) {
            if (conflict instanceof MethodCandidateInfo) {
                ((MethodCandidateInfo)conflict).setInferenceError("Invalid " + (referenceExpression.isConstructor() ? "constructor" : "method") + " reference: " + argType.getPresentableText() + " cannot be converted to " + parameterType.getPresentableText());
            }
        }

        private boolean resolveConflicts(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, int applicabilityLevel) {
            int firstApplicability = this.checkApplicability(firstCandidates);
            this.checkSpecifics(firstCandidates, applicabilityLevel, this.myLanguageLevel);
            int secondApplicability = this.checkApplicability(secondCandidates);
            this.checkSpecifics(secondCandidates, applicabilityLevel, this.myLanguageLevel);
            if (firstApplicability < secondApplicability) {
                return secondCandidates.size() == 1;
            }
            if (secondApplicability < firstApplicability) {
                return firstCandidates.size() == 1;
            }
            return firstCandidates.size() + secondCandidates.size() == 1;
        }

        @Override
        protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver", "nonComparable"));
            }
            if (conflict == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver", "nonComparable"));
            }
            if (method == conflict) {
                return true;
            }
            PsiElement psiElement = method.getElement();
            PsiElement conflictElement = conflict.getElement();
            return psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod && fixedArity && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
        }

        private static CandidateInfo filterStaticCorrectCandidates(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
            CandidateInfo candidateInfo;
            PsiElement element;
            if (firstCandidates.size() == 1 && (element = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                if (shouldBeStatic && isStatic || !shouldBeStatic && !isStatic) {
                    for (CandidateInfo secondCandidate : secondCandidates) {
                        PsiElement psiElement = secondCandidate.getElement();
                        if (!(psiElement instanceof PsiMethod)) continue;
                        boolean oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static");
                        if ((!shouldBeStatic || oppositeStatic) && (shouldBeStatic || !oppositeStatic)) continue;
                        return null;
                    }
                    return candidateInfo;
                }
            }
            return null;
        }
    }
}

