/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.UpdateData;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleUpdateData<Key, Value>
extends UpdateData<Key, Value> {
    public SimpleUpdateData(@NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<ForwardIndex.InputKeyIterator<Key, Value>, IOException> currentData, @NotNull ID<Key, Value> indexId, ThrowableRunnable<IOException> forwardIndexUpdate) {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/util/indexing/impl/SimpleUpdateData", "<init>"));
        }
        if (currentData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentData", "com/intellij/util/indexing/impl/SimpleUpdateData", "<init>"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/impl/SimpleUpdateData", "<init>"));
        }
        super(newData, currentData, indexId, forwardIndexUpdate);
    }

    @Override
    public void iterateKeys(int inputId, UpdateData.KeyValueUpdateProcessor<Key, Value> addProcessor, UpdateData.KeyValueUpdateProcessor<Key, Value> updateProcessor, UpdateData.RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        ForwardIndex.InputKeyIterator currentData;
        try {
            currentData = (ForwardIndex.InputKeyIterator)this.myCurrentData.compute();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        this.iterateKeys(inputId, addProcessor, removeProcessor, currentData);
    }

    protected void iterateKeys(int inputId, UpdateData.KeyValueUpdateProcessor<Key, Value> addProcessor, UpdateData.RemovedKeyProcessor<Key> removeProcessor, ForwardIndex.InputKeyIterator<Key, Value> currentData) throws StorageException {
        while (currentData.hasNext()) {
            removeProcessor.process(currentData.next(), inputId);
        }
        for (Map.Entry entry : this.myNewData.entrySet()) {
            addProcessor.process(entry.getKey(), entry.getValue(), inputId);
        }
    }
}

