/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.SystemProperties;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.BufferedImageGraphicsConfig;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    public static final String USER_SCALE_FACTOR_PROPERTY = "JBUI.userScaleFactor";
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new JBUI());
    public static final Float SYSTEM_SCALE_FACTOR = Float.valueOf(JBUI.sysScale());
    private static float userScaleFactor;

    public static void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PCS.addPropertyChangeListener(propertyName, listener);
    }

    public static void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PCS.removePropertyChangeListener(propertyName, listener);
    }

    public static float sysScale() {
        if (SYSTEM_SCALE_FACTOR != null) {
            return SYSTEM_SCALE_FACTOR.floatValue();
        }
        if (UIUtil.isJDKManagedHiDPI()) {
            GraphicsDevice gd = null;
            try {
                gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (gd != null) {
                return JBUI.sysScale(gd);
            }
            return 1.0f;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return 1.0f;
        }
        UIUtil.initSystemFontData();
        Pair<String, Integer> fdata = UIUtil.getSystemFontData();
        int size = fdata != null ? fdata.getSecond().intValue() : Fonts.label().getSize();
        return (float)size / 12.0f;
    }

    public static float sysScale(JBUIScaleTrackable trackable) {
        if (UIUtil.isJDKManagedHiDPI() && trackable != null) {
            return trackable.getJBUIScale(ScaleType.SYS);
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (UIUtil.isJDKManagedHiDPI() && g != null) {
            GraphicsConfiguration conf = g.getDeviceConfiguration();
            if (conf instanceof BufferedImageGraphicsConfig) {
                return (float)g.getTransform().getScaleX();
            }
            if (conf != null) {
                return JBUI.sysScale(conf.getDevice());
            }
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable GraphicsDevice gd) {
        if (UIUtil.isJDKManagedHiDPI() && gd != null) {
            if (SystemInfo.isMac && UIUtil.isJDKManagedHiDPI_earlierVersion()) {
                return UIUtil.DetectRetinaKit.isOracleMacRetinaDevice(gd) ? 2.0f : 1.0f;
            }
            return (float)gd.getDefaultConfiguration().getDefaultTransform().getScaleX();
        }
        return JBUI.sysScale();
    }

    public static float pixScale() {
        return UIUtil.isJDKManagedHiDPI() ? JBUI.sysScale() * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable Graphics2D g, float f) {
        return JBUI.pixScale(g) * f;
    }

    public static float pixScale(@NotNull JBUIScaleTrackable trackable) {
        if (trackable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackable", "com/intellij/util/ui/JBUI", "pixScale"));
        }
        return UIUtil.isJDKManagedHiDPI() ? JBUI.sysScale(trackable) * trackable.getJBUIScale(ScaleType.USR) : trackable.getJBUIScale(ScaleType.USR);
    }

    public static float pixScale(@Nullable Graphics2D g) {
        return g != null ? JBUI.pixScale(g.getDeviceConfiguration().getDevice()) : JBUI.pixScale();
    }

    public static float pixScale(@Nullable GraphicsDevice gd) {
        return UIUtil.isJDKManagedHiDPI() ? JBUI.sysScale(gd) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    private static void setUserScaleFactorProperty(float scale) {
        Float f = Float.valueOf(userScaleFactor);
        userScaleFactor = scale;
        PCS.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, f, Float.valueOf(userScaleFactor));
        LOG.info("UI scale factor: " + userScaleFactor);
    }

    public static void setUserScaleFactor(float scale) {
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            JBUI.setUserScaleFactorProperty(1.0f);
            return;
        }
        scale = scale < 1.25f ? 1.0f : (scale < 1.5f ? 1.25f : (scale < 1.75f ? 1.5f : (scale < 2.0f ? 1.75f : 2.0f)));
        if (SystemInfo.isLinux && scale == 1.25f) {
            scale = 1.0f;
        }
        if (userScaleFactor == scale) {
            return;
        }
        JBUI.setUserScaleFactorProperty(scale);
    }

    public static float scale(float f) {
        return f * userScaleFactor;
    }

    public static int scale(int i2) {
        return Math.round(userScaleFactor * (float)i2);
    }

    public static int scaleFontSize(float fontSize) {
        if (userScaleFactor == 1.25f) {
            return (int)(fontSize * 1.34f);
        }
        if (userScaleFactor == 1.75f) {
            return (int)(fontSize * 1.67f);
        }
        return (int)JBUI.scale(fontSize);
    }

    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension jbSize = (JBDimension)size;
            if (jbSize.myJBUIScale == JBUI.scale(1.0f)) {
                return jbSize;
            }
            JBDimension newSize = new JBDimension((int)((float)jbSize.width / jbSize.myJBUIScale), (int)((float)jbSize.height / jbSize.myJBUIScale));
            return size instanceof UIResource ? newSize.asUIResource() : newSize;
        }
        return new JBDimension(size.width, size.height);
    }

    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    public static JBInsets insets(int all2) {
        return JBUI.insets(all2, all2, all2, all2);
    }

    public static JBInsets insets(int topBottom, int leftRight) {
        return JBUI.insets(topBottom, leftRight, topBottom, leftRight);
    }

    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    public static JBInsets insetsTop(int t) {
        return JBUI.insets(t, 0, 0, 0);
    }

    public static JBInsets insetsLeft(int l) {
        return JBUI.insets(0, l, 0, 0);
    }

    public static JBInsets insetsBottom(int b) {
        return JBUI.insets(0, 0, b, 0);
    }

    public static JBInsets insetsRight(int r) {
        return JBUI.insets(0, 0, 0, r);
    }

    public static EmptyIcon emptyIcon(int size) {
        return JBUI.scale(EmptyIcon.create(size));
    }

    public static <T extends JBIcon> T scale(T icon) {
        return (T)icon.withJBUIPreScaled(false);
    }

    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    public static JBInsets insets(Insets insets) {
        return JBInsets.create(insets);
    }

    @Deprecated
    public static boolean isHiDPI() {
        return JBUI.isHiDPI(ScaleType.USR);
    }

    public static boolean isHiDPI(@Nullable Graphics2D g, ScaleType type) {
        return g != null ? JBUI.isHiDPI(g.getDeviceConfiguration().getDevice(), type) : JBUI.isHiDPI((GraphicsDevice)null, type);
    }

    public static boolean isHiDPI(@Nullable GraphicsDevice gd, ScaleType type) {
        switch (type) {
            case USR: {
                return JBUI.scale(1.0f) > 1.0f;
            }
            case SYS: {
                return JBUI.sysScale(gd) > 1.0f;
            }
            case PIX: {
                return JBUI.pixScale(gd) > 1.0f;
            }
        }
        return false;
    }

    public static boolean isHiDPI(ScaleType type) {
        return JBUI.isHiDPI((GraphicsDevice)null, type);
    }

    public static boolean isHiDPI(@Nullable Component component) {
        Graphics graphics = component != null ? component.getGraphics() : null;
        try {
            boolean bl = JBUI.isHiDPI((Graphics2D)graphics, ScaleType.USR);
            return bl;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    static {
        JBUI.setUserScaleFactor(UIUtil.isJDKManagedHiDPI() ? 1.0f : SYSTEM_SCALE_FACTOR.floatValue());
    }

    public static abstract class AuxScalableJBIcon
    extends CachingScalableJBIcon
    implements JBUIScaleTrackable {
        private JBUIScaleTracker myJBUIScaleDelegate = new JBUIScaleTracker();

        protected AuxScalableJBIcon() {
        }

        protected AuxScalableJBIcon(AuxScalableJBIcon icon) {
            super(icon);
        }

        @Override
        public boolean updateJBUIScale() {
            return this.myJBUIScaleDelegate.updateJBUIScale();
        }

        @Override
        public boolean updateJBUIScale(@Nullable Graphics2D g) {
            return this.myJBUIScaleDelegate.updateJBUIScale(g);
        }

        @Override
        public boolean needUpdateJBUIScale() {
            return this.myJBUIScaleDelegate.needUpdateJBUIScale();
        }

        @Override
        public boolean needUpdateJBUIScale(@Nullable Graphics2D g) {
            return this.myJBUIScaleDelegate.needUpdateJBUIScale(g);
        }

        @Override
        public float getJBUIScale(ScaleType type) {
            return this.myJBUIScaleDelegate.getJBUIScale(type);
        }
    }

    public static abstract class AuxJBIcon
    extends JBIcon
    implements JBUIScaleTrackable {
        private JBUIScaleTracker myJBUIScaleDelegate = new JBUIScaleTracker();

        @Override
        public boolean updateJBUIScale() {
            return this.myJBUIScaleDelegate.updateJBUIScale();
        }

        @Override
        public boolean updateJBUIScale(@Nullable Graphics2D g) {
            return this.myJBUIScaleDelegate.updateJBUIScale(g);
        }

        @Override
        public boolean needUpdateJBUIScale() {
            return this.myJBUIScaleDelegate.needUpdateJBUIScale();
        }

        @Override
        public boolean needUpdateJBUIScale(@Nullable Graphics2D g) {
            return this.myJBUIScaleDelegate.needUpdateJBUIScale(g);
        }

        @Override
        public float getJBUIScale(ScaleType type) {
            return this.myJBUIScaleDelegate.getJBUIScale(type);
        }
    }

    private static class JBUIScaleTracker
    implements JBUIScaleTrackable {
        KeyFMap myTrackedJBUIScale = KeyFMap.EMPTY_MAP;

        private JBUIScaleTracker() {
            this.put(ScaleType.USR.key, Float.valueOf(JBIcon.currentJBUIScale()));
            this.put(ScaleType.SYS.key, Float.valueOf(JBUI.sysScale()));
        }

        private void put(Key<Float> key, Float value) {
            this.myTrackedJBUIScale = this.myTrackedJBUIScale.plus(key, value);
        }

        @Override
        public boolean updateJBUIScale() {
            return this.updateJBUIScale(JBIcon.currentJBUIScale(), ScaleType.USR);
        }

        private boolean updateJBUIScale(float scale, ScaleType type) {
            if (this.needUpdateJBUIScale(scale, type)) {
                this.put(type.key, Float.valueOf(scale));
                return true;
            }
            return false;
        }

        @Override
        public boolean updateJBUIScale(@Nullable Graphics2D g) {
            boolean res = this.updateJBUIScale();
            if (g != null) {
                res = res || this.updateJBUIScale(JBUI.sysScale(g), ScaleType.SYS);
            }
            return res;
        }

        @Override
        public boolean needUpdateJBUIScale() {
            return this.needUpdateJBUIScale(JBIcon.currentJBUIScale(), ScaleType.USR);
        }

        private boolean needUpdateJBUIScale(float scale, ScaleType type) {
            return this.getJBUIScale(type) != scale;
        }

        @Override
        public boolean needUpdateJBUIScale(@Nullable Graphics2D g) {
            return this.needUpdateJBUIScale() || g != null && this.needUpdateJBUIScale(JBUI.sysScale(g), ScaleType.SYS);
        }

        @Override
        public float getJBUIScale(ScaleType type) {
            return type == ScaleType.PIX ? JBUI.pixScale(this) : ((Float)this.myTrackedJBUIScale.get(type.key)).floatValue();
        }
    }

    public static interface JBUIScaleTrackable {
        public boolean updateJBUIScale();

        public boolean updateJBUIScale(@Nullable Graphics2D var1);

        public boolean needUpdateJBUIScale();

        public boolean needUpdateJBUIScale(@Nullable Graphics2D var1);

        public float getJBUIScale(ScaleType var1);
    }

    public static abstract class CachingScalableJBIcon<T extends CachingScalableJBIcon>
    extends ScalableJBIcon {
        private CachingScalableJBIcon myScaledIconCache;

        protected CachingScalableJBIcon() {
        }

        protected CachingScalableJBIcon(CachingScalableJBIcon icon) {
            super(icon);
            this.myScaledIconCache = null;
        }

        @Override
        public Icon scale(float scale) {
            if (scale == this.getScale()) {
                return this;
            }
            if (this.myScaledIconCache == null || this.myScaledIconCache.getScale() != scale) {
                this.myScaledIconCache = this.copy();
                this.myScaledIconCache.setScale(scale);
            }
            return this.myScaledIconCache;
        }

        @NotNull
        protected abstract T copy();
    }

    public static abstract class ScalableJBIcon
    extends JBIcon
    implements ScalableIcon {
        private float myScale = 1.0f;

        protected ScalableJBIcon() {
        }

        protected ScalableJBIcon(ScalableJBIcon icon) {
            super(icon);
            this.myScale = icon.myScale;
        }

        @Override
        public float getScale() {
            return this.myScale;
        }

        protected void setScale(float scale) {
            this.myScale = scale;
        }

        @Override
        public int scaleVal(int value) {
            return this.scaleVal(value, Scale.EFFECTIVE);
        }

        @Override
        public float scaleVal(float value) {
            return this.scaleVal(value, Scale.EFFECTIVE);
        }

        public int scaleVal(int value, Scale type) {
            return (int)this.scaleVal((float)value, type);
        }

        public float scaleVal(float value, Scale type) {
            switch (type) {
                case JBUI: {
                    return super.scaleVal(value);
                }
                case INSTANCE: {
                    return value * this.myScale;
                }
            }
            return super.scaleVal(value * this.myScale);
        }

        public static int scaleVal(Icon icon, int value, Scale type) {
            return (int)ScalableJBIcon.scaleVal(icon, (float)value, type);
        }

        public static float scaleVal(Icon icon, float value, Scale type) {
            if (icon instanceof ScalableJBIcon) {
                return ((ScalableJBIcon)icon).scaleVal(value, type);
            }
            return value;
        }

        public static enum Scale {
            JBUI,
            INSTANCE,
            EFFECTIVE;

        }
    }

    public static abstract class JBIcon
    implements Icon {
        private float myInitialJBUIScale = JBIcon.currentJBUIScale();

        protected JBIcon() {
        }

        protected JBIcon(JBIcon icon) {
            this.myInitialJBUIScale = icon.myInitialJBUIScale;
        }

        static float currentJBUIScale() {
            return UIUtil.isJDKManagedHiDPI() ? 1.0f : JBUI.scale(1.0f);
        }

        private float getAligningScale() {
            return JBIcon.currentJBUIScale() / this.myInitialJBUIScale;
        }

        protected boolean isJBUIPreScaled() {
            return this.myInitialJBUIScale != 1.0f;
        }

        protected void setJBUIPreScaled(boolean preScaled) {
            this.myInitialJBUIScale = preScaled ? JBIcon.currentJBUIScale() : 1.0f;
        }

        public JBIcon withJBUIPreScaled(boolean preScaled) {
            this.setJBUIPreScaled(preScaled);
            return this;
        }

        public int scaleVal(int value) {
            return (int)this.scaleVal((float)value);
        }

        public float scaleVal(float value) {
            return value * this.getAligningScale();
        }
    }

    public static class ComboBox {
    }

    public static class Panels {
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        public static BorderLayoutPanel simplePanel(Component comp) {
            return Panels.simplePanel().addToCenter(comp);
        }

        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }
    }

    public static class Borders {
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            return new JBEmptyBorder(top, left, bottom, right);
        }

        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
        }

        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extra", "com/intellij/util/ui/JBUI$Borders", "merge"));
            }
            if (source == null) {
                return extra;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }

        public static JBFont label(float size) {
            return Fonts.label().deriveFont(JBUI.scale(size));
        }

        public static JBFont smallFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
        }

        public static JBFont miniFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
        }

        public static JBFont create(String fontFamily, int size) {
            return JBFont.create(new Font(fontFamily, 0, size));
        }
    }

    public static enum ScaleType {
        USR,
        SYS,
        PIX;

        private final Key<Float> key = Key.create(this.name());
    }
}

