/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SchemaNSDescriptor
extends XmlNSDescriptorImpl {
    @NonNls
    private static final String MIN_OCCURS_ATTR_NAME = "minOccurs";
    @NonNls
    private static final String MAX_OCCURS_ATTR_VALUE = "maxOccurs";
    @NonNls
    private static final String MAX_OCCURS_ATTR_NAME = "maxOccurs";
    @NonNls
    private static final String ID_ATTR_NAME = "id";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String DEFAULT_ATTR_NAME = "default";
    @NonNls
    private static final String FIXED_ATTR_NAME = "fixed";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    private static final Validator<XmlTag> ELEMENT_VALIDATOR = new Validator<XmlTag>(){

        @Override
        public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
            boolean hasRefAttribute;
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/impl/schema/SchemaNSDescriptor$1", "validate"));
            }
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/xml/impl/schema/SchemaNSDescriptor$1", "validate"));
            }
            if (!SchemaNSDescriptor.isFromSchemaNs(tag)) {
                return;
            }
            boolean bl = hasRefAttribute = tag.getAttributeValue(SchemaNSDescriptor.REF_ATTR_NAME) != null;
            if (hasRefAttribute) {
                for (XmlAttribute attr : tag.getAttributes()) {
                    String name = attr.getName();
                    if (name.indexOf(58) != -1 || SchemaNSDescriptor.MIN_OCCURS_ATTR_NAME.equals(name) || "maxOccurs".equals(name) || SchemaNSDescriptor.ID_ATTR_NAME.equals(name) || SchemaNSDescriptor.REF_ATTR_NAME.equals(name)) continue;
                    host.addMessage((PsiElement)attr.getNameElement(), XmlErrorMessages.message("xml.schema.validation.attr.not.allowed.with.ref", name), Validator.ValidationHost.ErrorType.ERROR);
                }
            }
            String minOccursValue = tag.getAttributeValue(SchemaNSDescriptor.MIN_OCCURS_ATTR_NAME);
            String maxOccursValue = tag.getAttributeValue("maxOccurs");
            if (minOccursValue != null && maxOccursValue != null) {
                try {
                    int minOccurs = Integer.parseInt(minOccursValue);
                    int maxOccurs = Integer.parseInt(maxOccursValue);
                    if (maxOccurs < minOccurs) {
                        host.addMessage((PsiElement)tag.getAttribute("maxOccurs", null).getValueElement(), XmlErrorMessages.message("xml.schema.validation.max.occurs.should.be.not.less.than.min.occurs", new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!hasRefAttribute && tag.getAttributeValue(SchemaNSDescriptor.NAME_ATTR_NAME) == null) {
                host.addMessage((PsiElement)tag, XmlErrorMessages.message("xml.schema.validation.name.or.ref.should.present", new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
            }
        }
    };
    private static final Validator<XmlTag> ATTRIBUTE_VALIDATOR = new Validator<XmlTag>(){

        @Override
        public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/impl/schema/SchemaNSDescriptor$2", "validate"));
            }
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/xml/impl/schema/SchemaNSDescriptor$2", "validate"));
            }
            if (!SchemaNSDescriptor.isFromSchemaNs(tag)) {
                return;
            }
            if (tag.getAttributeValue(SchemaNSDescriptor.REF_ATTR_NAME) == null && tag.getAttributeValue(SchemaNSDescriptor.NAME_ATTR_NAME) == null) {
                host.addMessage((PsiElement)tag, XmlErrorMessages.message("xml.schema.validation.name.or.ref.should.present", new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
            }
            if (tag.getAttributeValue(SchemaNSDescriptor.DEFAULT_ATTR_NAME) != null && tag.getAttributeValue(SchemaNSDescriptor.FIXED_ATTR_NAME) != null) {
                host.addMessage((PsiElement)tag.getAttribute(SchemaNSDescriptor.DEFAULT_ATTR_NAME, null).getNameElement(), XmlErrorMessages.message("xml.schema.validation.default.or.fixed.should.be.specified.but.not.both", new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
                host.addMessage((PsiElement)tag.getAttribute(SchemaNSDescriptor.FIXED_ATTR_NAME, null).getNameElement(), XmlErrorMessages.message("xml.schema.validation.default.or.fixed.should.be.specified.but.not.both", new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
            }
        }
    };
    private static final XmlUtil.DuplicationInfoProvider<XmlTag> SCHEMA_ATTR_DUP_INFO_PROVIDER = new XmlUtil.DuplicationInfoProvider<XmlTag>(){

        @Override
        public String getName(@NotNull XmlTag t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/xml/impl/schema/SchemaNSDescriptor$3", "getName"));
            }
            return t.getAttributeValue(SchemaNSDescriptor.NAME_ATTR_NAME);
        }

        @Override
        @NotNull
        public String getNameKey(@NotNull XmlTag t, @NotNull String name) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/xml/impl/schema/SchemaNSDescriptor$3", "getNameKey"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SchemaNSDescriptor.NAME_ATTR_NAME, "com/intellij/xml/impl/schema/SchemaNSDescriptor$3", "getNameKey"));
            }
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/schema/SchemaNSDescriptor$3", "getNameKey"));
            }
            return string;
        }

        @Override
        @NotNull
        public PsiElement getNodeForMessage(@NotNull XmlTag t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/xml/impl/schema/SchemaNSDescriptor$3", "getNodeForMessage"));
            }
            XmlAttributeValue xmlAttributeValue = t.getAttribute(SchemaNSDescriptor.NAME_ATTR_NAME, null).getValueElement();
            if (xmlAttributeValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/schema/SchemaNSDescriptor$3", "getNodeForMessage"));
            }
            return xmlAttributeValue;
        }
    };
    private static final Validator<XmlTag> ELEMENT_AND_ATTR_VALIDATOR = new Validator<XmlTag>(){

        @Override
        public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/impl/schema/SchemaNSDescriptor$4", "validate"));
            }
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/xml/impl/schema/SchemaNSDescriptor$4", "validate"));
            }
            if (!SchemaNSDescriptor.isFromSchemaNs(tag)) {
                return;
            }
            String nsPrefix = tag.getNamespacePrefix();
            PsiElement[] attrDeclTags = tag.findSubTags((nsPrefix.length() > 0 ? nsPrefix + ":" : "") + "attribute");
            XmlUtil.doDuplicationCheckForElements((PsiElement[])attrDeclTags, new HashMap(attrDeclTags.length), (XmlUtil.DuplicationInfoProvider)SCHEMA_ATTR_DUP_INFO_PROVIDER, (Validator.ValidationHost)host);
            PsiElement[] elementDeclTags = tag.findSubTags((nsPrefix.length() > 0 ? nsPrefix + ":" : "") + "element");
            XmlUtil.doDuplicationCheckForElements((PsiElement[])elementDeclTags, new HashMap(elementDeclTags.length), (XmlUtil.DuplicationInfoProvider)SCHEMA_ATTR_DUP_INFO_PROVIDER, (Validator.ValidationHost)host);
        }
    };

    private static boolean isFromSchemaNs(XmlTag tag) {
        return "http://www.w3.org/2001/XMLSchema".equals(tag.getNamespace());
    }

    @Override
    protected XmlElementDescriptor createElementDescriptor(XmlTag tag) {
        XmlElementDescriptor descriptor = super.createElementDescriptor(tag);
        String localName = tag.getAttributeValue(NAME_ATTR_NAME);
        if ("element".equals(localName)) {
            ((XmlElementDescriptorImpl)descriptor).setValidator(ELEMENT_VALIDATOR);
        } else if ("complexType".equals(localName) || "schema".equals(localName) || "sequence".equals(localName)) {
            ((XmlElementDescriptorImpl)descriptor).setValidator(ELEMENT_AND_ATTR_VALIDATOR);
        } else if ("attribute".equals(localName)) {
            ((XmlElementDescriptorImpl)descriptor).setValidator(ATTRIBUTE_VALIDATOR);
        }
        return descriptor;
    }

    public String toString() {
        return this.getDefaultNamespace();
    }
}

