/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;

public class StreamApiUtil {
    @Contract(value="null -> null")
    public static PsiType getStreamElementType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        if (InheritanceUtil.isInheritor(aClass, false, "java.util.stream.IntStream")) {
            return PsiType.INT;
        }
        if (InheritanceUtil.isInheritor(aClass, false, "java.util.stream.LongStream")) {
            return PsiType.LONG;
        }
        if (InheritanceUtil.isInheritor(aClass, false, "java.util.stream.DoubleStream")) {
            return PsiType.DOUBLE;
        }
        if (!InheritanceUtil.isInheritor(aClass, false, "java.util.stream.Stream")) {
            return null;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        if (parameters.length != 1) {
            return null;
        }
        PsiType streamType = parameters[0];
        if (streamType instanceof PsiCapturedWildcardType) {
            streamType = ((PsiCapturedWildcardType)streamType).getUpperBound();
        }
        return streamType;
    }

    public static boolean isNullOrEmptyStream(PsiExpression expression) {
        if (ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        String name = call.getMethodExpression().getReferenceName();
        if (!"empty".equals(name) && !"of".equals(name) || call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || !method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.util.stream.");
    }
}

