/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyProgressIndicator
implements StandardProgressIndicator {
    private static final Logger LOG = Logger.getInstance(EmptyProgressIndicator.class);
    @NotNull
    private final ModalityState myModalityState;
    private volatile boolean myIsRunning;
    private volatile boolean myIsCanceled;

    public EmptyProgressIndicator() {
        this(ModalityState.defaultModalityState());
    }

    public EmptyProgressIndicator(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/EmptyProgressIndicator", "<init>"));
        }
        this.myModalityState = modalityState;
    }

    @Override
    public void start() {
        this.myIsRunning = true;
        this.myIsCanceled = false;
    }

    @Override
    public void stop() {
        this.myIsRunning = false;
    }

    @Override
    public boolean isRunning() {
        return this.myIsRunning;
    }

    @Override
    public final void cancel() {
        this.myIsCanceled = true;
        ProgressManager.canceled(this);
    }

    @Override
    public final boolean isCanceled() {
        return this.myIsCanceled;
    }

    @Override
    public final void checkCanceled() {
        if (this.myIsCanceled) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setText2(String text) {
    }

    @Override
    public String getText2() {
        return "";
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    @Override
    public void setFraction(double fraction) {
    }

    @Override
    public void pushState() {
    }

    @Override
    public void popState() {
    }

    @Override
    public void startNonCancelableSection() {
    }

    @Override
    public void finishNonCancelableSection() {
    }

    @Override
    public boolean isModal() {
        return false;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/EmptyProgressIndicator", "getModalityState"));
        }
        return modalityState;
    }

    @Override
    public void setModalityProgress(ProgressIndicator modalityProgress) {
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public boolean isPopupWasShown() {
        return false;
    }

    @Override
    public boolean isShowing() {
        return false;
    }

    @NotNull
    public static ProgressIndicator notNullize(@Nullable ProgressIndicator indicator) {
        if (indicator != null) {
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/EmptyProgressIndicator", "notNullize"));
            }
            return progressIndicator;
        }
        LOG.info("No progress indicator");
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/EmptyProgressIndicator", "notNullize"));
        }
        return emptyProgressIndicator;
    }
}

