/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myJarRoot;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule", "<init>"));
        }
        if (jarRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/psi/impl/light/LightJavaModule", "<init>"));
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myJarRoot = jarRoot;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, LightJavaModule.moduleName(jarRoot.getNameWithoutExtension()));
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile = this.myJarRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getRootVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameElement() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getNameElement"));
        }
        return lightJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myRefElement.getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getModuleName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getRequires"));
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<PsiExportsStatement> getExports() {
        List<PsiExportsStatement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getExports"));
        }
        return list;
    }

    @Override
    public String getName() {
        return this.getModuleName();
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightJavaModule", "setName"));
        }
        throw new IncorrectOperationException("Cannot modify automatic module '" + this.getName() + "'");
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = ObjectUtils.notNull(this.myManager.findDirectory(this.myJarRoot), super.getNavigationElement());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getNavigationElement"));
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myJarRoot.equals(((LightJavaModule)obj).myJarRoot) && this.getManager() == ((LightJavaModule)obj).getManager();
    }

    public int hashCode() {
        return this.getModuleName().hashCode() * 31 + this.getManager().hashCode();
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getModuleName();
    }

    @NotNull
    public static LightJavaModule getModule(final @NotNull PsiManager manager, final @NotNull VirtualFile jarRoot) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule", "getModule"));
        }
        if (jarRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/psi/impl/light/LightJavaModule", "getModule"));
        }
        final PsiDirectory directory = manager.findDirectory(jarRoot);
        assert (directory != null) : jarRoot;
        LightJavaModule lightJavaModule = CachedValuesManager.getCachedValue(directory, new CachedValueProvider<LightJavaModule>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<LightJavaModule> compute() {
                LightJavaModule module = new LightJavaModule(manager, jarRoot);
                return CachedValueProvider.Result.create(module, directory);
            }
        });
        if (lightJavaModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getModule"));
        }
        return lightJavaModule;
    }

    @NotNull
    public static String moduleName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
        }
        Matcher m = Patterns.VERSION.matcher(name);
        if (m.find()) {
            name = name.substring(0, m.start());
        }
        name = Patterns.TAIL_VERSION.matcher(name).replaceFirst("");
        name = Patterns.NON_NAME.matcher(name).replaceAll(".");
        name = Patterns.DOT_SEQUENCE.matcher(name).replaceAll(".");
        String string = name = StringUtil.trimLeading(StringUtil.trimTrailing(name, '.'), '.');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
        }
        return string;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern TAIL_VERSION = Pattern.compile("[0-9.]+$");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        public LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement", "<init>"));
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myText = text;
        }

        @Override
        @NotNull
        public String getReferenceText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement", "getReferenceText"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiPolyVariantReference getReference() {
            return null;
        }

        @Override
        public String toString() {
            return "PsiJavaModuleReference";
        }
    }
}

