/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ForwardIndex;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class UpdateData<Key, Value> {
    protected final Map<Key, Value> myNewData;
    protected final ThrowableComputable<ForwardIndex.InputKeyIterator<Key, Value>, IOException> myCurrentData;
    private final ID<Key, Value> myIndexId;
    private final ThrowableRunnable<IOException> myForwardIndexUpdate;

    protected UpdateData(@NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<ForwardIndex.InputKeyIterator<Key, Value>, IOException> currentData, @NotNull ID<Key, Value> indexId, @Nullable ThrowableRunnable<IOException> forwardIndexUpdate) {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/util/indexing/impl/UpdateData", "<init>"));
        }
        if (currentData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentData", "com/intellij/util/indexing/impl/UpdateData", "<init>"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/impl/UpdateData", "<init>"));
        }
        this.myNewData = newData;
        this.myCurrentData = currentData;
        this.myIndexId = indexId;
        this.myForwardIndexUpdate = forwardIndexUpdate;
    }

    public abstract void iterateKeys(int var1, KeyValueUpdateProcessor<Key, Value> var2, KeyValueUpdateProcessor<Key, Value> var3, RemovedKeyProcessor<Key> var4) throws StorageException;

    public Map<Key, Value> getNewData() {
        return this.myNewData;
    }

    public ID<Key, Value> getIndexId() {
        return this.myIndexId;
    }

    public void updateForwardIndex() throws IOException {
        if (this.myForwardIndexUpdate != null) {
            this.myForwardIndexUpdate.run();
        }
    }

    public String toString() {
        return this.myIndexId + "," + this.getClass().getName();
    }

    public static interface RemovedKeyProcessor<Key> {
        public void process(Key var1, int var2) throws StorageException;
    }

    public static interface KeyValueUpdateProcessor<Key, Value> {
        public void process(Key var1, Value var2, int var3) throws StorageException;
    }
}

