/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.Nullable;

public class ComponentSettings {
    private boolean mySmoothScrollingEnabled = true;
    private boolean myRemoteDesktopConnected;
    private boolean myPowerSaveModeEnabled;
    private static final ComponentSettings ourInstance = new ComponentSettings();

    public static ComponentSettings getInstance() {
        return ourInstance;
    }

    public boolean isSmoothScrollingEligibleFor(Component component) {
        return SystemProperties.isTrueSmoothScrollingEnabled() && !ApplicationManager.getApplication().isUnitTestMode() && this.mySmoothScrollingEnabled && !this.myRemoteDesktopConnected && !this.myPowerSaveModeEnabled && component != null && component.isShowing();
    }

    public boolean isInterpolationEligibleFor(JScrollBar scrollbar) {
        Component[] subComponents;
        Component[] components = ComponentSettings.getComponents((Window)scrollbar.getTopLevelAncestor());
        if (components.length == 1 && components[0].getClass().getName().contains("DiffWindow")) {
            return false;
        }
        return components.length != 2 || !(components[0] instanceof Container) || (subComponents = ((Container)components[0]).getComponents()).length != 1 || !subComponents[0].getClass().getName().contains("MergeWindow");
    }

    private static Component[] getComponents(@Nullable Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getContentPane().getComponents();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getContentPane().getComponents();
        }
        return new Component[0];
    }

    public void setSmoothScrollingEnabled(boolean enabled) {
        this.mySmoothScrollingEnabled = enabled;
    }

    public void setRemoteDesktopConnected(boolean connected) {
        this.myRemoteDesktopConnected = connected;
    }

    public void setPowerSaveModeEnabled(boolean enabled) {
        this.myPowerSaveModeEnabled = enabled;
    }
}

