/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RowIcon
extends JBUI.AuxScalableJBIcon {
    private final Alignment myAlignment;
    private int myWidth;
    private int myHeight;
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;

    public RowIcon(int iconCount) {
        this(iconCount, Alignment.TOP);
    }

    public RowIcon(int iconCount, Alignment alignment) {
        this.myAlignment = alignment;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(Icon ... icons) {
        this(icons.length);
        System.arraycopy(icons, 0, this.myIcons, 0, icons.length);
        this.updateSize();
    }

    protected RowIcon(RowIcon icon) {
        super(icon);
        this.myAlignment = icon.myAlignment;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myIcons = ArrayUtil.copyOf(icon.myIcons);
        this.myScaledIcons = null;
    }

    protected RowIcon copy() {
        return new RowIcon(this);
    }

    private Icon[] myScaledIcons() {
        if (this.myScaledIcons != null) {
            return this.myScaledIcons;
        }
        if (this.getScale() == 1.0f) {
            this.myScaledIcons = this.myIcons;
            return this.myIcons;
        }
        for (Icon icon : this.myIcons) {
            if (icon == null || icon instanceof ScalableIcon) continue;
            this.myScaledIcons = this.myIcons;
            return this.myIcons;
        }
        this.myScaledIcons = new Icon[this.myIcons.length];
        for (int i = 0; i < this.myIcons.length; ++i) {
            if (this.myIcons[i] == null) continue;
            this.myScaledIcons[i] = ((ScalableIcon)this.myIcons[i]).scale(this.getScale());
        }
        return this.myScaledIcons;
    }

    @NotNull
    Icon[] getAllIcons() {
        List<Icon> icons = ContainerUtil.packNullables(this.myIcons);
        Icon[] iconArray = icons.toArray(new Icon[icons.size()]);
        if (iconArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/RowIcon", "getAllIcons"));
        }
        return iconArray;
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public void setIcon(Icon icon, int layer) {
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.updateSize();
    }

    public Icon getIcon(int index) {
        return this.myIcons[index];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.updateJBUIScale()) {
            this.updateSize();
        }
        int _x = x;
        int _y = y;
        for (Icon icon : this.myScaledIcons()) {
            if (icon == null) continue;
            switch (this.myAlignment) {
                case TOP: {
                    _y = y;
                    break;
                }
                case CENTER: {
                    _y = y + (this.myHeight - icon.getIconHeight()) / 2;
                    break;
                }
                case BOTTOM: {
                    _y = y + (this.myHeight - icon.getIconHeight());
                }
            }
            icon.paintIcon(c, g, _x, _y);
            _x += icon.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        if (this.updateJBUIScale()) {
            this.updateSize();
        }
        return this.scaleVal(this.myWidth, JBUI.ScalableJBIcon.Scale.INSTANCE);
    }

    @Override
    public int getIconHeight() {
        if (this.updateJBUIScale()) {
            this.updateSize();
        }
        return this.scaleVal(this.myHeight, JBUI.ScalableJBIcon.Scale.INSTANCE);
    }

    private void updateSize() {
        int width = 0;
        int height = 0;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            width += icon.getIconWidth();
            height = Math.max(height, icon.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }

    public String toString() {
        return "Row icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

