/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionElement {
    private final Object myElement;
    private final PsiSubstitutor mySubstitutor;
    private final Object myEqualityObject;
    private final String myQualifierText;

    public CompletionElement(Object element, PsiSubstitutor substitutor) {
        this(element, substitutor, "");
    }

    public CompletionElement(Object element, PsiSubstitutor substitutor, @NotNull String qualifierText) {
        if (qualifierText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierText", "com/intellij/codeInsight/completion/scope/CompletionElement", "<init>"));
        }
        this.myElement = element;
        this.mySubstitutor = substitutor;
        this.myQualifierText = qualifierText;
        this.myEqualityObject = this.getUniqueId();
    }

    @NotNull
    public String getQualifierText() {
        String string = this.myQualifierText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/scope/CompletionElement", "getQualifierText"));
        }
        return string;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public Object getElement() {
        return this.myElement;
    }

    @Nullable
    private Object getUniqueId() {
        if (this.myElement instanceof PsiClass) {
            String qName = ((PsiClass)this.myElement).getQualifiedName();
            return qName == null ? ((PsiClass)this.myElement).getName() : qName;
        }
        if (this.myElement instanceof PsiPackage) {
            return ((PsiPackage)this.myElement).getQualifiedName();
        }
        if (this.myElement instanceof PsiMethod) {
            return Pair.create(((PsiMethod)this.myElement).getSignature(this.mySubstitutor), this.myQualifierText);
        }
        if (this.myElement instanceof PsiVariable) {
            return "#" + ((PsiVariable)this.myElement).getName();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompletionElement)) {
            return false;
        }
        Object thatObj = ((CompletionElement)obj).myEqualityObject;
        if (this.myEqualityObject instanceof MethodSignature) {
            return thatObj instanceof MethodSignature && MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)((MethodSignature)this.myEqualityObject), (Object)((MethodSignature)thatObj));
        }
        return Comparing.equal(this.myEqualityObject, thatObj);
    }

    public int hashCode() {
        if (this.myEqualityObject instanceof MethodSignature) {
            return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode((Object)((MethodSignature)this.myEqualityObject));
        }
        return this.myEqualityObject != null ? this.myEqualityObject.hashCode() : 0;
    }

    public boolean isMoreSpecificThan(@NotNull CompletionElement prev) {
        if (prev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prev", "com/intellij/codeInsight/completion/scope/CompletionElement", "isMoreSpecificThan"));
        }
        Object prevElement = prev.getElement();
        if (!(prevElement instanceof PsiMethod) || !(this.myElement instanceof PsiMethod)) {
            return false;
        }
        PsiType prevType = prev.getSubstitutor().substitute(((PsiMethod)prevElement).getReturnType());
        PsiType candidateType = this.mySubstitutor.substitute(((PsiMethod)this.myElement).getReturnType());
        return prevType != null && candidateType != null && !prevType.equals(candidateType) && prevType.isAssignableFrom(candidateType);
    }
}

