/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.CheckLevelHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.ImportsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.PostHighlightingVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.PsiMethodReferenceHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightVisitorImpl
extends JavaElementVisitor
implements HighlightVisitor {
    private final PsiResolveHelper myResolveHelper;
    private HighlightInfoHolder myHolder;
    private RefCountHolder myRefCountHolder;
    private LanguageLevel myLanguageLevel;
    private JavaSdkVersion myJavaSdkVersion;
    private PsiFile myFile;
    private PsiJavaModule myJavaModule;
    private final Map<PsiElement, Collection<PsiReferenceExpression>> myUninitializedVarProblems;
    private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myFinalVarProblems;
    private final TObjectIntHashMap<PsiParameter> myReassignedParameters;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> mySingleImportedClasses;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiField>> mySingleImportedFields;
    private final PsiElementVisitor REGISTER_REFERENCES_VISITOR;
    private final Map<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>> myDuplicateMethods;
    private final Set<PsiClass> myOverrideEquivalentMethodsVisitedClasses;

    protected HighlightVisitorImpl(@NotNull PsiResolveHelper resolveHelper) {
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "<init>"));
        }
        this.myUninitializedVarProblems = new THashMap();
        this.myFinalVarProblems = new THashMap();
        this.myReassignedParameters = new TObjectIntHashMap();
        this.mySingleImportedClasses = new THashMap();
        this.mySingleImportedFields = new THashMap();
        this.REGISTER_REFERENCES_VISITOR = new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                super.visitElement(element);
                for (PsiReference reference : element.getReferences()) {
                    PsiElement resolved = reference.resolve();
                    if (!(resolved instanceof PsiNamedElement)) continue;
                    HighlightVisitorImpl.this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
                    if (!(resolved instanceof PsiMember)) continue;
                    HighlightVisitorImpl.this.myRefCountHolder.registerReference(reference, new CandidateInfo(resolved, PsiSubstitutor.EMPTY));
                }
            }
        };
        this.myDuplicateMethods = new THashMap();
        this.myOverrideEquivalentMethodsVisitedClasses = new THashSet();
        this.myResolveHelper = resolveHelper;
    }

    @NotNull
    private MostlySingularMultiMap<MethodSignature, PsiMethod> getDuplicateMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "getDuplicateMethods"));
        }
        MostlySingularMultiMap<MethodSignature, PsiMethod> signatures = this.myDuplicateMethods.get(aClass);
        if (signatures == null) {
            signatures = new MostlySingularMultiMap();
            for (PsiMethod method : aClass.getMethods()) {
                if (method instanceof ExternallyDefinedPsiElement) continue;
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                signatures.add(signature, method);
            }
            this.myDuplicateMethods.put(aClass, signatures);
        }
        MostlySingularMultiMap<MethodSignature, PsiMethod> mostlySingularMultiMap = signatures;
        if (mostlySingularMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "getDuplicateMethods"));
        }
        return mostlySingularMultiMap;
    }

    @Override
    @NotNull
    public HighlightVisitorImpl clone() {
        HighlightVisitorImpl highlightVisitorImpl = new HighlightVisitorImpl(this.myResolveHelper);
        if (highlightVisitorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "clone"));
        }
        return highlightVisitorImpl;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "suitableForFile"));
        }
        return file instanceof PsiImportHolder && !InjectedLanguageManager.getInstance(file.getProject()).isInjectedFragment(file);
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "visit"));
        }
        if (Holder.CHECK_ELEMENT_LEVEL) {
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(element);
            element.accept(this);
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(null);
        } else {
            element.accept(this);
        }
    }

    private void registerReferencesFromInjectedFragments(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "registerReferencesFromInjectedFragments"));
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.myFile.getProject());
        manager.enumerateEx(element, this.myFile, false, (injectedPsi, places) -> injectedPsi.accept(this.REGISTER_REFERENCES_VISITOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable highlight) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "analyze"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "analyze"));
        }
        if (highlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "analyze"));
        }
        boolean success = true;
        try {
            this.prepare(Holder.CHECK_ELEMENT_LEVEL ? new CheckLevelHighlightInfoHolder(file, holder) : holder, file);
            if (updateWholeFile) {
                RefCountHolder refCountHolder;
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress == null) {
                    throw new IllegalStateException("Must be run under progress");
                }
                this.myRefCountHolder = refCountHolder = RefCountHolder.get(file);
                Project project = file.getProject();
                Document document = PsiDocumentManager.getInstance(project).getDocument(file);
                TextRange dirtyScope = Optional.ofNullable(document).map(doc -> DaemonCodeAnalyzerEx.getInstanceEx(project).getFileStatusMap().getFileDirtyScope((Document)doc, 4)).orElse(file.getTextRange());
                success = refCountHolder.analyze(file, dirtyScope, progress, () -> {
                    if (highlight == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "lambda$analyze$2"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "lambda$analyze$2"));
                    }
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "lambda$analyze$2"));
                    }
                    highlight.run();
                    progress.checkCanceled();
                    if (document != null) {
                        new PostHighlightingVisitor(file, document, refCountHolder).collectHighlights(holder, progress);
                    }
                });
            } else {
                this.myRefCountHolder = null;
                highlight.run();
            }
        }
        finally {
            this.myUninitializedVarProblems.clear();
            this.myFinalVarProblems.clear();
            this.mySingleImportedClasses.clear();
            this.mySingleImportedFields.clear();
            this.myReassignedParameters.clear();
            this.myRefCountHolder = null;
            this.myJavaModule = null;
            this.myFile = null;
            this.myHolder = null;
            this.myDuplicateMethods.clear();
            this.myOverrideEquivalentMethodsVisitedClasses.clear();
        }
        return success;
    }

    protected void prepareToRunAsInspection(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "prepareToRunAsInspection"));
        }
        this.prepare(holder, holder.getContextFile());
    }

    private void prepare(HighlightInfoHolder holder, PsiFile file) {
        this.myHolder = holder;
        this.myFile = file;
        this.myLanguageLevel = PsiUtil.getLanguageLevel(file);
        this.myJavaSdkVersion = ObjectUtils.notNull(JavaVersionService.getInstance().getJavaSdkVersion(file), JavaSdkVersion.fromLanguageLevel(this.myLanguageLevel));
        this.myJavaModule = this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) ? ModuleHighlightUtil.getModuleDescriptor(file) : null;
    }

    @Override
    public void visitElement(PsiElement element) {
        if (this.myRefCountHolder != null && this.myFile instanceof ServerPageFile) {
            try {
                for (PsiReference reference : element.getReferences()) {
                    if (!(reference instanceof PsiJavaReference)) continue;
                    PsiJavaReference psiJavaReference = (PsiJavaReference)reference;
                    this.myRefCountHolder.registerReference(psiJavaReference, psiJavaReference.advancedResolve(false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!(this.myFile instanceof ServerPageFile)) {
            this.myHolder.add(DefaultHighlightUtil.checkBadCharacter(element));
        }
    }

    @Override
    public void visitAnnotation(PsiAnnotation annotation) {
        super.visitAnnotation(annotation);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(annotation, HighlightUtil.Feature.ANNOTATIONS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkApplicability(annotation, this.myLanguageLevel, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationType(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMissingAttributes(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkTargetAnnotationDuplicates(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkDuplicateAnnotations(annotation, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkFunctionalInterface(annotation, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkRepeatableAnnotation(annotation));
        }
        if ("java.lang.Override".equals(annotation.getQualifiedName())) {
            PsiElement parent;
            PsiAnnotationOwner owner = annotation.getOwner();
            PsiElement psiElement = parent = owner instanceof PsiModifierList ? ((PsiModifierList)owner).getParent() : null;
            if (parent instanceof PsiMethod) {
                this.myHolder.add(GenericsHighlightUtil.checkOverrideAnnotation((PsiMethod)parent, annotation, this.myLanguageLevel));
            }
        }
    }

    @Override
    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiType type;
        PsiMethod method = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiNameValuePair) {
            PsiReference reference = parent.getReference();
            if (reference != null) {
                method = (PsiMethod)reference.resolve();
            }
        } else if (PsiUtil.isAnnotationMethod(parent)) {
            method = (PsiMethod)parent;
        }
        if (method != null && (type = method.getReturnType()) instanceof PsiArrayType) {
            PsiAnnotationMemberValue[] initializers;
            type = ((PsiArrayType)type).getComponentType();
            for (PsiAnnotationMemberValue initializer1 : initializers = initializer.getInitializers()) {
                this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(initializer1, type));
            }
        }
    }

    @Override
    public void visitAnnotationMethod(PsiAnnotationMethod method) {
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value = method.getDefaultValue();
        if (returnType != null && value != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(value, returnType));
        }
        this.myHolder.add(AnnotationsHighlightUtil.checkValidAnnotationType(method.getReturnType(), method.getReturnTypeElement()));
        PsiClass aClass = method.getContainingClass();
        this.myHolder.add(AnnotationsHighlightUtil.checkCyclicMemberType(method.getReturnTypeElement(), aClass));
        this.myHolder.add(AnnotationsHighlightUtil.checkClashesWithSuperMethods(method));
        if (!this.myHolder.hasErrorResults() && aClass != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, method, this.getDuplicateMethods(aClass)));
        }
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        super.visitArrayInitializerExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkArrayInitializerApplicable(expression));
        }
        if (!(expression.getParent() instanceof PsiNewExpression) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation(expression, expression.getType()));
        }
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentCompatibleTypes(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentOperatorApplicable(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(assignment);
        }
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        super.visitPolyadicExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPolyadicOperatorApplicable(expression));
        }
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
        PsiElement body;
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        this.myHolder.add(this.checkFeature(expression, HighlightUtil.Feature.LAMBDA_EXPRESSIONS));
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expression.getParent());
        if (parent instanceof PsiExpressionStatement) {
            return;
        }
        if (!this.myHolder.hasErrorResults() && !LambdaUtil.isValidLambdaContext(parent)) {
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip("Lambda expression not expected here").create());
        }
        PsiType functionalInterfaceType = null;
        if (!this.myHolder.hasErrorResults()) {
            functionalInterfaceType = expression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null) {
                String notFunctionalMessage = LambdaHighlightingUtil.checkInterfaceFunctional(functionalInterfaceType);
                if (notFunctionalMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(notFunctionalMessage).create());
                } else {
                    this.checkFunctionalInterfaceTypeAccessible(expression, functionalInterfaceType);
                }
            } else if (LambdaUtil.getFunctionalInterfaceType(expression, true) != null) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip("Cannot infer functional interface type").create());
            }
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null) {
            JavaResolveResult containingCallResolveResult;
            String parentInferenceErrorMessage = null;
            PsiCall callExpression = parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression ? (PsiCallExpression)parent.getParent() : null;
            JavaResolveResult javaResolveResult = containingCallResolveResult = callExpression != null ? callExpression.resolveMethodGenerics() : null;
            if (containingCallResolveResult instanceof MethodCandidateInfo) {
                parentInferenceErrorMessage = ((MethodCandidateInfo)containingCallResolveResult).getParentInferenceErrorMessage((PsiExpressionList)parent);
            }
            Map<PsiElement, String> returnErrors = LambdaUtil.checkReturnTypeCompatible(expression, LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType));
            if (!(parentInferenceErrorMessage == null || returnErrors != null && returnErrors.containsValue(parentInferenceErrorMessage))) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(parentInferenceErrorMessage).create());
            } else if (returnErrors != null) {
                for (Map.Entry<PsiElement, String> entry : returnErrors.entrySet()) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(entry.getKey()).descriptionAndTooltip(entry.getValue()).create());
                }
            }
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType))) != null) {
            PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
            this.myHolder.add(LambdaHighlightingUtil.checkParametersCompatible(expression, parameters, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)));
        }
        if (!this.myHolder.hasErrorResults() && (body = expression.getBody()) instanceof PsiCodeBlock) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement((PsiCodeBlock)body));
        }
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement) {
        super.visitBreakStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement.getLabelIdentifier(), statement.findExitedStatement()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkBreakOutsideLoop(statement));
        }
    }

    @Override
    public void visitClass(PsiClass aClass) {
        super.visitClass(aClass);
        if (aClass instanceof PsiSyntheticClass) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.areSupersAccessible(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkDuplicateTopLevelClass(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumMustNotBeLocal(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumWithoutConstantsCantHaveAbstractMethods(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkImplicitThisReferenceBeforeSuper(aClass, this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassAndPackageConflict(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkPublicClassInRightFile(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterOverrideEquivalentMethods(aClass, this.myLanguageLevel));
        }
    }

    @Override
    public void visitClassInitializer(PsiClassInitializer initializer) {
        super.visitClassInitializer(initializer);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkInitializerCompleteNormally(initializer));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(initializer.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface(initializer, initializer.getContainingClass()));
        }
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        super.visitClassObjectAccessExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassObjectAccessExpression(expression));
        }
    }

    @Override
    public void visitComment(PsiComment comment) {
        super.visitComment(comment);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments(comment);
        }
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement) {
        super.visitContinueStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement.getLabelIdentifier(), statement.findContinuedStatement()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkContinueOutsideLoop(statement));
        }
    }

    @Override
    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        if (!this.myHolder.hasErrorResults() && token.getTokenType() == JavaTokenType.RBRACE && token.getParent() instanceof PsiCodeBlock) {
            PsiType returnType;
            PsiCodeBlock codeBlock;
            PsiElement gParent = token.getParent().getParent();
            if (gParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)gParent;
                codeBlock = method.getBody();
                returnType = method.getReturnType();
            } else if (gParent instanceof PsiLambdaExpression) {
                PsiElement body = ((PsiLambdaExpression)gParent).getBody();
                if (!(body instanceof PsiCodeBlock)) {
                    return;
                }
                codeBlock = (PsiCodeBlock)body;
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)gParent);
            } else {
                return;
            }
            this.myHolder.add(HighlightControlFlowUtil.checkMissingReturnStatement(codeBlock, returnType));
        }
    }

    @Override
    public void visitDocComment(PsiDocComment comment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
    }

    @Override
    public void visitDocTagValue(PsiDocTagValue value) {
        PsiReference reference = value.getReference();
        if (reference != null) {
            PsiElement element = reference.resolve();
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (element instanceof PsiMethod) {
                PsiElement nameElement = ((PsiDocMethodOrFieldRef)value).getNameElement();
                if (nameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)element, nameElement, false, colorsScheme));
                }
            } else if (element instanceof PsiParameter) {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)element, value.getNavigationElement(), colorsScheme));
            }
        }
    }

    @Override
    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        if (!this.myHolder.hasErrorResults()) {
            GenericsHighlightUtil.checkEnumConstantForConstructorProblems(enumConstant, this.myHolder, this.myJavaSdkVersion);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall(enumConstant);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions(enumConstant, null));
        }
    }

    @Override
    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        super.visitEnumConstantInitializer(enumConstantInitializer);
        if (!this.myHolder.hasErrorResults()) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(enumConstantInitializer);
            this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(enumConstantInitializer, textRange));
        }
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        PsiElement parent;
        ProgressManager.checkCanceled();
        super.visitExpression(expression);
        PsiType type = expression.getType();
        if (this.myHolder.add(HighlightUtil.checkMustBeBoolean(expression, type))) {
            return;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            this.myHolder.add(HighlightUtil.checkValidArrayAccessExpression((PsiArrayAccessExpression)expression));
        }
        if ((parent = expression.getParent()) instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != expression && ((PsiNewExpression)parent).getArrayInitializer() != expression) {
            this.myHolder.add(HighlightUtil.checkAssignability(PsiType.INT, expression.getType(), expression, expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkCannotWriteToFinal(expression, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkVariableExpected(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkArrayInitializer(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTernaryOperatorConditionIsBoolean(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssertOperatorTypes(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSynchronizedExpressionType(expression, type, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkConditionalExpressionBranchTypesMatch(expression, type));
        }
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiThrowStatement && ((PsiThrowStatement)parent).getException() == expression) {
            this.myHolder.add(HighlightUtil.checkMustBeThrowable(type, expression, true));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkConstantExpression(expression));
        }
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == expression) {
            this.myHolder.add(GenericsHighlightUtil.checkForeachExpressionTypeIsIterable(expression));
        }
    }

    @Override
    public void visitExpressionList(PsiExpressionList list) {
        PsiMethodCallExpression expression;
        super.visitExpressionList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethodCallExpression && (expression = (PsiMethodCallExpression)parent).getArgumentList() == list) {
            PsiReferenceExpression referenceExpression = expression.getMethodExpression();
            JavaResolveResult[] results = this.resolveOptimised(referenceExpression);
            if (results == null) {
                return;
            }
            JavaResolveResult result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            PsiElement resolved = result.getElement();
            if (!(result.isAccessible() && result.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(expression, this.myResolveHelper, list, referenceExpression) || referenceExpression.getParent() != expression)) {
                try {
                    if (PsiTreeUtil.findChildrenOfType(expression.getArgumentList(), PsiLambdaExpression.class).isEmpty()) {
                        this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(referenceExpression, results, list, resolved, result, expression, this.myResolveHelper, list));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void visitField(PsiField field) {
        super.visitField(field);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkFinalFieldInitialized(field));
        }
    }

    @Override
    public void visitForStatement(PsiForStatement statement) {
        this.myHolder.add(HighlightUtil.checkForStatement(statement));
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement) {
        this.myHolder.add(this.checkFeature(statement, HighlightUtil.Feature.FOR_EACH));
    }

    @Override
    public void visitImportStaticStatement(PsiImportStaticStatement statement) {
        this.myHolder.add(this.checkFeature(statement, HighlightUtil.Feature.STATIC_IMPORTS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ImportsHighlightUtil.checkStaticOnDemandImportResolvesToClass(statement));
        }
    }

    @Override
    public void visitIdentifier(PsiIdentifier identifier) {
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        PsiElement parent = identifier.getParent();
        if (parent instanceof PsiVariable) {
            boolean isMethodParameter;
            PsiElement child;
            PsiVariable variable = (PsiVariable)parent;
            this.myHolder.add(HighlightUtil.checkVariableAlreadyDefined(variable));
            if (variable.getInitializer() == null && (child = variable.getLastChild()) instanceof PsiErrorElement && child.getPrevSibling() == identifier) {
                return;
            }
            boolean bl = isMethodParameter = variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiMethod;
            if (isMethodParameter) {
                this.myReassignedParameters.put((Object)((PsiParameter)variable), 1);
            } else if (HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, identifier));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, identifier, colorsScheme));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (aClass.isAnnotationType()) {
                this.myHolder.add(this.checkFeature(identifier, HighlightUtil.Feature.ANNOTATIONS));
            }
            this.myHolder.add(HighlightClassUtil.checkClassAlreadyImported(aClass, identifier));
            if (!(parent instanceof PsiAnonymousClass) && aClass.getNameIdentifier() == identifier) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName(aClass, identifier, colorsScheme));
            }
            if (!this.myHolder.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedDefaultMethods(aClass, identifier));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedConcrete(aClass, identifier));
            }
        } else if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (method.isConstructor()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorName(method));
            }
            this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, identifier, true, colorsScheme));
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                this.myHolder.add(GenericsHighlightUtil.checkDefaultMethodOverrideEquivalentToObjectNonPrivate(this.myLanguageLevel, aClass, method, identifier));
            }
        }
        this.myHolder.add(HighlightUtil.checkUnderscore(identifier, this.myLanguageLevel));
        super.visitIdentifier(identifier);
    }

    @Override
    public void visitImportStatement(PsiImportStatement statement) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSingleImportClassConflict(statement, this.mySingleImportedClasses, this.myFile));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitImportStaticReferenceElement(@NotNull PsiImportStaticReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "visitImportStaticReferenceElement"));
        }
        String refName = ref.getReferenceName();
        JavaResolveResult[] results = ref.multiResolve(false);
        PsiElement referenceNameElement = ref.getReferenceNameElement();
        if (results.length == 0) {
            String description = JavaErrorMessages.message("cannot.resolve.symbol", refName);
            assert (referenceNameElement != null) : ref;
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(referenceNameElement).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSetupJDKFix());
            this.myHolder.add(highlightInfo);
        } else {
            PsiManager manager = ref.getManager();
            for (JavaResolveResult result : results) {
                Pair<PsiImportStaticReferenceElement, PomRenameableTarget<PsiElement>> imported;
                PsiElement element = result.getElement();
                String description = null;
                if (element instanceof PsiClass) {
                    PsiClass aClass;
                    imported = this.mySingleImportedClasses.get(refName);
                    PsiClass psiClass = aClass = imported == null ? null : imported.getSecond();
                    if (aClass != null && !manager.areElementsEquivalent(aClass, element)) {
                        description = imported.first == null ? JavaErrorMessages.message("single.import.class.conflict", refName) : (((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorMessages.message("class.is.ambiguous.in.single.static.import", refName) : JavaErrorMessages.message("class.is.already.defined.in.single.static.import", refName));
                    }
                    this.mySingleImportedClasses.put(refName, Pair.create(ref, (PsiClass)element));
                } else if (element instanceof PsiField) {
                    PsiField field;
                    imported = this.mySingleImportedFields.get(refName);
                    PsiField psiField = field = imported == null ? null : (PsiField)imported.getSecond();
                    if (field != null && !manager.areElementsEquivalent(field, element)) {
                        description = ((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorMessages.message("field.is.ambiguous.in.single.static.import", refName) : JavaErrorMessages.message("field.is.already.defined.in.single.static.import", refName);
                    }
                    this.mySingleImportedFields.put(refName, Pair.create(ref, (PsiField)element));
                }
                if (description == null) continue;
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(description).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            PsiElement resolved;
            PsiElement psiElement = resolved = results.length >= 1 ? results[0].getElement() : null;
            if (results.length > 1) {
                void var6_10;
                boolean bl = true;
                while (var6_10 < results.length) {
                    PsiElement element = results[var6_10].getElement();
                    if (resolved instanceof PsiMethod && !(element instanceof PsiMethod) || resolved instanceof PsiVariable && !(element instanceof PsiVariable) || resolved instanceof PsiClass && !(element instanceof PsiClass)) {
                        resolved = null;
                        break;
                    }
                    ++var6_10;
                }
            }
            TextAttributesScheme textAttributesScheme = this.myHolder.getColorsScheme();
            if (resolved instanceof PsiClass) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, ref, textAttributesScheme));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(ref, textAttributesScheme));
                if (referenceNameElement != null) {
                    if (resolved instanceof PsiVariable) {
                        this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)resolved, referenceNameElement, textAttributesScheme));
                    } else if (resolved instanceof PsiMethod) {
                        this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)resolved, referenceNameElement, false, textAttributesScheme));
                    }
                }
            }
        }
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        super.visitInstanceOfExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkInstanceOfApplicable(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInstanceOfGenericType(expression));
        }
    }

    @Override
    public void visitKeyword(PsiKeyword keyword) {
        super.visitKeyword(keyword);
        PsiElement parent = keyword.getParent();
        String text = keyword.getText();
        if (parent instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkNotAllowedModifier(keyword, psiModifierList));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIllegalModifierCombination(keyword, psiModifierList));
            }
            if ("abstract".equals(text) && psiModifierList.getParent() instanceof PsiMethod && !this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkAbstractMethodInConcreteClass((PsiMethod)psiModifierList.getParent(), keyword));
            }
        } else if ("interface".equals(text) && parent instanceof PsiClass && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInterfaceCannotBeLocal((PsiClass)parent));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkStaticDeclarationInInnerClass(keyword));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalVoidType(keyword));
        }
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement) {
        super.visitLabeledStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelWithoutStatement(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelAlreadyInUse(statement));
        }
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        super.visitLiteralExpression(expression);
        if (this.myHolder.hasErrorResults()) {
            return;
        }
        this.myHolder.add(HighlightUtil.checkLiteralExpressionParsingError(expression, this.myLanguageLevel, this.myFile));
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments(expression);
        }
    }

    @Override
    public void visitMethod(PsiMethod method) {
        super.visitMethod(method);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(method.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorHandleSuperClassExceptions(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkRecursiveConstructorInvocation(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSafeVarargsAnnotation(method, this.myLanguageLevel));
        }
        PsiClass aClass = method.getContainingClass();
        if (!this.myHolder.hasErrorResults() && method.isConstructor()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface(method, aClass));
        }
        if (!this.myHolder.hasErrorResults() && method.hasModifierProperty("default")) {
            this.myHolder.add(this.checkFeature(method, HighlightUtil.Feature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass != null && aClass.isInterface() && method.hasModifierProperty("static")) {
            this.myHolder.add(this.checkFeature(method, HighlightUtil.Feature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, method, this.getDuplicateMethods(aClass)));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        for (PsiParameter parameter : parameters) {
            PsiIdentifier nameIdentifier;
            int info = this.myReassignedParameters.get((Object)parameter);
            if (info == 0 || (nameIdentifier = parameter.getNameIdentifier()) == null) continue;
            if (info == 2) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(parameter, nameIdentifier));
                continue;
            }
            this.myHolder.add(HighlightNamesUtil.highlightVariableName(parameter, nameIdentifier, colorsScheme));
        }
    }

    private void highlightReferencedMethodOrClassName(@NotNull PsiJavaCodeReferenceElement element, PsiElement resolved) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "highlightReferencedMethodOrClassName"));
        }
        PsiElement parent = element.getParent();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)parent).resolveMethod();
            PsiElement methodNameElement = element.getReferenceNameElement();
            if (method != null && methodNameElement != null && !(methodNameElement instanceof PsiKeyword)) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, methodNameElement, false, colorsScheme));
                this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(element, colorsScheme));
            }
        } else if (parent instanceof PsiConstructorCall) {
            try {
                PsiElement referenceNameElement;
                PsiMethod methodOrClass;
                PsiMethod method = ((PsiConstructorCall)parent).resolveConstructor();
                PsiTypeParameterListOwner psiTypeParameterListOwner = method != null ? method : (methodOrClass = resolved instanceof PsiClass ? (PsiClass)resolved : null);
                if (methodOrClass != null && (referenceNameElement = element.getReferenceNameElement()) != null) {
                    TextRange range = referenceNameElement.getTextRange();
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName(methodOrClass, referenceNameElement, range, colorsScheme, false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (resolved instanceof PsiPackage) {
            this.myHolder.add(HighlightNamesUtil.highlightPackage(resolved, element, colorsScheme));
        } else if (resolved instanceof PsiClass) {
            this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, element, colorsScheme));
        }
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumSuperConstructorCall(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSuperQualifierType(this.myFile.getProject(), expression));
        }
        if (this.myFile.isPhysical() && !this.myHolder.hasErrorResults()) {
            try {
                this.myHolder.add(HighlightMethodUtil.checkMethodCall(expression, this.myResolveHelper, this.myLanguageLevel, this.myJavaSdkVersion));
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorCallMustBeFirstStatement(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkSuperAbstractMethodDirectCall(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expression);
        }
    }

    @Override
    public void visitModifierList(PsiModifierList list) {
        super.visitModifierList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodCanHaveBody(method, this.myLanguageLevel));
            }
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                try {
                    List<HierarchicalMethodSignature> superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
                    if (!superMethodSignatures.isEmpty()) {
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, true));
                        }
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleThrows(methodSignature, superMethodSignatures, true, method.getContainingClass()));
                        }
                        if (!method.hasModifierProperty("static")) {
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodWeakerPrivileges(methodSignature, superMethodSignatures, true, this.myFile));
                            }
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodOverridesFinal(methodSignature, superMethodSignatures));
                            }
                        }
                    }
                }
                catch (IndexNotReadyException superMethodSignatures) {
                    // empty catch block
                }
            }
            PsiClass aClass = method.getContainingClass();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodMustHaveBody(method, aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorCallsBaseClassConstructor(method, this.myRefCountHolder, this.myResolveHelper));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkStaticMethodOverride(method, this.myFile));
            }
            if (!this.myHolder.hasErrorResults() && aClass != null && this.myOverrideEquivalentMethodsVisitedClasses.add(aClass)) {
                this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            try {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkDuplicateNestedClass(aClass));
                }
                if (!this.myHolder.hasErrorResults()) {
                    TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
                    this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(aClass, textRange));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkClassDoesNotCallSuperConstructorOrHandleExceptions(aClass, this.myRefCountHolder, this.myResolveHelper));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightMethodUtil.checkOverrideEquivalentInheritedMethods(aClass, this.myFile, this.myLanguageLevel));
                }
                if (!this.myHolder.hasErrorResults() && this.myOverrideEquivalentMethodsVisitedClasses.add(aClass)) {
                    this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkCyclicInheritance(aClass));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (parent instanceof PsiEnumConstant && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(GenericsHighlightUtil.checkEnumConstantModifierList(list));
        }
    }

    @Override
    public void visitNameValuePair(PsiNameValuePair pair) {
        PsiIdentifier nameId;
        this.myHolder.add(AnnotationsHighlightUtil.checkNameValuePair(pair));
        if (!this.myHolder.hasErrorResults() && (nameId = pair.getNameIdentifier()) != null) {
            HighlightInfo result = HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.ANNOTATION_ATTRIBUTE_NAME).range(nameId).create();
            this.myHolder.add(result);
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression) {
        PsiType type = expression.getType();
        PsiClass aClass = PsiUtil.resolveClassInType(type);
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions(expression, null));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousInheritFinal(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkQualifiedNew(expression, type, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext(expression, type, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterInstantiation(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(aClass, expression));
        }
        try {
            if (!this.myHolder.hasErrorResults()) {
                HighlightMethodUtil.checkNewExpression(expression, type, this.myHolder, this.myJavaSdkVersion);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation(expression, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall(expression);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expression);
        }
    }

    @Override
    public void visitPackageStatement(PsiPackageStatement statement) {
        super.visitPackageStatement(statement);
        this.myHolder.add(AnnotationsHighlightUtil.checkPackageAnnotationContainingFile(statement));
    }

    @Override
    public void visitParameter(PsiParameter parameter) {
        super.visitParameter(parameter);
        PsiElement parent = parameter.getParent();
        if (parent instanceof PsiParameterList && parameter.isVarArgs()) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(this.checkFeature(parameter, HighlightUtil.Feature.VARARGS));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkVarArgParameterIsLast(parameter));
            }
        } else if (parent instanceof PsiCatchSection) {
            if (!this.myHolder.hasErrorResults() && parameter.getType() instanceof PsiDisjunctionType) {
                this.myHolder.add(this.checkFeature(parameter, HighlightUtil.Feature.MULTI_CATCH));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkCatchParameterIsThrowable(parameter));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(GenericsHighlightUtil.checkCatchParameterIsClass(parameter));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(HighlightUtil.checkCatchTypeIsDisjoint(parameter));
            }
        } else if (parent instanceof PsiForeachStatement && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkForEachParameterType((PsiForeachStatement)parent, parameter));
        }
    }

    @Override
    public void visitParameterList(PsiParameterList list) {
        super.visitParameterList(list);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAnnotationMethodParameters(list));
        }
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression.getOperationSign(), expression.getOperand()));
        }
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression.getOperationSign(), expression.getOperand()));
        }
    }

    private void registerConstructorCall(@NotNull PsiConstructorCall constructorCall) {
        JavaResolveResult resolveResult;
        PsiElement resolved;
        if (constructorCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "registerConstructorCall"));
        }
        if (this.myRefCountHolder != null && (resolved = (resolveResult = constructorCall.resolveMethodGenerics()).getElement()) instanceof PsiNamedElement) {
            this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
        }
    }

    @Override
    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        JavaResolveResult result = this.doVisitReferenceElement(ref);
        if (result != null) {
            PsiElement resolved = result.getElement();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkRawOnParameterizedType(ref, resolved));
            }
            if (!this.myHolder.hasErrorResults() && resolved != null && this.myJavaModule != null) {
                this.myHolder.add(ModuleHighlightUtil.checkPackageAccessibility(ref, resolved, this.myJavaModule));
            }
        }
    }

    private JavaResolveResult doVisitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiClass containingClass;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "doVisitReferenceElement"));
        }
        JavaResolveResult result = this.resolveOptimised(ref);
        if (result == null) {
            return null;
        }
        PsiElement resolved = result.getElement();
        PsiElement parent = ref.getParent();
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference(ref, result);
        }
        this.myHolder.add(HighlightUtil.checkReference(ref, result, this.myFile, this.myLanguageLevel));
        if ((parent instanceof PsiJavaCodeReferenceElement || ref.isQualified()) && !this.myHolder.hasErrorResults() && resolved instanceof PsiTypeParameter) {
            boolean cannotSelectFromTypeParameter;
            boolean bl = cannotSelectFromTypeParameter = !this.myJavaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7);
            if (!cannotSelectFromTypeParameter && (containingClass = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class)) != null && (PsiTreeUtil.isAncestor(containingClass.getExtendsList(), ref, false) || PsiTreeUtil.isAncestor(containingClass.getImplementsList(), ref, false))) {
                cannotSelectFromTypeParameter = true;
            }
            if (cannotSelectFromTypeParameter) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Cannot select from a type parameter").range(ref).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAbstractInstantiation(ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkExtendsDuplicate(ref, resolved, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassExtendsForeignInnerClass(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSelectStaticClassFromParameterizedType(resolved, ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, ref, result.getSubstitutor(), this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkCannotPassInner(ref));
        }
        if (resolved != null && parent instanceof PsiReferenceList && !this.myHolder.hasErrorResults()) {
            PsiReferenceList referenceList = (PsiReferenceList)parent;
            this.myHolder.add(HighlightUtil.checkElementInReferenceList(ref, referenceList, result));
        }
        if (parent instanceof PsiAnonymousClass && ref.equals(((PsiAnonymousClass)parent).getBaseClassReference()) && this.myOverrideEquivalentMethodsVisitedClasses.add((PsiClass)parent)) {
            PsiClass aClass = (PsiClass)parent;
            this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
        }
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            containingClass = PsiTreeUtil.getNonStrictParentOfType(ref, PsiClass.class, PsiLambdaExpression.class);
            if (!(!(containingClass instanceof PsiAnonymousClass) && !(containingClass instanceof PsiLambdaExpression) || PsiTreeUtil.isAncestor(containingClass, variable, false) || variable instanceof PsiField || !(containingClass instanceof PsiLambdaExpression) && PsiTreeUtil.isAncestor(((PsiAnonymousClass)containingClass).getArgumentList(), ref, false))) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.IMPLICIT_ANONYMOUS_CLASS_PARAMETER).range(ref).create());
            }
            if (variable instanceof PsiParameter && ref instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((Object)ref))) {
                this.myReassignedParameters.put((Object)((PsiParameter)variable), 2);
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (!variable.hasModifierProperty("final") && this.isReassigned(variable)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, ref));
            } else {
                PsiElement nameElement = ref.getReferenceNameElement();
                if (nameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, nameElement, colorsScheme));
                }
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(ref, colorsScheme));
        } else {
            this.highlightReferencedMethodOrClassName(ref, resolved);
        }
        if (parent instanceof PsiNewExpression && !(resolved instanceof PsiClass) && resolved instanceof PsiNamedElement && ((PsiNewExpression)parent).getClassOrAnonymousClassReference() == ref) {
            String text = JavaErrorMessages.message("cannot.resolve.symbol", ((PsiNamedElement)resolved).getName());
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(text).create());
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiClass) {
            PsiClass outerClass;
            PsiTypeParameterListOwner owner;
            PsiClass aClass = ((PsiClass)resolved).getContainingClass();
            if (aClass != null) {
                PsiExpression newQualifier;
                PsiElement qualifier = ref.getQualifier();
                PsiElement place = qualifier instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)qualifier).resolve() : (parent instanceof PsiNewExpression ? ((newQualifier = ((PsiNewExpression)parent).getQualifier()) == null ? ref : PsiUtil.resolveClassInType(newQualifier.getType())) : ref);
                if (place != null && PsiTreeUtil.isAncestor(aClass, place, false) && aClass.hasTypeParameters()) {
                    this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)ref, place, (PsiClass)resolved));
                }
            } else if (resolved instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)resolved).getOwner()) instanceof PsiClass && !InheritanceUtil.hasEnclosingInstanceInScope(outerClass = (PsiClass)owner, ref, false, false)) {
                this.myHolder.add(HighlightClassUtil.reportIllegalEnclosingUsage(ref, null, (PsiClass)owner, ref));
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPackageAndClassConflict(ref, this.myFile));
        }
        return result;
    }

    @Nullable
    private JavaResolveResult resolveOptimised(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "resolveOptimised"));
        }
        try {
            if (ref instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                JavaResolveResult[] results = JavaResolveUtil.resolveWithContainingFile(ref, resolver, true, true, this.myFile);
                return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            }
            return ref.advancedResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private JavaResolveResult[] resolveOptimised(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "resolveOptimised"));
        }
        try {
            if (expression instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                return JavaResolveUtil.resolveWithContainingFile(expression, resolver, true, true, this.myFile);
            }
            return expression.multiResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiExpressionList list;
        PsiMethodCallExpression methodCallExpression2;
        PsiElement parent;
        JavaResolveResult[] results;
        JavaResolveResult resultForIncompleteCode = this.doVisitReferenceElement(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expression);
            if (this.myHolder.hasErrorResults()) {
                return;
            }
        }
        if ((results = this.resolveOptimised(expression)) == null) {
            return;
        }
        JavaResolveResult result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = result.getElement();
        if (resolved instanceof PsiVariable && resolved.getContainingFile() == expression.getContainingFile()) {
            PsiVariable variable;
            boolean isFinal;
            if (!this.myHolder.hasErrorResults()) {
                try {
                    this.myHolder.add(HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression, (PsiVariable)resolved, this.myUninitializedVarProblems, this.myFile));
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
            if ((isFinal = (variable = (PsiVariable)resolved).hasModifierProperty("final")) && !variable.hasInitializer()) {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression, this.myFinalVarProblems));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableInitializedInLoop(expression, resolved));
                }
            }
        }
        if (!(!((parent = expression.getParent()) instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)parent).getMethodExpression() != expression || result.isAccessible() && result.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(methodCallExpression2 = (PsiMethodCallExpression)parent, this.myResolveHelper, list = methodCallExpression2.getArgumentList(), expression))) {
            try {
                PsiElement nameElement;
                this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallIdentifier(expression, results, list, resolved, result, methodCallExpression2, this.myResolveHelper));
                if (!PsiTreeUtil.findChildrenOfType(methodCallExpression2.getArgumentList(), PsiLambdaExpression.class).isEmpty() && (nameElement = expression.getReferenceNameElement()) != null) {
                    this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(expression, results, list, resolved, result, methodCallExpression2, this.myResolveHelper, nameElement));
                }
            }
            catch (IndexNotReadyException nameElement) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults() && resultForIncompleteCode != null) {
            this.myHolder.add(HighlightUtil.checkExpressionRequired(expression, resultForIncompleteCode));
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiField) {
            try {
                this.myHolder.add(HighlightUtil.checkIllegalForwardReferenceToField(expression, (PsiField)resolved));
            }
            catch (IndexNotReadyException methodCallExpression2) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkAccessStaticFieldFromEnumConstructor(expression, result));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkClassReferenceAfterQualifier(expression, resolved));
        }
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        this.myHolder.add(HighlightUtil.checkUnqualifiedSuperInDefaultMethod(this.myLanguageLevel, expression, qualifierExpression));
        if (!this.myHolder.hasErrorResults() && qualifierExpression != null) {
            PsiClass psiClass;
            PsiType type = qualifierExpression.getType();
            if (type instanceof PsiCapturedWildcardType) {
                type = ((PsiCapturedWildcardType)type).getUpperBound();
            }
            if ((psiClass = PsiUtil.resolveClassInType(type)) != null) {
                this.myHolder.add(GenericsHighlightUtil.areSupersAccessible(psiClass, expression));
            }
        }
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        String badReturnTypeMessage;
        PsiElement qualifier;
        String errorMessage;
        PsiElement qualifier2;
        PsiElement referenceNameElement;
        PsiElement method;
        JavaResolveResult result;
        JavaResolveResult[] results;
        this.myHolder.add(this.checkFeature(expression, HighlightUtil.Feature.METHOD_REFERENCES));
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expression.getParent());
        if (parent instanceof PsiExpressionStatement) {
            return;
        }
        try {
            results = expression.multiResolve(true);
            result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference(expression, result);
        }
        if ((method = result.getElement()) != null && !result.isAccessible()) {
            String accessProblem = HighlightUtil.buildProblemWithAccessDescription(expression, result);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(accessProblem).create();
            this.myHolder.add(info);
        } else {
            PsiElement methodNameElement;
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (method instanceof PsiMethod && !expression.isConstructor() && (methodNameElement = expression.getReferenceNameElement()) != null) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)method, methodNameElement, false, colorsScheme));
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(expression, colorsScheme));
        }
        if (!LambdaUtil.isValidLambdaContext(parent)) {
            String description = "Method reference expression is not expected here";
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create());
        }
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null) {
            boolean notFunctional;
            boolean bl = notFunctional = !LambdaUtil.isFunctionalType(functionalInterfaceType);
            if (notFunctional) {
                String description = functionalInterfaceType.getPresentableText() + " is not a functional interface";
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create());
            }
        }
        if (!this.myHolder.hasErrorResults() && (referenceNameElement = expression.getReferenceNameElement()) instanceof PsiKeyword && !PsiMethodReferenceUtil.isValidQualifier(expression) && (qualifier2 = expression.getQualifier()) != null) {
            String description = "Cannot find class " + qualifier2.getText();
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier2).descriptionAndTooltip(description).create());
        }
        if (!this.myHolder.hasErrorResults()) {
            this.checkFunctionalInterfaceTypeAccessible(expression, functionalInterfaceType);
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null && (errorMessage = PsiMethodReferenceUtil.checkMethodReferenceContext(expression)) != null) {
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(errorMessage).create());
        }
        if (!this.myHolder.hasErrorResults() && (qualifier = expression.getQualifier()) instanceof PsiTypeElement) {
            PsiType psiType = ((PsiTypeElement)qualifier).getType();
            HighlightInfo genericArrayCreationInfo = GenericsHighlightUtil.checkGenericArrayCreation(qualifier, psiType);
            if (genericArrayCreationInfo != null) {
                this.myHolder.add(genericArrayCreationInfo);
            } else {
                String wildcardMessage = PsiMethodReferenceUtil.checkTypeArguments((PsiTypeElement)qualifier, psiType);
                if (wildcardMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(wildcardMessage).create());
                }
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(PsiMethodReferenceHighlightingUtil.checkRawConstructorReference(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions(expression, expression.getTextRange()));
        }
        if (!this.myHolder.hasErrorResults() && (badReturnTypeMessage = PsiMethodReferenceUtil.checkReturnType(expression, result, functionalInterfaceType)) != null) {
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(badReturnTypeMessage).create());
        }
        if (!this.myHolder.hasErrorResults() && (results.length == 0 || results[0] instanceof MethodCandidateInfo && !((MethodCandidateInfo)results[0]).isApplicable() && functionalInterfaceType != null)) {
            String description = null;
            if (results.length == 1) {
                description = ((MethodCandidateInfo)results[0]).getInferenceErrorMessage();
            }
            if (expression.isConstructor()) {
                PsiClass containingClass = PsiMethodReferenceUtil.getQualifierResolveResult(expression).getContainingClass();
                if (containingClass != null && !this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, expression)) && !this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation(expression, containingClass)) && containingClass.isPhysical() && description == null) {
                    description = JavaErrorMessages.message("cannot.resolve.constructor", containingClass.getName());
                }
            } else if (description == null) {
                description = JavaErrorMessages.message("cannot.resolve.method", expression.getReferenceName());
            }
            if (description != null) {
                PsiElement referenceNameElement2 = expression.getReferenceNameElement();
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(results.length == 0 ? HighlightInfoType.WRONG_REF : HighlightInfoType.ERROR).descriptionAndTooltip(description).range(referenceNameElement2).create();
                this.myHolder.add(highlightInfo);
                TextRange fixRange = HighlightMethodUtil.getFixRange(referenceNameElement2);
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QuickFixFactory.getInstance().createCreateMethodFromUsageFix(expression));
            }
        }
    }

    private void checkFunctionalInterfaceTypeAccessible(@NotNull PsiFunctionalExpression expression, PsiType functionalInterfaceType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "checkFunctionalInterfaceTypeAccessible"));
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            if (!PsiUtil.isAccessible(this.myFile.getProject(), psiClass, expression, null)) {
                String text = HighlightUtil.buildProblemWithAccessDescription(expression, resolveResult);
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(text).create());
            } else {
                for (PsiType type : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    this.checkFunctionalInterfaceTypeAccessible(expression, type);
                }
            }
        }
    }

    @Override
    public void visitReferenceList(PsiReferenceList list) {
        if (list.getFirstChild() == null) {
            return;
        }
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiTypeParameter)) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationDeclaration(parent, list));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkExtendsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkImplementsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassExtendsOnlyOneClass(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkGenericCannotExtendException(list));
            }
        }
    }

    @Override
    public void visitReferenceParameterList(PsiReferenceParameterList list) {
        if (list.getTextLength() == 0) {
            return;
        }
        this.myHolder.add(this.checkFeature(list, HighlightUtil.Feature.GENERICS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersAllowed(list));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersOnRaw(list));
        }
        if (!this.myHolder.hasErrorResults()) {
            for (PsiTypeElement typeElement : list.getTypeParameterElements()) {
                if (!(typeElement.getType() instanceof PsiDiamondType)) continue;
                this.myHolder.add(this.checkFeature(list, HighlightUtil.Feature.DIAMOND_TYPES));
            }
        }
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement) {
        try {
            this.myHolder.add(HighlightUtil.checkReturnStatementType(statement));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void visitStatement(PsiStatement statement) {
        super.visitStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkNotAStatement(statement));
        }
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expr) {
        this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext(expr, expr.getQualifier(), this.myLanguageLevel));
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression(expr);
        }
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        super.visitSwitchLabelStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkCaseStatement(statement));
        }
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        this.myHolder.add(HighlightUtil.checkStatementPrependedWithCaseInsideSwitch(statement));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSwitchSelectorType(statement, this.myLanguageLevel));
        }
    }

    @Override
    public void visitThisExpression(PsiThisExpression expr) {
        if (!(expr.getParent() instanceof PsiReceiverParameter)) {
            this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext(expr, expr.getQualifier(), this.myLanguageLevel));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkMemberReferencedBeforeConstructorCalled(expr, null, this.myFile));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.visitExpression(expr);
            }
        }
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement) {
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions(statement, null));
        if (!this.myHolder.hasErrorResults()) {
            this.visitStatement(statement);
        }
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement) {
        super.visitTryStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            Set<PsiClassType> thrownTypes = HighlightUtil.collectUnhandledExceptions(statement);
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                boolean added = this.myHolder.addAll(HighlightUtil.checkExceptionAlreadyCaught(parameter));
                if (!added) {
                    added = this.myHolder.addAll(HighlightUtil.checkExceptionThrownInTry(parameter, thrownTypes));
                }
                if (added) continue;
                this.myHolder.addAll(HighlightUtil.checkWithImprovedCatchAnalysis(parameter, thrownTypes, this.myFile));
            }
        }
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        super.visitResourceList(resourceList);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(resourceList, HighlightUtil.Feature.TRY_WITH_RESOURCES));
        }
    }

    @Override
    public void visitResourceVariable(PsiResourceVariable resource) {
        super.visitResourceVariable(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions(resource));
        }
    }

    @Override
    public void visitResourceExpression(PsiResourceExpression resource) {
        super.visitResourceExpression(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(resource, HighlightUtil.Feature.REFS_AS_RESOURCE));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkResourceVariableIsFinal(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions(resource));
        }
    }

    @Override
    public void visitTypeElement(PsiTypeElement type) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalType(type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkReferenceTypeUsedAsTypeArgument(type, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkWildcardUsage(type));
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
        super.visitTypeCastExpression(typeCast);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIntersectionInTypeCast(typeCast, this.myLanguageLevel));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkInconvertibleTypeCast(typeCast));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void visitTypeParameterList(PsiTypeParameterList list) {
        PsiTypeParameter[] typeParameters = list.getTypeParameters();
        if (typeParameters.length > 0) {
            this.myHolder.add(this.checkFeature(list, HighlightUtil.Feature.GENERICS));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkTypeParametersList(list, typeParameters, this.myLanguageLevel));
            }
        }
    }

    @Override
    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkVariableInitializerType(variable));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    private boolean isReassigned(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "isReassigned"));
        }
        try {
            boolean reassigned = variable instanceof PsiParameter ? this.myReassignedParameters.get((Object)((PsiParameter)variable)) == 2 : HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems);
            return reassigned;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && PsiPolyExpressionUtil.isPolyExpression(expression)) {
            PsiType conditionalType;
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (thenExpression != null && elseExpression != null && (conditionalType = expression.getType()) != null) {
                PsiExpression[] sides;
                for (PsiExpression side : sides = new PsiExpression[]{thenExpression, elseExpression}) {
                    PsiType sideType = side.getType();
                    if (sideType == null || TypeConversionUtil.isAssignable(conditionalType, sideType)) continue;
                    this.myHolder.add(HighlightUtil.checkAssignability(conditionalType, sideType, side, side));
                }
            }
        }
    }

    @Override
    public void visitReceiverParameter(PsiReceiverParameter parameter) {
        super.visitReceiverParameter(parameter);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(parameter, HighlightUtil.Feature.RECEIVERS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverPlacement(parameter));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverType(parameter));
        }
    }

    @Override
    public void visitModule(PsiJavaModule module) {
        super.visitModule(module);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature(module, HighlightUtil.Feature.MODULES));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileName(module, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileDuplicates(module, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkDuplicateStatements(module));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkUnusedServices(module));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileLocation(module, this.myFile));
        }
    }

    @Override
    public void visitRequiresStatement(PsiRequiresStatement statement) {
        super.visitRequiresStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            PsiJavaModule container = (PsiJavaModule)statement.getParent();
            PsiJavaModuleReferenceElement ref = statement.getReferenceElement();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkModuleReference(ref, container));
            }
        }
    }

    @Override
    public void visitExportsStatement(PsiExportsStatement statement) {
        super.visitExportsStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            PsiJavaModule container = (PsiJavaModule)statement.getParent();
            PsiJavaCodeReferenceElement ref = statement.getPackageReference();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkPackageReference(ref));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(ModuleHighlightUtil.checkExportTargets(statement, container));
            }
        }
    }

    @Override
    public void visitUsesStatement(PsiUsesStatement statement) {
        super.visitUsesStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkServiceReference(statement.getClassReference()));
        }
    }

    @Override
    public void visitProvidesStatement(PsiProvidesStatement statement) {
        super.visitProvidesStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
            PsiJavaCodeReferenceElement implRef = statement.getImplementationReference();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkServiceImplementation(implRef, intRef));
            }
        }
    }

    @Nullable
    private HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull HighlightUtil.Feature feature) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "checkFeature"));
        }
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "checkFeature"));
        }
        return HighlightUtil.checkFeature(element, feature, this.myLanguageLevel, this.myFile);
    }

    private static class Holder {
        private static final boolean CHECK_ELEMENT_LEVEL = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }
}

