/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.OutboundSemiGraph;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleGraphUtil {
    private JavaModuleGraphUtil() {
    }

    @Nullable
    public static PsiJavaModule findDescriptorByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findDescriptorByElement"));
        }
        PsiFileSystemItem fsItem = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        return fsItem != null ? ModuleHighlightUtil.getModuleDescriptor(fsItem) : null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorByModule(@Nullable Module module) {
        return ModuleHighlightUtil.getModuleDescriptor(module);
    }

    @Nullable
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "findCycle"));
        }
        Project project = module.getProject();
        List cycles = (List)CachedValuesManager.getManager(project).getCachedValue(project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.findCycles(project), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        return (Collection)((Object)ContainerUtil.find(cycles, set -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "lambda$findCycle$1"));
            }
            return set.contains(module);
        }));
    }

    public static boolean exports(@NotNull PsiJavaModule source, @NotNull String packageName, @NotNull PsiJavaModule target) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exports"));
        }
        Map exports = (Map)CachedValuesManager.getCachedValue(source, () -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "lambda$exports$2"));
            }
            return CachedValueProvider.Result.create(JavaModuleGraphUtil.exportsMap(source), source.getContainingFile());
        });
        Set targets = (Set)exports.get(packageName);
        return targets != null && (targets.isEmpty() || targets.contains(target.getModuleName()));
    }

    public static boolean reads(@NotNull PsiJavaModule source, @NotNull PsiJavaModule destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "reads"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "reads"));
        }
        Project project = source.getProject();
        RequiresGraph graph = (RequiresGraph)CachedValuesManager.getManager(project).getCachedValue(project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.buildRequiresGraph(project), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        return graph.reads(source, destination);
    }

    private static List<Set<PsiJavaModule>> findCycles(Project project) {
        HashSet<PsiJavaModule> projectModules = ContainerUtil.newHashSet();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project, "module-info.java", module.getModuleScope(false));
            if (files.size() > 1) {
                return Collections.emptyList();
            }
            Optional.ofNullable(ContainerUtil.getFirstItem(files)).map(PsiManager.getInstance(project)::findFile).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).ifPresent(projectModules::add);
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph;
            DFSTBuilder builder;
            Collection components;
            MultiMap<PsiJavaModule, PsiJavaModule> relations = MultiMap.create();
            for (PsiJavaModule module : projectModules) {
                for (PsiRequiresStatement statement : module.getRequires()) {
                    PsiJavaModule dependency = PsiJavaModuleReference.resolve(statement, statement.getModuleName(), true);
                    if (dependency == null || !projectModules.contains(dependency)) continue;
                    relations.putValue(module, dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                return components.stream().map(ContainerUtil::newLinkedHashSet).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil", "exportsMap"));
        }
        HashMap<String, Set<String>> map = ContainerUtil.newHashMap();
        for (PsiExportsStatement statement : source.getExports()) {
            String pkg = statement.getPackageName();
            List<String> targets = statement.getModuleNames();
            map.put(pkg, targets.isEmpty() ? Collections.emptySet() : ContainerUtil.newTroveSet(targets));
        }
        return map;
    }

    private static RequiresGraph buildRequiresGraph(Project project) {
        MultiMap relations = MultiMap.create();
        THashSet publicEdges = ContainerUtil.newTroveSet();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project, "module-info.java", module.getModuleScope(false));
            Optional.ofNullable(ContainerUtil.getFirstItem(files)).map(PsiManager.getInstance(project)::findFile).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).ifPresent(m -> JavaModuleGraphUtil.visit(m, relations, publicEdges));
        }
        Graph<PsiJavaModule> graph = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph((OutboundSemiGraph<PsiJavaModule>)graph, (Set<String>)publicEdges);
    }

    private static void visit(PsiJavaModule module, MultiMap<PsiJavaModule, PsiJavaModule> relations, Set<String> publicEdges) {
        if (!relations.containsKey(module)) {
            relations.putValues(module, Collections.emptyList());
            for (PsiRequiresStatement statement : module.getRequires()) {
                for (PsiJavaModule dependency : PsiJavaModuleReference.multiResolve(statement, statement.getModuleName(), false)) {
                    relations.putValue(module, dependency);
                    if (statement.isPublic()) {
                        publicEdges.add(RequiresGraph.key(dependency, module));
                    }
                    JavaModuleGraphUtil.visit(dependency, relations, publicEdges);
                }
            }
        }
    }

    private static class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new THashSet();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        public ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        @Override
        public Collection<N> getNodes() {
            return this.myNodes;
        }

        @Override
        public Iterator<N> getIn(N n) {
            return this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
        }

        @Override
        public Iterator<N> getOut(N n) {
            return this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
        }
    }

    private static class RequiresGraph {
        private final OutboundSemiGraph<PsiJavaModule> myGraph;
        private final Set<String> myPublicEdges;

        public RequiresGraph(OutboundSemiGraph<PsiJavaModule> graph, Set<String> publicEdges) {
            this.myGraph = graph;
            this.myPublicEdges = publicEdges;
        }

        public boolean reads(PsiJavaModule source, PsiJavaModule destination) {
            Collection<PsiJavaModule> nodes = this.myGraph.getNodes();
            if (nodes.contains(destination) && nodes.contains(source)) {
                Iterator<PsiJavaModule> directReaders = this.myGraph.getOut(destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = directReaders.next();
                    if (!source.equals(next) && (!this.myPublicEdges.contains(RequiresGraph.key(destination, next)) || !this.reads(source, next))) continue;
                    return true;
                }
            }
            return false;
        }

        public static String key(PsiJavaModule module, PsiJavaModule exporter) {
            return module.getModuleName() + '/' + exporter.getModuleName();
        }
    }
}

