/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwoColorsIcon
extends ColorIcon {
    @NotNull
    private final Color mySecondColor;
    private static final int SQUARE_SIZE = JBUI.scale(6);
    private static final BufferedImage CHESS_IMAGE = UIUtil.createImage(SQUARE_SIZE, SQUARE_SIZE, 1);
    private static final TexturePaint CHESS;

    public TwoColorsIcon(int size, @Nullable Color color1, @Nullable Color secondColor) {
        super(size, size, color1 != null ? color1 : Gray.TRANSPARENT, false);
        this.mySecondColor = secondColor != null ? secondColor : Gray.TRANSPARENT;
    }

    protected TwoColorsIcon(TwoColorsIcon icon) {
        super(icon);
        this.mySecondColor = icon.mySecondColor;
    }

    @Override
    protected TwoColorsIcon copy() {
        return new TwoColorsIcon(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2d);
        try {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g2d.setPaint(this.getPaint(this.getIconColor()));
            g2d.fillPolygon(new int[]{x, x + w, x}, new int[]{y, y, y + h}, 3);
            g2d.setPaint(this.getPaint(this.mySecondColor));
            g2d.fillPolygon(new int[]{x + w, x + w, x}, new int[]{y, y + h, y + h}, 3);
        }
        catch (Exception e) {
            g2d.dispose();
        }
        finally {
            config.restore();
        }
    }

    protected Paint getPaint(Color color) {
        return color == null || color.getAlpha() == 0 ? CHESS : color;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwoColorsIcon icon = (TwoColorsIcon)o;
        if (this.getIconWidth() != icon.getIconWidth()) {
            return false;
        }
        if (this.getIconHeight() != icon.getIconHeight()) {
            return false;
        }
        return this.mySecondColor.equals(icon.mySecondColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySecondColor.hashCode();
        return result;
    }

    static {
        Graphics2D graphics = CHESS_IMAGE.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(JBColor.LIGHT_GRAY);
        graphics.fillRect(0, 0, SQUARE_SIZE + 1, SQUARE_SIZE + 1);
        graphics.setColor(JBColor.GRAY);
        graphics.fillRect(0, 0, SQUARE_SIZE / 2, SQUARE_SIZE / 2);
        graphics.fillRect(SQUARE_SIZE / 2, SQUARE_SIZE / 2, SQUARE_SIZE / 2, SQUARE_SIZE / 2);
        graphics.dispose();
        CHESS = new TexturePaint(CHESS_IMAGE, new Rectangle(0, 0, SQUARE_SIZE, SQUARE_SIZE));
    }
}

