/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @org.intellij.lang.annotations.Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("StringConcatenationInLoop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "getID"));
        }
        return "StringConcatenationInLoop";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getAppendedVariable(PsiExpression expression) {
        PsiElement parent = expression;
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(((PsiAssignmentExpression)parent).getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)lhs).resolve();
        return element instanceof PsiVariable ? (PsiVariable)element : null;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return infos.length > 0 && infos[0] instanceof PsiLocalVariable ? new ReplaceWithStringBuilderFix((PsiVariable)infos[0]) : null;
    }

    static class ReplaceWithStringBuilderFix
    extends InspectionGadgetsFix {
        private static final Pattern PRINT_OR_PRINTLN = Pattern.compile("print|println");
        private String myName;
        private String myTargetType;

        public ReplaceWithStringBuilderFix(PsiVariable variable) {
            this.myName = variable.getName();
            this.myTargetType = PsiUtil.isLanguageLevel5OrHigher(variable) ? "StringBuilder" : "StringBuffer";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiStatement commentPlace;
            PsiExpression expression = PsiTreeUtil.getParentOfType(descriptor.getStartElement(), PsiExpression.class);
            if (expression == null) {
                return;
            }
            PsiVariable variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
            if (!(variable instanceof PsiLocalVariable)) {
                return;
            }
            variable.normalizeDeclaration();
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable, null, results, ct);
            results.add(ct.replace((PsiElement)typeElement, "java.lang." + this.myTargetType));
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                results.add(ct.replace((PsiElement)initializer, this.generateNewStringBuilder(initializer, ct)));
            }
            ct.insertCommentsBefore((commentPlace = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class)) == null ? variable : commentPlace);
            for (PsiElement result : results) {
                if (!result.isValid()) continue;
                result = JavaCodeStyleManager.getInstance(project).shortenClassReferences(result);
                CodeStyleManager.getInstance(project).reformat(result);
            }
        }

        @NotNull
        private String generateNewStringBuilder(PsiExpression initializer, CommentTracker ct) {
            if (ExpressionUtils.isNullLiteral(initializer)) {
                String string = ct.text(initializer);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix", "generateNewStringBuilder"));
                }
                return string;
            }
            String text = initializer == null || ExpressionUtils.isLiteral(initializer, "") ? "" : ct.text(initializer);
            String string = "new java.lang." + this.myTargetType + "(" + text + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix", "generateNewStringBuilder"));
            }
            return string;
        }

        private void replaceAll(PsiVariable variable, PsiElement scope, List<PsiElement> results, CommentTracker ct) {
            Query<PsiReference> query = scope == null ? ReferencesSearch.search(variable) : ReferencesSearch.search(variable, new LocalSearchScope(scope));
            Collection<PsiReference> refs = query.findAll();
            for (PsiReference ref : refs) {
                PsiElement target = ref.getElement();
                if (!(target instanceof PsiReferenceExpression) || !target.isValid()) continue;
                this.replace(variable, results, (PsiReferenceExpression)target, ct);
            }
        }

        private void replace(PsiVariable variable, List<PsiElement> results, PsiReferenceExpression ref, CommentTracker ct) {
            PsiBinaryExpression binOp;
            PsiMethodCallExpression call;
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp(ref.getParent());
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (PsiUtil.skipParenthesizedExprDown(assignment.getLExpression()) == ref) {
                    this.replaceInAssignment(variable, results, assignment, ct);
                    return;
                }
                if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                    return;
                }
            }
            if ((methodCallExpression = ExpressionUtils.getCallForQualifier(ref)) != null) {
                ReplaceWithStringBuilderFix.replaceInCallQualifier(variable, results, methodCallExpression, ct);
                return;
            }
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression && (expressions = ((PsiExpressionList)parent).getExpressions()).length == 1 && expressions[0] == ref && ReplaceWithStringBuilderFix.canAcceptBuilderInsteadOfString(call = (PsiMethodCallExpression)parent.getParent())) {
                return;
            }
            if (parent instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull(binOp = (PsiBinaryExpression)parent) != null) {
                return;
            }
            if (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = ((PsiPolyadicExpression)parent).getOperands()) {
                    if (operand == ref) break;
                    if (!TypeUtils.isJavaLangString(operand.getType())) continue;
                    return;
                }
                if (operands.length > 1 && operands[0] == ref && TypeUtils.isJavaLangString(operands[1].getType())) {
                    return;
                }
            }
            results.add(ct.replace((PsiElement)ref, variable.getName() + ".toString()"));
        }

        private static boolean canAcceptBuilderInsteadOfString(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.lang.StringBuilder", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.lang.StringBuffer", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintStream", null, PRINT_OR_PRINTLN, (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintWriter", null, PRINT_OR_PRINTLN, (PsiType[])null);
        }

        private static void replaceInCallQualifier(PsiVariable variable, List<PsiElement> results, PsiMethodCallExpression call, CommentTracker ct) {
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                String name;
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name = method.getName()) {
                    case "length": 
                    case "chars": 
                    case "codePoints": 
                    case "charAt": 
                    case "codePointAt": 
                    case "codePointBefore": 
                    case "codePointAfter": 
                    case "codePointCount": 
                    case "offsetByCodePoints": 
                    case "substring": 
                    case "subSequence": {
                        return;
                    }
                    case "getChars": {
                        if (args.length != 4) break;
                        return;
                    }
                    case "indexOf": 
                    case "lastIndexOf": {
                        if (args.length < 1 || args.length > 2 || !TypeUtils.isJavaLangString(args[0].getType())) break;
                        return;
                    }
                    case "isEmpty": {
                        String sign = "==";
                        PsiExpression negation = BoolUtils.findNegation(call);
                        PsiExpression toReplace = call;
                        if (negation != null) {
                            sign = ">";
                            toReplace = negation;
                        }
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory(variable.getProject());
                        PsiExpression emptyCheck = factory.createExpressionFromText(variable.getName() + ".length()" + sign + "0", call);
                        PsiElement callParent = toReplace.getParent();
                        if (callParent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(emptyCheck, (PsiExpression)callParent, true)) {
                            emptyCheck = factory.createExpressionFromText("(" + emptyCheck.getText() + ")", call);
                        }
                        results.add(ct.replace((PsiElement)toReplace, emptyCheck));
                        return;
                    }
                }
            }
            PsiExpression qualifier = Objects.requireNonNull(call.getMethodExpression().getQualifierExpression());
            results.add(ct.replace((PsiElement)qualifier, variable.getName() + ".toString()"));
        }

        private void replaceInAssignment(PsiVariable variable, List<PsiElement> results, PsiAssignmentExpression assignment, CommentTracker ct) {
            PsiPolyadicExpression concat2;
            PsiExpression[] operands;
            PsiExpression rValue = PsiUtil.skipParenthesizedExprDown(assignment.getRExpression());
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ) && rValue instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)rValue).getOperationTokenType().equals(JavaTokenType.PLUS) && (operands = (concat2 = (PsiPolyadicExpression)rValue).getOperands()).length > 1) {
                if (ExpressionUtils.isReferenceTo(operands[0], variable)) {
                    ct.delete(concat2.getTokenBeforeOperand(operands[1]), operands[0]);
                    this.replaceAll(variable, rValue, results, ct);
                    results.add(ct.replace((PsiElement)assignment, variable.getName() + ".append(" + ct.text(rValue) + ")"));
                    return;
                }
                PsiExpression lastOp = operands[operands.length - 1];
                if (ExpressionUtils.isReferenceTo(lastOp, variable)) {
                    ct.delete(concat2.getTokenBeforeOperand(lastOp), lastOp);
                    this.replaceAll(variable, rValue, results, ct);
                    results.add(ct.replace((PsiElement)assignment, variable.getName() + ".insert(0," + ct.text(rValue) + ")"));
                    return;
                }
            }
            if (rValue != null) {
                this.replaceAll(variable, rValue, results, ct);
                rValue = assignment.getRExpression();
            }
            if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                results.add(ct.replace((PsiElement)assignment, variable.getName() + ".append(" + (rValue == null ? "" : ct.text(rValue)) + ")"));
            } else if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                results.add(ct.replace((PsiElement)assignment, variable.getName() + "=" + this.generateNewStringBuilder(rValue, ct)));
            }
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix.name", this.myName, this.myTargetType);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            PsiExpression[] operands = expression.getOperands();
            if (operands.length <= 1) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            if (!this.checkExpression(expression)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime(expression)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.isAppendedRepeatedly(expression)) {
                return;
            }
            PsiJavaToken sign = expression.getTokenBeforeOperand(operands[1]);
            assert (sign != null);
            this.registerError((PsiElement)sign, StringConcatenationInLoopsInspection.getAppendedVariable(expression));
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            if (!this.checkExpression(expression)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(expression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)sign, StringConcatenationInLoopsInspection.getAppendedVariable(expression));
        }

        private boolean checkExpression(PsiExpression expression) {
            PsiVariable variable;
            if (!TypeUtils.isJavaLangString(expression.getType()) || ControlFlowUtils.isInExitStatement(expression) || !ControlFlowUtils.isInLoop(expression)) {
                return false;
            }
            PsiElement parent = expression;
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (parent != expression && parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                return false;
            }
            if (parent instanceof PsiAssignmentExpression && (variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression = parent)) != null) {
                PsiLoopStatement commonLoop = this.getOutermostCommonLoop(expression, variable);
                return commonLoop != null && !ControlFlowUtils.flowBreaksLoop(PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class), commonLoop);
            }
            return false;
        }

        private PsiLoopStatement getOutermostCommonLoop(PsiExpression expression, PsiVariable variable) {
            PsiElement stopAt = null;
            PsiCodeBlock block = StringConcatenationInLoopsVisitor.getSurroundingBlock(expression);
            if (block != null) {
                PsiElement ref;
                if (expression instanceof PsiAssignmentExpression) {
                    ref = expression;
                } else {
                    PsiReference reference = ReferencesSearch.search(variable, new LocalSearchScope(expression)).findFirst();
                    PsiElement psiElement = ref = reference != null ? reference.getElement() : null;
                }
                if (ref != null) {
                    PsiElement[] elements = (PsiElement[])StreamEx.of((Object[])DefUseUtil.getDefs(block, variable, expression)).prepend((Object)expression).toArray(PsiElement[]::new);
                    stopAt = PsiTreeUtil.findCommonParent(elements);
                }
            }
            PsiLoopStatement commonLoop = null;
            for (PsiElement parent = expression.getParent(); !(parent == null || parent == stopAt || parent instanceof PsiMethod || parent instanceof PsiClass || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
                if (!(parent instanceof PsiLoopStatement)) continue;
                commonLoop = (PsiLoopStatement)parent;
            }
            return commonLoop;
        }

        @Nullable
        private static PsiCodeBlock getSurroundingBlock(PsiElement expression) {
            PsiElement body;
            Object parent = PsiTreeUtil.getParentOfType(expression, PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class);
            if (parent instanceof PsiMethod) {
                return ((PsiMethod)parent).getBody();
            }
            if (parent instanceof PsiClassInitializer) {
                return ((PsiClassInitializer)parent).getBody();
            }
            if (parent instanceof PsiLambdaExpression && (body = ((PsiLambdaExpression)parent).getBody()) instanceof PsiCodeBlock) {
                return (PsiCodeBlock)body;
            }
            return null;
        }

        private static boolean isAppendedRepeatedly(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)element;
            PsiExpression rhs = assignmentExpression.getRExpression();
            return StringConcatenationInLoopsVisitor.isAppended(variable, rhs);
        }

        private static boolean isAppended(PsiVariable variable, PsiExpression expression) {
            PsiPolyadicExpression polyadicExpression;
            if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiPolyadicExpression && (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!ExpressionUtils.isReferenceTo(operand, variable) && !StringConcatenationInLoopsVisitor.isAppended(variable, operand)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

