/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.HighlightInfo");
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    JComponent fileLevelComponent;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    private int group;
    public final int startOffset;
    public final int endOffset;
    private int fixStartOffset;
    private int fixEndOffset;
    RangeMarker fixMarker;
    private final String description;
    private final String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    final int navigationShift;
    volatile RangeHighlighterEx highlighter;
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    private volatile byte myFlags;
    private static final byte BIJECTIVE_MASK = 1;
    private static final byte HAS_HINT_MASK = 2;
    private static final byte FROM_INJECTION_MASK = 4;
    private static final byte AFTER_END_OF_LINE_MASK = 8;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 16;
    private static final byte NEEDS_UPDATE_ON_TYPING_MASK = 32;
    PsiElement psiElement;
    private static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";

    @NotNull
    ProperTextRange getFixTextRange() {
        ProperTextRange properTextRange = new ProperTextRange(this.fixStartOffset, this.fixEndOffset);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getFixTextRange"));
        }
        return properTextRange;
    }

    void setFromInjection(boolean fromInjection) {
        this.setFlag((byte)4, fromInjection);
    }

    @Nullable
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null || description == null || !toolTip.contains(DESCRIPTION_PLACEHOLDER)) {
            return toolTip;
        }
        String decoded = StringUtil.replace(toolTip, DESCRIPTION_PLACEHOLDER, XmlStringUtil.escapeString(description));
        return XmlStringUtil.wrapInHtml(decoded);
    }

    private static String encodeTooltip(String toolTip, String description) {
        String encoded;
        if (toolTip == null || description == null) {
            return toolTip;
        }
        String unescaped = StringUtil.unescapeXml(XmlStringUtil.stripHtml(toolTip));
        String string = encoded = description.isEmpty() ? unescaped : StringUtil.replace(unescaped, description, DESCRIPTION_PLACEHOLDER);
        if (encoded == unescaped) {
            return toolTip;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return encoded;
    }

    public String getDescription() {
        return this.description;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)16);
    }

    boolean isBijective() {
        return this.isFlagSet((byte)1);
    }

    void setBijective(boolean bijective) {
        this.setFlag((byte)1, bijective);
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getSeverity"));
        }
        return highlightSeverity;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)8);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element, this.type, colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getAttributesByType"));
        }
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getAttributesByType"));
        }
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element != null ? element.getProject() : null);
        TextAttributes textAttributes = severityRegistrar.getTextAttributesBySeverity(type.getSeverity(element));
        if (textAttributes != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    Color getErrorStripeMarkColor(@NotNull PsiElement element, @Nullable EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getErrorStripeMarkColor"));
        }
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type, scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getColorsScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    @Nullable
    @NonNls
    private static String htmlEscapeToolTip(@Nullable String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(unescapedTooltip));
    }

    boolean needUpdateOnTyping() {
        return this.isFlagSet((byte)32);
    }

    HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable String escapedDescription, @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, ProblemGroup problemGroup, GutterMark gutterIconRenderer) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "<init>"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "<init>"));
        }
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + escapedDescription + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixStartOffset = startOffset;
        this.fixEndOffset = endOffset;
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.setFlag((byte)8, afterEndOfLine);
        this.setFlag((byte)32, HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type));
        this.setFlag((byte)16, isFileLevelAnnotation);
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type instanceof HighlightInfoType.UpdateOnTypingSuppressible) {
            return ((HighlightInfoType.UpdateOnTypingSuppressible)((Object)type)).needsUpdateOnTyping();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return info.getSeverity() == this.getSeverity() && info.startOffset == this.startOffset && info.endOffset == this.endOffset && Comparing.equal(info.type, this.type) && Comparing.equal(info.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info.getDescription(), this.getDescription());
    }

    boolean equalsByActualOffset(@NotNull HighlightInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "equalsByActualOffset"));
        }
        if (info == this) {
            return true;
        }
        return info.getSeverity() == this.getSeverity() && info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal(info.type, this.type) && Comparing.equal(info.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info.getDescription(), this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    @NonNls
    public String toString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.highlighter != null) {
            s = s + " text='" + this.getText() + "'";
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + " severity=" + this.getSeverity();
        s = s + " group=" + this.getGroup();
        if (this.quickFixActionRanges != null) {
            s = s + "; quickFixes: " + this.quickFixActionRanges;
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + this.gutterIconRenderer;
        }
        return s;
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "newHighlightInfo"));
        }
        B b = new B(type);
        if (b == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "newHighlightInfo"));
        }
        return b;
    }

    void setGroup(int group) {
        this.group = group;
    }

    private static boolean isAcceptedByFilters(@NotNull HighlightInfo info, @Nullable PsiElement psiElement) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "isAcceptedByFilters"));
        }
        PsiFile file = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter : Holder.FILTERS) {
            if (filter.accept(info, file)) continue;
            return false;
        }
        info.psiElement = psiElement;
        return true;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        HighlightInfo highlightInfo = HighlightInfo.fromAnnotation(annotation, null, false);
        if (highlightInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        return highlightInfo;
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Annotation annotation, @Nullable TextRange fixedRange, boolean batchMode) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null ? (key == HighlighterColors.NO_HIGHLIGHTING ? null : key) : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), fixedRange != null ? fixedRange.getStartOffset() : annotation.getStartOffset(), fixedRange != null ? fixedRange.getEndOffset() : annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), annotation.getGutterIconRenderer());
        HighlightInfo.appendFixes(fixedRange, info, batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes());
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "fromAnnotation"));
        }
        return highlightInfo;
    }

    private static void appendFixes(@Nullable TextRange fixedRange, @NotNull HighlightInfo info, @Nullable List<Annotation.QuickFixInfo> fixes) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "appendFixes"));
        }
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                TextRange range = fixedRange != null ? fixedRange : quickFixInfo.textRange;
                HighlightDisplayKey key = quickFixInfo.key != null ? quickFixInfo.key : HighlightDisplayKey.find(ANNOTATOR_INSPECTION_SHORT_NAME);
                info.registerFix(quickFixInfo.quickFix, null, HighlightDisplayKey.getDisplayNameByKey(key), range, key);
            }
        }
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
        }
        ProblemHighlightType type = annotation.getHighlightType();
        if (type == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            if (highlightInfoType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
            }
            return highlightInfoType;
        }
        if (type == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
            if (highlightInfoType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
            }
            return highlightInfoType;
        }
        if (type == ProblemHighlightType.LIKE_DEPRECATED) {
            HighlightInfoType highlightInfoType = HighlightInfoType.DEPRECATED;
            if (highlightInfoType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
            }
            return highlightInfoType;
        }
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity(annotation.getSeverity());
        if (highlightInfoType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
        }
        return highlightInfoType;
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertSeverity"));
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertSeverity"));
        }
        return highlightInfoType;
    }

    @NotNull
    public static ProblemHighlightType convertType(HighlightInfoType infoType) {
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.ERROR;
            if (problemHighlightType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.WARNING) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertType"));
        }
        return problemHighlightType;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(HighlightSeverity severity) {
        ProblemHighlightType problemHighlightType = severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
        if (problemHighlightType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "convertSeverityToProblemHighlight"));
        }
        return problemHighlightType;
    }

    public boolean hasHint() {
        return this.isFlagSet((byte)2);
    }

    void setHint(boolean hasHint) {
        this.setFlag((byte)2, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    int getGroup() {
        return this.group;
    }

    boolean isFromInjection() {
        return this.isFlagSet((byte)4);
    }

    @NotNull
    public String getText() {
        if (this.isFileLevelAnnotation()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getText"));
            }
            return "";
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        if (!highlighter.isValid()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getText"));
            }
            return "";
        }
        String string = highlighter.getDocument().getText(TextRange.create(highlighter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "getText"));
        }
        return string;
    }

    public void registerFix(@Nullable IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(this.startOffset, this.endOffset);
        }
        if (this.quickFixActionRanges == null) {
            this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        IntentionActionDescriptor desc = new IntentionActionDescriptor(action, options, displayName, null, key, this.getProblemGroup(), this.getSeverity());
        this.quickFixActionRanges.add(Pair.create(desc, fixRange));
        this.fixStartOffset = Math.min(this.fixStartOffset, fixRange.getStartOffset());
        this.fixEndOffset = Math.max(this.fixEndOffset, fixRange.getEndOffset());
        if (action instanceof HintAction) {
            this.setHint(true);
        }
    }

    public void unregisterQuickFix(@NotNull Condition<IntentionAction> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/daemon/impl/HighlightInfo", "unregisterQuickFix"));
        }
        Iterator<Pair<IntentionActionDescriptor, TextRange>> it = this.quickFixActionRanges.iterator();
        while (it.hasNext()) {
            Pair<IntentionActionDescriptor, TextRange> pair = it.next();
            if (!condition.value(((IntentionActionDescriptor)pair.first).getAction())) continue;
            it.remove();
        }
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile List<IntentionAction> myOptions;
        private volatile HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;

        IntentionActionDescriptor(@NotNull IntentionAction action, List<IntentionAction> options, String displayName) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this(action, options, displayName, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, Icon icon) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this(action, null, null, icon);
        }

        IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this(action, options, displayName, icon, null, null, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "<init>"));
            }
            this.myAction = action;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "getAction"));
            }
            return intentionAction;
        }

        boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        boolean canCleanup(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "canCleanup"));
            }
            if (this.myCanCleanup == null) {
                InspectionToolWrapper toolWrapper;
                InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
                HighlightDisplayKey key = this.myKey;
                this.myCanCleanup = key == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile2.getInspectionTool(key.toString(), element)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<IntentionAction> getOptions(@NotNull PsiElement element, @Nullable Editor editor) {
            HighlightDisplayKey idkey;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor", "getOptions"));
            }
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                return null;
            }
            List<IntentionAction> options = this.myOptions;
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById(problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if (options != null || key == null) {
                return options;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            List<IntentionAction> newOptions = intentionManager.getStandardIntentionOptions(key, element);
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
            InspectionToolWrapper toolWrapper = profile2.getInspectionTool(key.toString(), element);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) && (idkey = HighlightDisplayKey.findById(key.toString())) != null) {
                toolWrapper = profile2.getInspectionTool(idkey.toString(), element);
            }
            if (toolWrapper != null) {
                Object wrappedTool;
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                Object t = wrappedTool = toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)toolWrapper).getTool() : ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                if (wrappedTool instanceof DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection) {
                    List<IntentionAction> actions = Collections.emptyList();
                    if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                        actions = Arrays.asList(((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            return Collections.singletonList(fixAllIntention);
                        }
                        actions = new ArrayList<IntentionAction>(actions);
                        actions.add(fixAllIntention);
                    }
                    return actions;
                }
                ContainerUtil.addIfNotNull(newOptions, fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    SuppressIntentionAction[] suppressActions = ((CustomSuppressableInspectionTool)wrappedTool).getSuppressActions(element);
                    if (suppressActions != null) {
                        ContainerUtil.addAll(newOptions, suppressActions);
                    }
                } else {
                    SuppressQuickFix[] suppressFixes = ((InspectionProfileEntry)wrappedTool).getBatchSuppressActions(element);
                    if (suppressFixes.length > 0) {
                        ContainerUtil.addAll(newOptions, ContainerUtil.map(suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                SuppressIntentionAction[] suppressActions = ((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element);
                ContainerUtil.addAll(newOptions, suppressActions);
            }
            IntentionActionDescriptor intentionActionDescriptor = this;
            synchronized (intentionActionDescriptor) {
                options = this.myOptions;
                if (options == null) {
                    this.myOptions = options = newOptions;
                }
                this.myKey = null;
            }
            return options;
        }

        @Nullable
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NonNls
        public String toString() {
            String text = this.getAction().getText();
            return "descriptor: " + (text.isEmpty() ? this.getAction().getClass() : text);
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntentionActionDescriptor && this.myAction.equals(((IntentionActionDescriptor)obj).myAction);
        }
    }

    private static class B
    implements Builder {
        private Boolean myNeedsUpdateOnTyping;
        private TextAttributes forcedTextAttributes;
        private TextAttributesKey forcedTextAttributesKey;
        private final HighlightInfoType type;
        private int startOffset;
        private int endOffset;
        private String escapedDescription;
        private String escapedToolTip;
        private HighlightSeverity severity;
        private boolean isAfterEndOfLine;
        private boolean isFileLevelAnnotation;
        private int navigationShift;
        private GutterIconRenderer gutterIconRenderer;
        private ProblemGroup problemGroup;
        private PsiElement psiElement;

        private B(@NotNull HighlightInfoType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "<init>"));
            }
            this.startOffset = -1;
            this.endOffset = -1;
            this.type = type;
        }

        @Override
        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
            if (gutterIconRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gutterIconRenderer", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "gutterIconRenderer"));
            }
            assert (this.gutterIconRenderer == null) : "gutterIconRenderer already set";
            this.gutterIconRenderer = gutterIconRenderer;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "gutterIconRenderer"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup problemGroup) {
            if (problemGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemGroup", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "problemGroup"));
            }
            assert (this.problemGroup == null) : "problemGroup already set";
            this.problemGroup = problemGroup;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "problemGroup"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder description(@NotNull String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "description"));
            }
            assert (this.escapedDescription == null) : "description already set";
            this.escapedDescription = description;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "description"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder descriptionAndTooltip(@NotNull String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "descriptionAndTooltip"));
            }
            Builder builder = this.description(description).unescapedToolTip(description);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "descriptionAndTooltip"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributes attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            assert (this.forcedTextAttributes == null) : "textattributes already set";
            this.forcedTextAttributes = attributes;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
            if (attributesKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributesKey", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            assert (this.forcedTextAttributesKey == null) : "textattributesKey already set";
            this.forcedTextAttributesKey = attributesKey;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "textAttributes"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder unescapedToolTip(@NotNull String unescapedToolTip) {
            if (unescapedToolTip == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unescapedToolTip", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "unescapedToolTip"));
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = HighlightInfo.htmlEscapeToolTip(unescapedToolTip);
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "unescapedToolTip"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder escapedToolTip(@NotNull String escapedToolTip) {
            if (escapedToolTip == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escapedToolTip", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "escapedToolTip"));
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = escapedToolTip;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "escapedToolTip"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(int start, int end) {
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = start;
            this.endOffset = end;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull TextRange textRange) {
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = textRange.getStartOffset();
            this.endOffset = textRange.getEndOffset();
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            Builder builder = this.range(node.getPsi());
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element;
            Builder builder = this.range(element.getTextRange());
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element, int start, int end) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element;
            Builder builder = this.range(start, end);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "range"));
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder endOfLine() {
            this.isAfterEndOfLine = true;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "endOfLine"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder needsUpdateOnTyping(boolean update) {
            assert (this.myNeedsUpdateOnTyping == null) : " needsUpdateOnTyping already set";
            this.myNeedsUpdateOnTyping = update;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "needsUpdateOnTyping"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder severity(@NotNull HighlightSeverity severity) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "severity"));
            }
            assert (this.severity == null) : " severity already set";
            this.severity = severity;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "severity"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder fileLevelAnnotation() {
            this.isFileLevelAnnotation = true;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "fileLevelAnnotation"));
            }
            return b;
        }

        @Override
        @NotNull
        public Builder navigationShift(int navigationShift) {
            this.navigationShift = navigationShift;
            B b = this;
            if (b == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "navigationShift"));
            }
            return b;
        }

        @Override
        @Nullable
        public HighlightInfo create() {
            HighlightInfo info = this.createUnconditionally();
            LOG.assertTrue(this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtilRt.find(HighlightSeverity.DEFAULT_SEVERITIES, this.severity) != -1, "Custom type requires not-null element to detect its text attributes");
            if (!HighlightInfo.isAcceptedByFilters(info, this.psiElement)) {
                return null;
            }
            return info;
        }

        @Override
        @NotNull
        public HighlightInfo createUnconditionally() {
            if (this.severity == null) {
                this.severity = this.type.getSeverity(this.psiElement);
            }
            HighlightInfo highlightInfo = new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation, this.navigationShift, this.problemGroup, this.gutterIconRenderer);
            if (highlightInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$B", "createUnconditionally"));
            }
            return highlightInfo;
        }
    }

    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @NotNull
        public Builder description(@NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @Nullable(value="null means filtered out")
        public HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();
    }

    private static class Holder {
        private static final HighlightInfoFilter[] FILTERS = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();

        private Holder() {
        }
    }

    private static @interface FlagConstant {
    }
}

