/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InstanceGuardedByStaticInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Instance member guarded by static field" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection", "getDisplayName"));
        }
        return "Instance member guarded by static field";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("InstanceGuardedByStatic" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection", "getShortName"));
        }
        return "InstanceGuardedByStatic";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/InstanceGuardedByStaticInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiMember.class);
            if (member == null) {
                return;
            }
            if (member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (!guardField.hasModifierProperty("static")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Instance member guarded by static \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class);
            if (member == null) {
                return;
            }
            if (member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null) {
                return;
            }
            PsiAnnotationMemberValue guardRef = annotation.findAttributeValue("value");
            if (guardRef == null) {
                return;
            }
            PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (!guardField.hasModifierProperty("static")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)guardRef, "Instance member guarded by static #ref #loc", new LocalQuickFix[0]);
        }
    }
}

