/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

class LockFreeCOWSortedArray<T> {
    @NotNull
    private final Comparator<? super T> comparator;
    private final ArrayFactory<T> arrayFactory;
    @NotNull
    private volatile T[] listeners;
    private static final AtomicFieldUpdater<LockFreeCOWSortedArray, Object[]> UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCOWSortedArray.class, Object[].class);

    LockFreeCOWSortedArray(@NotNull Comparator<? super T> comparator, @NotNull ArrayFactory<T> arrayFactory) {
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "<init>"));
        }
        if (arrayFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayFactory", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "<init>"));
        }
        this.comparator = comparator;
        this.arrayFactory = arrayFactory;
        this.listeners = arrayFactory.create(0);
    }

    void add(@NotNull T listener) {
        int i2;
        T[] newListeners;
        T[] oldListeners;
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "add"));
        }
        while (!UPDATER.compareAndSet(this, oldListeners = this.listeners, newListeners = ArrayUtil.insert(oldListeners, i2 = this.insertionIndex(oldListeners, listener), listener))) {
        }
    }

    boolean remove(@NotNull T listener) {
        T[] newListeners;
        T[] oldListeners;
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "remove"));
        }
        do {
            if ((oldListeners = this.listeners) != (newListeners = ArrayUtil.remove(oldListeners, listener, this.arrayFactory))) continue;
            return false;
        } while (!UPDATER.compareAndSet(this, oldListeners, newListeners));
        return true;
    }

    private int insertionIndex(@NotNull T[] elements, @NotNull T e) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "insertionIndex"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "insertionIndex"));
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            T element = elements[i2];
            if (this.comparator.compare(e, element) >= 0) continue;
            return i2;
        }
        return elements.length;
    }

    @NotNull
    T[] getArray() {
        if (this.listeners == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray", "getArray"));
        }
        return this.listeners;
    }
}

