/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.graph.Graph;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManager
extends SimpleModificationTracker {
    public static ModuleManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/ModuleManager", "getInstance"));
        }
        return project.getComponent(ModuleManager.class);
    }

    @NotNull
    public abstract Module newModule(@NotNull @NonNls String var1, String var2);

    @NotNull
    public abstract Module loadModule(@NotNull String var1) throws InvalidDataException, IOException, JDOMException, ModuleWithNameAlreadyExists;

    public abstract void disposeModule(@NotNull Module var1);

    @NotNull
    public abstract Module[] getModules();

    @Nullable
    public abstract Module findModuleByName(@NonNls @NotNull String var1);

    @NotNull
    public abstract Module[] getSortedModules();

    @NotNull
    public abstract Comparator<Module> moduleDependencyComparator();

    @NotNull
    public abstract List<Module> getModuleDependentModules(@NotNull Module var1);

    public abstract boolean isModuleDependent(@NotNull Module var1, @NotNull Module var2);

    @NotNull
    public abstract Graph<Module> moduleGraph();

    @NotNull
    public abstract Graph<Module> moduleGraph(boolean var1);

    @NotNull
    public abstract ModifiableModuleModel getModifiableModel();

    @Nullable
    public abstract String[] getModuleGroupPath(@NotNull Module var1);

    public abstract boolean hasModuleGroups();
}

