/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(@NotNull Project project, @NotNull VirtualFile file, boolean isLibraryElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/ModuleUtilCore", "projectContainsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/ModuleUtilCore", "projectContainsFile"));
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orders) {
                if (!(orderEntry instanceof ModuleJdkOrderEntry) && !(orderEntry instanceof JdkOrderEntry) && !(orderEntry instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file);
    }

    @NotNull
    public static String getModuleNameInReadAction(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "getModuleNameInReadAction"));
        }
        String string = ApplicationManager.getApplication().runReadAction(module::getName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleUtilCore", "getModuleNameInReadAction"));
        }
        return string;
    }

    public static boolean isModuleDisposed(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/ModuleUtilCore", "isModuleDisposed"));
        }
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        Module module2 = module = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module == null ? !projectFileIndex.isInLibraryClasses(vFile) : module.isDisposed();
    }

    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/ModuleUtilCore", "findModuleForFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/ModuleUtilCore", "findModuleForFile"));
        }
        return ProjectFileIndex.SERVICE.getInstance(project).getModuleForFile(file);
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/ModuleUtilCore", "findModuleForPsiElement"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null ? !element.isValid() : !containingFile.isValid()) {
            return null;
        }
        Project project = (containingFile == null ? element : containingFile).getProject();
        if (project.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                if (orderEntries.size() == 1) {
                    return orderEntries.get(0).getOwnerModule();
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (OrderEntry orderEntry : orderEntries) {
                    modules.add(orderEntry.getOwnerModule());
                }
                Module[] candidates = modules.toArray(new Module[modules.size()]);
                Arrays.sort(candidates, ModuleManager.getInstance(project).moduleDependencyComparator());
                return candidates[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            PsiFile file;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file = context.getContainingFile()) != null) {
                containingFile = file;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile = originalFile.getVirtualFile();
            if (virtualFile != null) {
                return fileIndex.getModuleForFile(virtualFile);
            }
        }
        return element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module, @NotNull Set<Module> modules) {
        Module[] dependencies;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "getDependencies"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/module/ModuleUtilCore", "getDependencies"));
        }
        if (modules.contains(module)) {
            return;
        }
        modules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules);
        }
    }

    public static void collectModulesDependsOn(@NotNull Module module, @NotNull Set<Module> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "collectModulesDependsOn"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/module/ModuleUtilCore", "collectModulesDependsOn"));
        }
        if (!result.add(module)) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance(module.getProject());
        List<Module> dependentModules = moduleManager.getModuleDependentModules(module);
        block0: for (Module dependentModule : dependentModules) {
            OrderEntry[] orderEntries;
            for (OrderEntry o : orderEntries = ModuleRootManager.getInstance(dependentModule).getOrderEntries()) {
                ModuleOrderEntry orderEntry;
                if (!(o instanceof ModuleOrderEntry) || (orderEntry = (ModuleOrderEntry)o).getModule() != module) continue;
                if (orderEntry.isExported()) {
                    ModuleUtilCore.collectModulesDependsOn(dependentModule, result);
                    continue block0;
                }
                result.add(dependentModule);
                continue block0;
            }
        }
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "getAllDependentModules"));
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = ModuleManager.getInstance(module.getProject()).moduleGraph();
        Iterator<Module> i2 = graph.getOut(module);
        while (i2.hasNext()) {
            list.add(i2.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleUtilCore", "getAllDependentModules"));
        }
        return arrayList;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module, @NotNull ModuleVisitor visitor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "visitMeAndDependentModules"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/openapi/module/ModuleUtilCore", "visitMeAndDependentModules"));
        }
        if (!visitor.visit(module)) {
            return false;
        }
        List<Module> list = ModuleUtilCore.getAllDependentModules(module);
        for (Module dependentModule : list) {
            if (visitor.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(@NotNull Module module, @NotNull VirtualFile file, boolean isLibraryElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "moduleContainsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/ModuleUtilCore", "moduleContainsFile"));
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof ModuleJdkOrderEntry || orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file);
    }

    public static boolean isModuleFile(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "isModuleFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/ModuleUtilCore", "isModuleFile"));
        }
        return FileUtil.namesEqual(file.getPath(), module.getModuleFilePath());
    }

    public static boolean isModuleDir(@NotNull Module module, @NotNull VirtualFile dir) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "isModuleDir"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/module/ModuleUtilCore", "isModuleDir"));
        }
        return FileUtil.namesEqual(dir.getPath(), ModuleUtilCore.getModuleDirPath(module));
    }

    @NotNull
    public static String getModuleDirPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/ModuleUtilCore", "getModuleDirPath"));
        }
        String string = PathUtilRt.getParentPath(module.getModuleFilePath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/ModuleUtilCore", "getModuleDirPath"));
        }
        return string;
    }

    @FunctionalInterface
    public static interface ModuleVisitor {
        public boolean visit(@NotNull Module var1);
    }
}

