/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public boolean isStubReloadingProhibited() {
        return false;
    }

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    public String getStubAstMismatchDiagnostics(@NotNull VirtualFile file, @NotNull PsiFile psiFile, @NotNull ObjectStubTree stubTree, @Nullable Document prevCachedDocument) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        String msg = "";
        msg = msg + "\n file=" + psiFile;
        msg = msg + ", file.class=" + psiFile.getClass();
        msg = msg + ", file.lang=" + psiFile.getLanguage();
        msg = msg + ", modStamp=" + psiFile.getModificationStamp();
        if (!(psiFile instanceof PsiCompiledElement)) {
            String text = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString(psiFile, true).equals(DebugUtil.psiToString(fromText, true));
                msg = consistent ? msg + "\n tree consistent" : msg + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg = msg + "\n document before=" + prevCachedDocument;
        ObjectStubTree latestIndexedStub = this.readFromVFile(psiFile.getProject(), file);
        msg = msg + "\nlatestIndexedStub=" + latestIndexedStub;
        if (latestIndexedStub != null) {
            msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == latestIndexedStub.getPlainList().size());
            msg = msg + "\n   debugInfo=" + latestIndexedStub.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg = msg + "; file stamp: " + file.getModificationStamp();
        msg = msg + "; file modCount: " + file.getModificationCount();
        msg = msg + "; file length: " + file.getLength();
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
        }
        return msg;
    }

    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/stubs/StubTreeLoader", "getFileViewProviderMismatchDiagnostics"));
        }
        Function<Language, String> languageID = new Function<Language, String>(){

            @Override
            public String fun(Language language) {
                return language.getID();
            }
        };
        final Function<PsiFile, String> fileClassName = new Function<PsiFile, String>(){

            @Override
            public String fun(PsiFile file) {
                return file.getClass().getSimpleName();
            }
        };
        Function<PsiFile, String> fileToFileType = new Function<PsiFile, String>(){

            @Override
            public String fun(PsiFile file) {
                return file.getFileType().getName();
            }
        };
        Function<Pair<IStubFileElementType, PsiFile>, String> stubRootToString = new Function<Pair<IStubFileElementType, PsiFile>, String>(){

            @Override
            public String fun(Pair<IStubFileElementType, PsiFile> pair) {
                return "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun(pair.second) + ")";
            }
        };
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(provider);
        return "path = " + provider.getVirtualFile().getPath() + ", stubBindingRoot = " + (String)fileClassName.fun(provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider.getLanguages(), languageID, ", ") + "], filesTypes = [" + StringUtil.join(provider.getAllFiles(), fileToFileType, ", ") + "], files = [" + StringUtil.join(provider.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots, stubRootToString, ", ") + "]";
    }
}

