/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class LimitedPool<T> {
    private final int maxCapacity;
    private final ObjectFactory<T> factory;
    private Object[] storage;
    private int index;

    public LimitedPool(int maxCapacity, @NotNull ObjectFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/LimitedPool", "<init>"));
        }
        this.maxCapacity = maxCapacity;
        this.factory = factory;
        this.storage = new Object[10];
    }

    @NotNull
    public T alloc() {
        if (this.index == 0) {
            T t = this.factory.create();
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LimitedPool", "alloc"));
            }
            return t;
        }
        int i2 = --this.index;
        Object result = this.storage[i2];
        this.storage[i2] = null;
        Object object = result;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LimitedPool", "alloc"));
        }
        return (T)object;
    }

    public void recycle(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/LimitedPool", "recycle"));
        }
        this.factory.cleanup(t);
        if (this.index >= this.maxCapacity) {
            return;
        }
        this.ensureCapacity();
        this.storage[this.index++] = t;
    }

    private void ensureCapacity() {
        if (this.storage.length <= this.index) {
            int newCapacity = Math.min(this.maxCapacity, this.storage.length * 3 / 2);
            this.storage = ArrayUtil.realloc(this.storage, newCapacity, ArrayUtil.OBJECT_ARRAY_FACTORY);
        }
    }

    public static interface ObjectFactory<T> {
        @NotNull
        public T create();

        public void cleanup(@NotNull T var1);
    }
}

