/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;
    private final boolean myCanHavePersistentIndex;
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;

    FileLoader(URL url, int index, boolean canHavePersistentIndex) throws IOException {
        super(url, index);
        this.myRootDir = new File(FileUtil.unquote(url.getFile()));
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
        this.myCanHavePersistentIndex = canHavePersistentIndex;
    }

    private void buildPackageCache(File dir, ClasspathCache.LoaderData loaderData) {
        loaderData.addResourceEntry(this.getRelativeResourcePath(dir));
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file : files) {
            boolean isClass = file.getPath().endsWith(".class");
            if (isClass) {
                if (!containsClasses) {
                    loaderData.addResourceEntry(this.getRelativeResourcePath(file));
                    containsClasses = true;
                }
                loaderData.addNameEntry(file.getName());
                continue;
            }
            loaderData.addNameEntry(file.getName());
            this.buildPackageCache(file, loaderData);
        }
    }

    private String getRelativeResourcePath(File file) {
        return this.getRelativeResourcePath(file.getAbsolutePath());
    }

    private String getRelativeResourcePath(String absFilePath) {
        String relativePath = absFilePath.substring(this.myRootDirAbsolutePath.length());
        relativePath = relativePath.replace(File.separatorChar, '/');
        relativePath = StringUtil.trimStart(relativePath, "/");
        return relativePath;
    }

    @Override
    @Nullable
    Resource getResource(String name, boolean check) {
        block6: {
            URL url = null;
            File file = null;
            try {
                url = new URL(this.getBaseURL(), name);
                if (!url.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                file = new File(this.myRootDir, name.replace('/', File.separatorChar));
                if (!check || file.exists()) {
                    return new MyResource(url, file, !check);
                }
            }
            catch (Exception exception) {
                if (check || file == null || !file.exists()) break block6;
                try {
                    return new MyResource(url, file, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClasspathCache.LoaderData tryReadFromIndex() {
        if (!this.myCanHavePersistentIndex) {
            return null;
        }
        long started = System.nanoTime();
        ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData();
        File index = this.getIndexFileFile();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(index));
            FileLoader.readList(reader, loaderData.getResourcePaths());
            FileLoader.readList(reader, loaderData.getNames());
            ClasspathCache.LoaderData loaderData2 = loaderData;
            return loaderData2;
        }
        catch (Exception ex) {
            if (!(ex instanceof FileNotFoundException)) {
                index.delete();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    private static void readList(BufferedReader reader, List<String> paths) throws IOException {
        String line = reader.readLine();
        int numberOfElements = Integer.parseInt(line);
        for (int i2 = 0; i2 < numberOfElements; ++i2) {
            paths.add(reader.readLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySaveToIndex(ClasspathCache.LoaderData data) {
        if (!this.myCanHavePersistentIndex) {
            return;
        }
        long started = System.nanoTime();
        File index = this.getIndexFileFile();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(index));
            FileLoader.writeList(writer, data.getResourcePaths());
            FileLoader.writeList(writer, data.getNames());
        }
        catch (IOException ex) {
            index.delete();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    private static void writeList(BufferedWriter writer, List<String> paths) throws IOException {
        writer.append(Integer.toString(paths.size())).append('\n');
        for (String s : paths) {
            writer.append(s).append('\n');
        }
    }

    @NotNull
    private File getIndexFileFile() {
        File file = new File(this.myRootDir, "classpath.index");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/FileLoader", "getIndexFileFile"));
        }
        return file;
    }

    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        long currentScanning;
        ClasspathCache.LoaderData fromIndex = this.tryReadFromIndex();
        ClasspathCache.LoaderData loaderData = fromIndex != null ? fromIndex : new ClasspathCache.LoaderData();
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (fromIndex == null) {
            long started = System.nanoTime();
            this.buildPackageCache(this.myRootDir, loaderData);
            long doneNanos = System.nanoTime() - started;
            currentScanning = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + this.myRootDirAbsolutePath + " for " + doneNanos / 1000000L + "ms");
            }
            this.trySaveToIndex(loaderData);
        } else {
            currentScanning = totalScanning.get();
        }
        loaderData.addResourceEntry("foo.class");
        loaderData.addResourceEntry("bar.properties");
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanning / 1000000L + "ms, saving: " + totalSaving.get() / 1000000L + "ms, loading:" + totalReading.get() / 1000000L + "ms for " + currentLoaders + " loaders");
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/FileLoader", "buildData"));
        }
        return loaderData2;
    }

    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private static class MyResource
    extends Resource {
        private final URL myUrl;
        private final File myFile;

        public MyResource(URL url, File file, boolean willLoadBytes) throws IOException {
            this.myUrl = url;
            this.myFile = file;
            if (willLoadBytes) {
                this.getInputStream().close();
            }
        }

        @Override
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        @Override
        public byte[] getBytes() throws IOException {
            return FileUtil.loadFileBytes(this.myFile);
        }
    }
}

