/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class AppleBoldDottedPainter {
    private static final int HEIGHT = 3;
    private static final int WIDTH = 4;
    private static final Map<Color, AppleBoldDottedPainter> myPainters = new HashMap<Color, AppleBoldDottedPainter>();
    private static final int PATTERN_WIDTH = 4000;
    private final BufferedImage myImage = UIUtil.createImage(4000, 3, 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppleBoldDottedPainter(Color color) {
        Graphics2D g = this.myImage.createGraphics();
        try {
            g.setColor(color);
            for (int i2 = 0; i2 < 1001; ++i2) {
                int offset = i2 * 4;
                g.setComposite(AlphaComposite.getInstance(2, 0.2f));
                g.drawLine(offset + 0, 0, offset + 0, 0);
                g.drawLine(offset + 2, 0, offset + 2, 0);
                g.setComposite(AlphaComposite.getInstance(2, 0.7f));
                g.drawLine(offset + 0, 1, offset + 2, 1);
                g.setComposite(AlphaComposite.getInstance(2, 1.0f));
                g.drawLine(offset + 1, 2, offset + 1, 2);
                g.setComposite(AlphaComposite.getInstance(2, 0.5f));
                g.drawLine(offset + 1, 0, offset + 1, 0);
                g.drawLine(offset + 0, 2, offset + 0, 2);
                g.drawLine(offset + 2, 2, offset + 2, 2);
            }
        }
        finally {
            g.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, int xStart, int xEnd, int y) {
        Rectangle lineClip;
        Shape oldClip = g.getClip();
        int startPosCorrection = xStart % 4 == 3 ? 1 : 0;
        int dotX0 = (xStart / 4 + startPosCorrection) * 4;
        int width = ((xEnd - dotX0 - 1) / 4 + 1) * 4;
        Rectangle rectangle = new Rectangle(dotX0, y, width, 3);
        Rectangle rectangle2 = lineClip = oldClip != null ? oldClip.getBounds().intersection(rectangle) : rectangle;
        if (lineClip.isEmpty()) {
            return;
        }
        Composite oldComposite = g.getComposite();
        try {
            g.setComposite(AlphaComposite.SrcOver);
            g.setClip(lineClip);
            UIUtil.drawImage((Graphics)g, (Image)this.myImage, dotX0, y, null);
        }
        finally {
            g.setComposite(oldComposite);
            g.setClip(oldClip);
        }
    }

    public static AppleBoldDottedPainter forColor(Color color) {
        AppleBoldDottedPainter painter = myPainters.get(color);
        if (painter == null) {
            painter = new AppleBoldDottedPainter(color);
            myPainters.put(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()), painter);
        }
        return painter;
    }
}

