/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.TypeCorrector;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass>> MAP_IN_CLASS_KEY = Key.create("MAP_KEY");
    private static final String VALUES_METHOD = "values";
    private static final String VALUE_OF_METHOD = "valueOf";
    @NonNls
    private static final String ALL = "Intellij-IDEA-ALL";
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = new NullableFunction<ClassIconRequest, Icon>(){

        @Override
        public Icon fun(ClassIconRequest r) {
            if (!r.psiClass.isValid() || r.psiClass.getProject().isDisposed()) {
                return null;
            }
            boolean isLocked = BitUtil.isSet(r.flags, 2) && !r.psiClass.isWritable();
            Icon symbolIcon = r.symbolIcon != null ? r.symbolIcon : ElementPresentationUtil.getClassIconOfKind(r.psiClass, ElementPresentationUtil.getClassKind(r.psiClass));
            RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(symbolIcon, r.psiClass, isLocked);
            Icon result = ElementPresentationUtil.addVisibilityIcon(r.psiClass, r.flags, baseIcon);
            Iconable.LastComputedIcon.put(r.psiClass, result, r.flags);
            return result;
        }
    };

    private PsiClassImplUtil() {
    }

    @NotNull
    public static PsiField[] getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllFields"));
        }
        List<PsiField> map = PsiClassImplUtil.getAllByMap(aClass, MemberType.FIELD);
        PsiField[] psiFieldArray = map.toArray(new PsiField[map.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllMethods"));
        }
        List<PsiMethod> methods = PsiClassImplUtil.getAllByMap(aClass, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllInnerClasses"));
        }
        List<PsiClass> classes = PsiClassImplUtil.getAllByMap(aClass, MemberType.CLASS);
        PsiClass[] psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findFieldByName"));
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.FIELD);
        return byMap.isEmpty() ? null : (PsiField)byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsByName"));
        }
        List<PsiMember> methods = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodBySignature"));
        }
        List<PsiMethod> result = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        List<PsiMethod> methods = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        PsiMethod[] methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
            }
            return list;
        }
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor = checkBases && !aClass.equals(superClass) && superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor);
            if (!signature.equals(patternSignature)) continue;
            methods.add(method);
            if (stopOnFirst) break;
        }
        SmartList<PsiMethod> smartList = methods;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        return smartList;
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findInnerByName"));
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.CLASS);
        return byMap.isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass, String name, boolean checkBases, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        if (name == null) {
            List<PsiMember> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
            }
            return list;
        }
        if (checkBases) {
            PsiMember[] list = PsiClassImplUtil.getMap(aClass, type).get(name);
            if (list == null) {
                List<PsiMember> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
                }
                return list2;
            }
            List<PsiMember> list3 = Arrays.asList(list);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
            }
            return list3;
        }
        PsiMember[] members = null;
        switch (type) {
            case METHOD: {
                members = aClass.getMethods();
                break;
            }
            case CLASS: {
                members = aClass.getInnerClasses();
                break;
            }
            case FIELD: {
                members = aClass.getFields();
            }
        }
        ArrayList<PsiMember> list = new ArrayList<PsiMember>();
        for (PsiMember member : members) {
            if (!name.equals(member.getName())) continue;
            list.add(member);
        }
        ArrayList<PsiMember> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        return arrayList;
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        List<Pair<T, PsiSubstitutor>> list = PsiClassImplUtil.withSubstitutors(aClass, PsiClassImplUtil.getMap(aClass, type).get(ALL));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        return list;
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass, type);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            Pair<T, PsiSubstitutor> pair = pairs.get(i);
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, aClass);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        return arrayList;
    }

    private static Map<String, PsiMember[]> getMap(@NotNull PsiClass aClass, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiClassImplUtil", "getMap"));
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = PsiClassImplUtil.getValues(aClass);
        return (Map)value.getValue(aClass).get(aClass.getResolveScope()).get((Object)type);
    }

    @NotNull
    private static ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> getValues(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getValues"));
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = aClass.getUserData(MAP_IN_CLASS_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(aClass.getProject()).createParameterizedCachedValue(ByNameCachedValueProvider.INSTANCE, false);
            if (aClass.isPhysical()) {
                value = ((UserDataHolderEx)((Object)aClass)).putUserDataIfAbsent(MAP_IN_CLASS_KEY, value);
            }
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> parameterizedCachedValue = value;
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getValues"));
        }
        return parameterizedCachedValue;
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getClassIcon"));
        }
        return PsiClassImplUtil.getClassIcon(flags, aClass, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass, @Nullable Icon symbolIcon) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getClassIcon"));
        }
        Icon base = Iconable.LastComputedIcon.get(aClass, flags);
        if (base == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
            }
            RowIcon baseIcon = ElementBase.createLayeredIcon(aClass, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon(aClass, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base, new ClassIconRequest(aClass, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass) {
        PsiDirectory dir;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            LocalSearchScope localSearchScope = new LocalSearchScope(aClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return localSearchScope;
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass);
        PsiFile file = aClass.getContainingFile();
        if (PsiImplUtil.isInServerPage(file)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return globalSearchScope;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected")) {
            SearchScope searchScope = containingClass == null ? maximalUseScope : containingClass.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return searchScope;
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass);
            LocalSearchScope localSearchScope = new LocalSearchScope(topClass == null ? aClass.getContainingFile() : topClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return localSearchScope;
        }
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass.getProject()).findPackage(((PsiJavaFile)file).getPackageName());
        }
        if (aPackage == null && (dir = file.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            SearchScope scope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = scope = ((SearchScope)scope).intersectWith(maximalUseScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return searchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(file);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
        }
        return localSearchScope;
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiClassImplUtil", "isMainOrPremainMethod"));
        }
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        String name = method.getName();
        if (!("main".equals(name) || "premain".equals(name) || "agentmain".equals(name))) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main = PsiClassImplUtil.createSignatureFromText(factory, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, main)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, premain)) {
                return true;
            }
            MethodSignature agentmain = PsiClassImplUtil.createSignatureFromText(factory, "void agentmain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, agentmain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory, @NotNull String text) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        MethodSignature methodSignature = factory.createMethodFromText(text, null).getSignature(PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        return methodSignature;
    }

    public static boolean processDeclarationsInEnum(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull ClassInnerStuffCache innerStuffCache) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        if (innerStuffCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerStuffCache", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod method;
            NameHint nameHint = processor.getHint(NameHint.KEY);
            if ((nameHint == null || VALUES_METHOD.equals(nameHint.getName(state))) && (method = innerStuffCache.getValuesMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
            if ((nameHint == null || VALUE_OF_METHOD.equals(nameHint.getName(state))) && (method = innerStuffCache.getValueOfMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        return PsiClassImplUtil.processDeclarationsInClass(aClass, processor, state, visited, last, place, languageLevel, isRaw, place.getResolveScope());
    }

    private static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw, @NotNull GlobalSearchScope resolveScope) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList && aClass.getModifierList() == last) {
            return true;
        }
        if (visited != null && visited.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor = state.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass, substitutor);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (nameHint != null) {
            String name = nameHint.getName(state);
            return PsiClassImplUtil.processCachedMembersByName(aClass, processor, state, visited, last, place, isRaw, substitutor, PsiClassImplUtil.getValues(aClass).getValue(aClass).get(resolveScope), name, languageLevel);
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass, processor, state, visited, last, place, isRaw, languageLevel, resolveScope);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean processCachedMembersByName(final @NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, final @NotNull PsiElement place, final boolean isRaw, final @NotNull PsiSubstitutor substitutor, @NotNull MembersMap value, String name, final @NotNull LanguageLevel languageLevel) {
        PsiClass containingClass;
        boolean resolved;
        PsiMember[] list;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        Function<PsiMember, PsiSubstitutor> finalSubstitutor = new Function<PsiMember, PsiSubstitutor>(){
            final ScopedClassHierarchy hierarchy;
            final PsiElementFactory factory;
            {
                this.hierarchy = ScopedClassHierarchy.getHierarchy(aClass, place.getResolveScope());
                this.factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
            }

            @Override
            public PsiSubstitutor fun(PsiMember member) {
                PsiClass containingClass;
                PsiSubstitutor superSubstitutor = this.hierarchy.getSuperMembersSubstitutor(containingClass = ObjectUtils.assertNotNull(member.getContainingClass()), languageLevel);
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, superSubstitutor == null ? PsiSubstitutor.EMPTY : superSubstitutor, aClass, substitutor, this.factory, languageLevel);
                return member instanceof PsiMethod ? PsiClassImplUtil.checkRaw(isRaw, this.factory, (PsiMethod)member, finalSubstitutor) : finalSubstitutor;
            }
        };
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass.findFieldByName(name, false);
            if (fieldByName != null) {
                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                if (!processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                Map allFieldsMap = (Map)value.get((Object)MemberType.FIELD);
                list = (PsiMember[])allFieldsMap.get(name);
                if (list != null) {
                    resolved = false;
                    for (PsiMember candidateField : list) {
                        containingClass = candidateField.getContainingClass();
                        if (containingClass == null) {
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass());
                            continue;
                        }
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (processor.execute(candidateField, state.put(PsiSubstitutor.KEY, finalSubstitutor.fun(candidateField)))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last != null && last.getContext() == aClass) {
                if (last instanceof PsiClass && !processor.execute(last, state)) {
                    return false;
                }
                PsiTypeParameterList list2 = aClass.getTypeParameterList();
                if (list2 != null && !list2.processDeclarations(processor, state, last, place)) {
                    return false;
                }
            }
            if (!(last instanceof PsiReferenceList)) {
                PsiClass classByName = aClass.findInnerClassByName(name, false);
                if (classByName != null) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                    if (!processor.execute(classByName, state)) {
                        return false;
                    }
                } else {
                    Map allClassesMap = (Map)value.get((Object)MemberType.CLASS);
                    list = (PsiMember[])allClassesMap.get(name);
                    if (list != null) {
                        resolved = false;
                        for (PsiMember inner : list) {
                            containingClass = inner.getContainingClass();
                            if (containingClass == null) continue;
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state.put(PsiSubstitutor.KEY, finalSubstitutor.fun(inner)))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors = aClass.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                for (PsiMember psiMember : constructors) {
                    if (methodResolverProcessor.execute(psiMember, state)) continue;
                    return false;
                }
                return true;
            }
            Map allMethodsMap = (Map)value.get((Object)MemberType.METHOD);
            PsiMember[] list3 = (PsiMember[])allMethodsMap.get(name);
            if (list3 != null) {
                void var18_26;
                boolean resolved2 = false;
                PsiMember[] psiMemberArray = list3;
                int n = psiMemberArray.length;
                boolean bl = false;
                while (var18_26 < n) {
                    PsiMember candidate = psiMemberArray[var18_26];
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate;
                    if (!(processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor() || (containingClass = candidateMethod.getContainingClass()) == null || visited != null && visited.contains(containingClass))) {
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (!processor.execute(candidateMethod, state.put(PsiSubstitutor.KEY, finalSubstitutor.fun(candidateMethod)))) {
                            resolved2 = true;
                        }
                    }
                    ++var18_26;
                }
                if (resolved2) {
                    return false;
                }
                if (visited != null) {
                    void var18_28;
                    psiMemberArray = list3;
                    n = psiMemberArray.length;
                    boolean bl2 = false;
                    while (var18_28 < n) {
                        PsiMember aList = psiMemberArray[var18_28];
                        visited.add(aList.getContainingClass());
                        ++var18_28;
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor) {
        PsiClass containingClass;
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (candidateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateMethod", "com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (isRaw && !candidateMethod.hasModifierProperty("static") && (containingClass = candidateMethod.getContainingClass()) != null && containingClass.hasTypeParameters()) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor = factory.createRawSubstitutor(substitutor, methodTypeParameters);
        }
        return substitutor;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (candidateSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSubstitutor", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (PsiUtil.isRawSubstitutor(aClass, substitutor)) {
            return elementFactory.createRawSubstitutor(candidateClass).putAll(substitutor);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type = substitutor.substitute(containingType);
        if (!(type instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(@NotNull PsiClass aClass, final @NotNull PsiScopeProcessor processor, final @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope resolveScope) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiClass)aClass)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
                if (fieldByName != null && !processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getFields()) {
                    if (processor.execute(field, state)) continue;
                    return false;
                }
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod[] methods;
            PsiSubstitutor baseSubstitutor = state.get(PsiSubstitutor.KEY);
            for (PsiMethod method : methods = nameHint != null ? aClass.findMethodsByName(nameHint.getName(state), false) : aClass.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.checkRaw(isRaw, factory, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor == baseSubstitutor ? state : state.put(PsiSubstitutor.KEY, finalSubstitutor);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list;
            if (last != null && last.getContext() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList) && !(last instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass.findInnerClassByName(nameHint.getName(state), false);
                    if (inner != null && !processor.execute(inner, state)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners;
                    for (PsiClass inner : inners = aClass.getInnerClasses()) {
                        if (processor.execute(inner, state)) continue;
                        return false;
                    }
                }
            }
        }
        if (last instanceof PsiReferenceList) {
            return true;
        }
        THashSet visited1 = visited;
        return PsiClassImplUtil.processSuperTypes(aClass, state.get(PsiSubstitutor.KEY), factory, languageLevel, resolveScope, new PairProcessor<PsiClass, PsiSubstitutor>((Set)visited1, last, place, languageLevel, isRaw, resolveScope){
            final /* synthetic */ Set val$visited1;
            final /* synthetic */ PsiElement val$last;
            final /* synthetic */ PsiElement val$place;
            final /* synthetic */ LanguageLevel val$languageLevel;
            final /* synthetic */ boolean val$isRaw;
            final /* synthetic */ GlobalSearchScope val$resolveScope;
            {
                this.val$visited1 = set;
                this.val$last = psiElement;
                this.val$place = psiElement2;
                this.val$languageLevel = languageLevel;
                this.val$isRaw = bl;
                this.val$resolveScope = globalSearchScope;
            }

            @Override
            public boolean process(PsiClass superClass, PsiSubstitutor finalSubstitutor) {
                return PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state.put(PsiSubstitutor.KEY, finalSubstitutor), this.val$visited1, this.val$last, this.val$place, this.val$languageLevel, this.val$isRaw, this.val$resolveScope);
            }
        });
    }

    @Nullable
    public static <T extends PsiType> T correctType(@Nullable T originalType, @NotNull GlobalSearchScope resolveScope) {
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/PsiClassImplUtil", "correctType"));
        }
        if (originalType == null || !Registry.is("java.correct.class.type.by.place.resolve.scope")) {
            return originalType;
        }
        return new TypeCorrector(resolveScope).correctType(originalType);
    }

    public static List<PsiClassType.ClassResolveResult> getScopeCorrectedSuperTypes(PsiClass aClass, GlobalSearchScope resolveScope) {
        return ScopedClassHierarchy.getHierarchy(aClass, resolveScope).getImmediateSupersWithCapturing();
    }

    static boolean processSuperTypes(@NotNull PsiClass aClass, PsiSubstitutor substitutor, @NotNull PsiElementFactory factory, @NotNull LanguageLevel languageLevel, GlobalSearchScope resolveScope, PairProcessor<PsiClass, PsiSubstitutor> processor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        boolean resolved = false;
        for (PsiClassType.ClassResolveResult superTypeResolveResult : PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass, resolveScope)) {
            PsiClass superClass = superTypeResolveResult.getElement();
            assert (superClass != null);
            PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, substitutor, factory, languageLevel);
            if (processor.process(superClass, finalSubstitutor)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperClass"));
        }
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        if (psiClass.isEnum()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        PsiClass psiResolved = referenceElements[0].resolve();
        return psiResolved == null ? PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object") : psiResolved;
    }

    @Nullable
    private static PsiClass findSpecialSuperClass(@NotNull PsiClass psiClass, String className) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "findSpecialSuperClass"));
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(className, psiClass.getResolveScope());
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSupers"));
        }
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupers"));
        }
        return supers;
    }

    @NotNull
    private static PsiClass[] getSupersInner(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
        }
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, true);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    if (psiClassArray2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                    }
                    return psiClassArray2;
                }
                PsiClass[] psiClassArray5 = new PsiClass[]{baseClass};
                if (psiClassArray5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                }
                return psiClassArray5;
            }
            PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            if (objectClass != null) {
                PsiClass[] psiClassArray6 = new PsiClass[1];
                psiClassArray = psiClassArray6;
                psiClassArray6[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                if (objectClass != null) {
                    PsiClass[] psiClassArray7 = new PsiClass[1];
                    psiClassArray = psiClassArray7;
                    psiClassArray7[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                }
                return psiClassArray;
            }
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, false);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            if (interfaces == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
        }
        return types;
    }

    @NotNull
    public static PsiClassType[] getSuperTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{baseClassType};
                if (psiClassTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
                }
                return psiClassTypeArray;
            }
            PsiClassType objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{objectType, baseClassType};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                if (PsiClassType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
                }
                return PsiClassType.EMPTY_ARRAY;
            }
            PsiManager manager = psiClass.getManager();
            result[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result, extendsListLength, implementsTypes.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
        }
        return result;
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        return psiClassType;
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        PsiClassType superType;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getEnumSuperType"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/PsiClassImplUtil", "getEnumSuperType"));
        }
        PsiClass enumClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        if (enumClass == null) {
            try {
                superType = (PsiClassType)factory.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], factory.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor);
        }
        return superType;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        PsiClassType[] referencedTypes = typeParameter.getExtendsListTypes();
        if (referencedTypes.length == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result.add(psiClass);
        }
        PsiClass[] psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(psiClass.getExtendsListTypes(), psiClass, false);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    private static PsiClass[] resolveClassReferenceList(@NotNull PsiClassType[] listOfTypes, @NotNull PsiClass psiClass, boolean includeObject) {
        if (listOfTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOfTypes", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        PsiClass objectClass = null;
        if (includeObject && (objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object")) == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                PsiClass[] psiClassArray = new PsiClass[]{objectClass};
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        if (resolved == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        return resolved;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, String name, boolean checkBases) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(Pair.create(method, PsiSubstitutor.EMPTY));
            }
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = ret;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
            }
            return arrayList;
        }
        PsiMember[] list = PsiClassImplUtil.getMap(psiClass, MemberType.METHOD).get(name);
        if (list == null) {
            List<Pair<PsiMethod, PsiSubstitutor>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
            }
            return list2;
        }
        List<Pair<PsiMethod, PsiSubstitutor>> list3 = PsiClassImplUtil.withSubstitutors(psiClass, list);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list3;
    }

    @NotNull
    private static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> withSubstitutors(@NotNull PsiClass psiClass, PsiMember[] members) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "withSubstitutors"));
        }
        final ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(psiClass, psiClass.getResolveScope());
        final LanguageLevel level = PsiUtil.getLanguageLevel(psiClass);
        List<Pair<T, PsiSubstitutor>> list = ContainerUtil.map(members, new Function<PsiMember, Pair<T, PsiSubstitutor>>(){

            @Override
            public Pair<T, PsiSubstitutor> fun(PsiMember member) {
                PsiClass containingClass = member.getContainingClass();
                PsiSubstitutor substitutor = containingClass == null ? null : hierarchy.getSuperMembersSubstitutor(containingClass, level);
                return Pair.create(member, substitutor == null ? PsiSubstitutor.EMPTY : substitutor);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "withSubstitutors"));
        }
        return list;
    }

    @NotNull
    public static PsiClassType[] getExtendsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
        }
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory());
            if (enumSuperType == null) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
                psiClassTypeArray = psiClassTypeArray2;
                psiClassTypeArray2[0] = enumSuperType;
            }
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (psiClass.isAnnotationType()) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiType upperBound = InferenceSession.getUpperBound(psiClass);
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = LambdaUtil.getFunctionalTypeMap().get(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts = ((PsiIntersectionType)upperBound).getConjuncts();
            ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
            for (PsiType conjunct : conjuncts) {
                if (!(conjunct instanceof PsiClassType)) continue;
                result.add((PsiClassType)conjunct);
            }
            PsiClassType[] psiClassTypeArray = result.toArray(new PsiClassType[result.size()]);
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (upperBound instanceof PsiClassType) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{(PsiClassType)upperBound};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiClassType[] getImplementsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
        }
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    static boolean isInExtendsList(@NotNull PsiClass psiClass, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil", "isInExtendsList"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/PsiClassImplUtil", "isInExtendsList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/PsiClassImplUtil", "isInExtendsList"));
        }
        if (psiClass.isEnum()) {
            return "java.lang.Enum".equals(baseClass.getQualifiedName());
        }
        if (psiClass.isAnnotationType()) {
            return "java.lang.annotation.Annotation".equals(baseClass.getQualifiedName());
        }
        PsiType upperBound = InferenceSession.getUpperBound(psiClass);
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = LambdaUtil.getFunctionalTypeMap().get(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)upperBound).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !((PsiClassType)conjunct).getClassName().equals(baseName) || !baseClass.equals(((PsiClassType)conjunct).resolve())) continue;
                return true;
            }
            return false;
        }
        if (upperBound instanceof PsiClassType) {
            return ((PsiClassType)upperBound).getClassName().equals(baseName) && baseClass.equals(((PsiClassType)upperBound).resolve());
        }
        return PsiClassImplUtil.isInReferenceList(psiClass.getExtendsList(), baseClass, baseName, manager);
    }

    static boolean isInReferenceList(@Nullable PsiReferenceList list, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/PsiClassImplUtil", "isInReferenceList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/PsiClassImplUtil", "isInReferenceList"));
        }
        if (list == null) {
            return false;
        }
        if (list instanceof StubBasedPsiElement) {
            Object stub = ((StubBasedPsiElement)((Object)list)).getStub();
            if (stub instanceof PsiClassReferenceListStub && baseName != null) {
                PsiClassReferenceListStub classStub = (PsiClassReferenceListStub)stub;
                String[] names = classStub.getReferencedNames();
                for (int i = 0; i < names.length; ++i) {
                    PsiClassType[] referencedTypes;
                    PsiClass resolved;
                    String name = names[i];
                    int typeParam = name.indexOf(60);
                    if (typeParam != -1) {
                        name = name.substring(0, typeParam);
                    }
                    if (!name.endsWith(baseName) || !manager.areElementsEquivalent(baseClass, resolved = (referencedTypes = classStub.getReferencedTypes())[i].resolve())) continue;
                    return true;
                }
                return false;
            }
            if (stub != null) {
                for (PsiClassType type : list.getReferencedTypes()) {
                    if (!Comparing.equal(type.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type.resolve())) continue;
                    return true;
                }
                return false;
            }
        }
        if (list.getLanguage() == JavaLanguage.INSTANCE) {
            for (PsiJavaCodeReferenceElement referenceElement : list.getReferenceElements()) {
                if (!Comparing.strEqual(baseName, referenceElement.getReferenceName()) || !manager.areElementsEquivalent(baseClass, referenceElement.resolve())) continue;
                return true;
            }
            return false;
        }
        for (PsiClassType type : list.getReferencedTypes()) {
            if (!Comparing.equal(type.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type.resolve())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass, PsiElement another) {
        PsiFile original2;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "isClassEquivalentTo"));
        }
        if (aClass == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && (aClass.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner()) || TypeConversionUtil.areSameFreshVariables(p1, p2));
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (aClass.getOriginalElement().equals(another.getOriginalElement())) {
            return true;
        }
        PsiFile file1 = aClass.getContainingFile().getOriginalFile();
        PsiFile file2 = another.getContainingFile().getOriginalFile();
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return PsiClassImplUtil.compareClassSeqNumber(aClass, (PsiClass)another);
        }
        FileIndexFacade fileIndex = ServiceManager.getService(file1.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex.isInSource(vfile2) && !lib2);
    }

    private static boolean compareClassSeqNumber(@NotNull PsiClass aClass, @NotNull PsiClass another) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "compareClassSeqNumber"));
        }
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/psi/impl/PsiClassImplUtil", "compareClassSeqNumber"));
        }
        int index1 = PsiClassImplUtil.getSeqNumber(aClass);
        if (index1 == -1) {
            return true;
        }
        int index2 = PsiClassImplUtil.getSeqNumber(another);
        return index1 == index2;
    }

    private static int getSeqNumber(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiClassImplUtil", "getSeqNumber"));
        }
        PsiElement parent = aClass.getParent();
        if (parent == null) {
            return -1;
        }
        int seqNo = 0;
        for (PsiElement child : parent.getChildren()) {
            if (child == aClass) {
                return seqNo;
            }
            if (!(child instanceof PsiClass) || !Comparing.strEqual(aClass.getName(), ((PsiClass)child).getName())) continue;
            ++seqNo;
        }
        return -1;
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field, PsiElement another) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/impl/PsiClassImplUtil", "isFieldEquivalentTo"));
        }
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/impl/PsiClassImplUtil", "isMethodEquivalentTo"));
        }
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet<String>())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<String> visited) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited.add(type1.getCanonicalText());
        visited.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Comparing.equal(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i = 0; i < eTypes1.length; ++i) {
                PsiClassType eType1 = eTypes1[i];
                PsiClassType eType2 = eTypes2[i];
                if (visited.contains(eType1.getCanonicalText()) || visited.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, eType1, eType2, visited)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static class ByNameCachedValueProvider
    implements ParameterizedCachedValueProvider<Map<GlobalSearchScope, MembersMap>, PsiClass> {
        private static final ByNameCachedValueProvider INSTANCE = new ByNameCachedValueProvider();

        private ByNameCachedValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<GlobalSearchScope, MembersMap>> compute(final @NotNull PsiClass myClass) {
            if (myClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClass", "com/intellij/psi/impl/PsiClassImplUtil$ByNameCachedValueProvider", "compute"));
            }
            ConcurrentFactoryMap<GlobalSearchScope, MembersMap> map = new ConcurrentFactoryMap<GlobalSearchScope, MembersMap>(){

                @Override
                @Nullable
                protected MembersMap create(GlobalSearchScope resolveScope) {
                    return new MembersMap(myClass, resolveScope);
                }
            };
            return CachedValueProvider.Result.create(map, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }

    private static class MembersMap
    extends ConcurrentFactoryMap<MemberType, Map<String, PsiMember[]>> {
        private final PsiClass myPsiClass;
        private final GlobalSearchScope myResolveScope;

        MembersMap(PsiClass psiClass, GlobalSearchScope scope) {
            this.myPsiClass = psiClass;
            this.myResolveScope = scope;
        }

        @Override
        @Nullable
        protected Map<String, PsiMember[]> create(final MemberType key) {
            final THashMap map = ContainerUtil.newTroveMap();
            final ArrayList allMembers = ContainerUtil.newArrayList();
            map.put(PsiClassImplUtil.ALL, allMembers);
            ElementClassFilter filter = key == MemberType.CLASS ? ElementClassFilter.CLASS : (key == MemberType.METHOD ? ElementClassFilter.METHOD : ElementClassFilter.FIELD);
            final ElementClassHint classHint = new ElementClassHint(){

                @Override
                public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                    return key == MemberType.CLASS && kind == ElementClassHint.DeclarationKind.CLASS || key == MemberType.FIELD && (kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST) || key == MemberType.METHOD && kind == ElementClassHint.DeclarationKind.METHOD;
                }
            };
            FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)filter){

                @Override
                protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiClassImplUtil$MembersMap$2", "add"));
                    }
                    if (substitutor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiClassImplUtil$MembersMap$2", "add"));
                    }
                    if (key == MemberType.CLASS && element instanceof PsiClass || key == MemberType.METHOD && element instanceof PsiMethod || key == MemberType.FIELD && element instanceof PsiField) {
                        allMembers.add((PsiMember)element);
                        String currentName = ((PsiMember)element).getName();
                        List listByName = (List)map.get(currentName);
                        if (listByName == null) {
                            listByName = ContainerUtil.newSmartList();
                            map.put(currentName, listByName);
                        }
                        listByName.add((PsiMember)element);
                    }
                }

                @Override
                public <K> K getHint(@NotNull Key<K> hintKey) {
                    if (hintKey == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/PsiClassImplUtil$MembersMap$2", "getHint"));
                    }
                    return (K)(ElementClassHint.KEY == hintKey ? classHint : super.getHint(hintKey));
                }
            };
            PsiClassImplUtil.processDeclarationsInClassNotCached(this.myPsiClass, processor, ResolveState.initial(), null, null, this.myPsiClass, false, PsiUtil.getLanguageLevel(this.myPsiClass), this.myResolveScope);
            THashMap<String, PsiMember[]> result = ContainerUtil.newTroveMap();
            for (String name : map.keySet()) {
                result.put(name, ((List)map.get(name)).toArray(PsiMember.EMPTY_ARRAY));
            }
            return result;
        }
    }

    private static class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil$ClassIconRequest", "<init>"));
            }
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result = this.psiClass.hashCode();
            result = 31 * result + this.flags;
            return result;
        }
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

