/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = new NullableFunction<FileIconKey, Icon>(){

        @Override
        public Icon fun(FileIconKey key) {
            VirtualFile file = key.getFile();
            int flags = key.getFlags();
            Project project = key.getProject();
            if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
                return null;
            }
            Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
            Icon icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file) : providersIcon;
            boolean dumb = project != null && DumbService.getInstance(project).isDumb();
            for (FileIconPatcher patcher : IconUtil.getPatchers()) {
                if (dumb && !DumbService.isDumbAware(patcher)) continue;
                icon = patcher.patchIcon(icon, file, flags & 0xFFFFFFFD, project);
            }
            if (file.is(VFileProperty.SYMLINK)) {
                icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
            }
            if (!(!BitUtil.isSet(flags, 2) || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
                icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
            }
            Iconable.LastComputedIcon.put(file, icon, flags);
            return icon;
        }
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/IconUtil", "wasEverInitialized"));
        }
        Boolean was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, int maxWidth, int maxHeight) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/IconUtil", "cropIcon"));
        }
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "cropIcon"));
            }
            return icon2;
        }
        int w = Math.min(icon.getIconWidth(), maxWidth);
        int h = Math.min(icon.getIconHeight(), maxHeight);
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(new JPanel(), g, 0, 0);
        g.dispose();
        BufferedImage img = UIUtil.createImage(g, w, h, 3);
        int offX = icon.getIconWidth() > maxWidth ? (icon.getIconWidth() - maxWidth) / 2 : 0;
        int offY = icon.getIconHeight() > maxHeight ? (icon.getIconHeight() - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, image.getRGB(col + offX, row + offY));
            }
        }
        ImageIcon imageIcon = new ImageIcon(img);
        if (imageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "cropIcon"));
        }
        return imageIcon;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, @NotNull Rectangle area) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/IconUtil", "cropIcon"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/util/IconUtil", "cropIcon"));
        }
        if (!new Rectangle(icon.getIconWidth(), icon.getIconHeight()).contains(area)) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "cropIcon"));
            }
            return icon2;
        }
        CropIcon cropIcon = new CropIcon(icon, area);
        if (cropIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "cropIcon"));
        }
        return cropIcon;
    }

    @NotNull
    public static Icon flip(final @NotNull Icon icon, final boolean horizontal) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/IconUtil", "flip"));
        }
        Icon icon2 = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    AffineTransform transform = AffineTransform.getTranslateInstance(horizontal ? (double)(x + this.getIconWidth()) : (double)x, horizontal ? (double)y : (double)(y + this.getIconHeight()));
                    transform.concatenate(AffineTransform.getScaleInstance(horizontal ? -1.0 : 1.0, horizontal ? 1.0 : -1.0));
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    icon.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        };
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "flip"));
        }
        return icon2;
    }

    public static Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/IconUtil", "getIcon"));
        }
        Icon lastIcon = Iconable.LastComputedIcon.get(file, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIconImpl(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), ICON_NULLABLE_FUNCTION);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/IconUtil", "getProvidersIcon"));
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getEmptyIcon"));
        }
        return rowIcon;
    }

    @NotNull
    private static Icon createEmptyIconLike(@NotNull String baseIconPath) {
        if (baseIconPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseIconPath", "com/intellij/util/IconUtil", "createEmptyIconLike"));
        }
        Icon baseIcon = IconLoader.findIcon(baseIconPath);
        if (baseIcon == null) {
            Icon icon = EmptyIcon.ICON_16;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "createEmptyIconLike"));
            }
            return icon;
        }
        EmptyIcon emptyIcon = EmptyIcon.create(baseIcon);
        if (emptyIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "createEmptyIconLike"));
        }
        return emptyIcon;
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/IconUtil", "toImage"));
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("add.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("remove.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getRemoveIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getMoveUpIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("moveUp.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getMoveUpIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getMoveDownIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("moveDown.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getMoveDownIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("edit.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getEditIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddClassIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addClass.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddClassIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddPatternIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addPattern.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddPatternIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddJiraPatternIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addJira.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddJiraPatternIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddYouTrackPatternIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addYouTrack.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddYouTrackPatternIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddBlankLineIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addBlankLine.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddBlankLineIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddPackageIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addPackage.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddPackageIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddLinkIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addLink.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddLinkIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAddFolderIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("addFolder.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAddFolderIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("analyze.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getAnalyzeIcon"));
        }
        return icon;
    }

    public static void paintInCenterOf(@NotNull Component c, @NotNull Graphics g, @NotNull Icon icon) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/IconUtil", "paintInCenterOf"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/util/IconUtil", "paintInCenterOf"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/IconUtil", "paintInCenterOf"));
        }
        int x = (c.getWidth() - icon.getIconWidth()) / 2;
        int y = (c.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/IconUtil", "getToolbarDecoratorIcon"));
        }
        Icon icon = IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getToolbarDecoratorIcon"));
        }
        return icon;
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        String string = "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getToolbarDecoratorIconsFolder"));
        }
        return string;
    }

    @NotNull
    public static Icon[] getEqualSizedIcons(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "com/intellij/util/IconUtil", "getEqualSizedIcons"));
        }
        Icon[] result = new Icon[icons.length];
        int width = 0;
        int height = 0;
        for (Icon icon : icons) {
            width = Math.max(width, icon.getIconWidth());
            height = Math.max(height, icon.getIconHeight());
        }
        for (int i = 0; i < icons.length; ++i) {
            result[i] = new IconSizeWrapper(icons[i], width, height);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "getEqualSizedIcons"));
        }
        return result;
    }

    @NotNull
    public static Icon toSize(@Nullable Icon icon, int width, int height) {
        IconSizeWrapper iconSizeWrapper = new IconSizeWrapper(icon, width, height);
        if (iconSizeWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "toSize"));
        }
        return iconSizeWrapper;
    }

    @NotNull
    public static Icon scale(final @NotNull Icon source, double _scale) {
        Image image;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "scale"));
        }
        final int hiDPIscale = source instanceof ImageIcon ? (RetinaImage.isAppleHiDPIScaledImage(image = ((ImageIcon)source).getImage()) || image instanceof JBHiDPIScaledImage ? 2 : 1) : 1;
        final double scale = Math.min(32.0, Math.max(0.1, _scale));
        Icon icon = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.translate(x, y);
                    AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    source.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale) / hiDPIscale;
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale) / hiDPIscale;
            }
        };
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "scale"));
        }
        return icon;
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon, float scale, boolean smartScale) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/IconUtil", "scale"));
        }
        if (smartScale && icon instanceof ScalableIcon) {
            Icon icon2 = ((ScalableIcon)icon).scale(scale);
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "scale"));
            }
            return icon2;
        }
        Icon icon3 = IconUtil.scale(icon, scale);
        if (icon3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "scale"));
        }
        return icon3;
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "colorize"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/IconUtil", "colorize"));
        }
        Icon icon = IconUtil.colorize(source, color, false);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "colorize"));
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "colorize"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/IconUtil", "colorize"));
        }
        Icon icon = IconUtil.colorize(g, source, color, false);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "colorize"));
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "colorize"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/IconUtil", "colorize"));
        }
        Icon icon = IconUtil.filterIcon(null, source, new ColorFilter(color, keepGray));
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "colorize"));
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "colorize"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/IconUtil", "colorize"));
        }
        Icon icon = IconUtil.filterIcon(g, source, new ColorFilter(color, keepGray));
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "colorize"));
        }
        return icon;
    }

    @NotNull
    public static Icon desaturate(@NotNull Icon source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "desaturate"));
        }
        Icon icon = IconUtil.filterIcon(null, source, new DesaturationFilter());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "desaturate"));
        }
        return icon;
    }

    @NotNull
    private static Icon filterIcon(Graphics2D g, @NotNull Icon source, @NotNull Filter filter) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IconUtil", "filterIcon"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/IconUtil", "filterIcon"));
        }
        BufferedImage src = g != null ? UIUtil.createImage(g, source.getIconWidth(), source.getIconHeight(), 3) : UIUtil.createImage(source.getIconWidth(), source.getIconHeight(), 3);
        Graphics2D g2d = src.createGraphics();
        source.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        BufferedImage img = g != null ? UIUtil.createImage(g, source.getIconWidth(), source.getIconHeight(), 3) : UIUtil.createImage(source.getIconWidth(), source.getIconHeight(), 3);
        int[] rgba = new int[4];
        for (int y = 0; y < src.getRaster().getHeight(); ++y) {
            for (int x = 0; x < src.getRaster().getWidth(); ++x) {
                src.getRaster().getPixel(x, y, rgba);
                if (rgba[3] == 0) continue;
                img.getRaster().setPixel(x, y, filter.convert(rgba));
            }
        }
        JBImageIcon jBImageIcon = IconUtil.createImageIcon(img);
        if (jBImageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "filterIcon"));
        }
        return jBImageIcon;
    }

    @NotNull
    public static JBImageIcon createImageIcon(@NotNull BufferedImage img) {
        if (img == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "img", "com/intellij/util/IconUtil", "createImageIcon"));
        }
        JBImageIcon jBImageIcon = new JBImageIcon(img){

            @Override
            public int getIconWidth() {
                return this.getImage() instanceof JBHiDPIScaledImage ? super.getIconWidth() / 2 : super.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.getImage() instanceof JBHiDPIScaledImage ? super.getIconHeight() / 2 : super.getIconHeight();
            }
        };
        if (jBImageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "createImageIcon"));
        }
        return jBImageIcon;
    }

    @NotNull
    public static Icon textToIcon(final @NotNull String text, @NotNull Component component, float fontSize) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/IconUtil", "textToIcon"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/IconUtil", "textToIcon"));
        }
        final JBFont font = JBFont.create(JBUI.Fonts.label().deriveFont(fontSize));
        FontMetrics metrics = component.getFontMetrics(font);
        final int width = metrics.stringWidth(text) + JBUI.scale(4);
        final int height = metrics.getHeight();
        Icon icon = new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                try {
                    GraphicsUtil.setupAntialiasing(g);
                    g.setFont(font);
                    UIUtil.drawStringWithHighlighting(g, text, x + JBUI.scale(2), y + height - JBUI.scale(1), JBColor.foreground(), JBColor.background());
                }
                finally {
                    g.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }
        };
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "textToIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon addText(@NotNull Icon base, @NotNull String text) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/util/IconUtil", "addText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/IconUtil", "addText"));
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(IconUtil.textToIcon(text, new JLabel(), JBUI.scale(6.0f)), 1, 4);
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil", "addText"));
        }
        return layeredIcon;
    }

    private static class DesaturationFilter
    extends Filter {
        private DesaturationFilter() {
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            if (rgba == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rgba", "com/intellij/util/IconUtil$DesaturationFilter", "convert"));
            }
            int min = Math.min(Math.min(rgba[0], rgba[1]), rgba[2]);
            int max = Math.max(Math.max(rgba[0], rgba[1]), rgba[2]);
            int grey = (max + min) / 2;
            int[] nArray = new int[]{grey, grey, grey, rgba[3]};
            if (nArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil$DesaturationFilter", "convert"));
            }
            return nArray;
        }
    }

    private static class ColorFilter
    extends Filter {
        private final float[] myBase;
        private final boolean myKeepGray;

        private ColorFilter(@NotNull Color color, boolean keepGray) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/IconUtil$ColorFilter", "<init>"));
            }
            this.myKeepGray = keepGray;
            this.myBase = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        }

        @Override
        @NotNull
        int[] convert(@NotNull int[] rgba) {
            if (rgba == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rgba", "com/intellij/util/IconUtil$ColorFilter", "convert"));
            }
            float[] hsb = new float[3];
            Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], hsb);
            int rgb = Color.HSBtoRGB(this.myBase[0], this.myBase[1] * (this.myKeepGray ? hsb[1] : 1.0f), this.myBase[2] * hsb[2]);
            int[] nArray = new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgba[3]};
            if (nArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/IconUtil$ColorFilter", "convert"));
            }
            return nArray;
        }
    }

    private static abstract class Filter {
        private Filter() {
        }

        @NotNull
        abstract int[] convert(@NotNull int[] var1);
    }

    private static class CropIcon
    implements Icon {
        private final Icon mySrc;
        private final Rectangle myCrop;

        private CropIcon(@NotNull Icon src, @NotNull Rectangle crop) {
            if (src == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/IconUtil$CropIcon", "<init>"));
            }
            if (crop == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "crop", "com/intellij/util/IconUtil$CropIcon", "<init>"));
            }
            this.mySrc = src;
            this.myCrop = crop;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.mySrc.paintIcon(c, g, x - this.myCrop.x, y - this.myCrop.y);
        }

        @Override
        public int getIconWidth() {
            return this.myCrop.width;
        }

        @Override
        public int getIconHeight() {
            return this.myCrop.height;
        }
    }

    public static class IconSizeWrapper
    implements Icon {
        private final Icon myIcon;
        private final int myWidth;
        private final int myHeight;

        protected IconSizeWrapper(@Nullable Icon icon, int width, int height) {
            this.myIcon = icon;
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIcon(this.myIcon, c, g, x, y);
        }

        protected void paintIcon(@Nullable Icon icon, Component c, Graphics g, int x, int y) {
            if (icon == null) {
                return;
            }
            icon.paintIcon(c, g, x += (this.myWidth - icon.getIconWidth()) / 2, y += (this.myHeight - icon.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);

        private FileIconProviderHolder() {
        }
    }
}

