/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;

public class ColorIcon
extends EmptyIcon {
    private final Color myColor;
    private boolean myBorder;
    private int myColorSize;

    public ColorIcon(int size, int colorSize, @NotNull Color color, boolean border) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/ui/ColorIcon", "<init>"));
        }
        super(size, size);
        this.myColor = color;
        this.myColorSize = colorSize;
        this.myBorder = border;
    }

    public ColorIcon(int size, @NotNull Color color, boolean border) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/ui/ColorIcon", "<init>"));
        }
        this(size, size, color, border);
    }

    public ColorIcon(int size, @NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/ui/ColorIcon", "<init>"));
        }
        this(size, color, false);
    }

    protected ColorIcon(ColorIcon icon) {
        super(icon);
        this.myColor = icon.myColor;
        this.myBorder = icon.myBorder;
        this.myColorSize = icon.myColorSize;
    }

    @Override
    protected ColorIcon copy() {
        return new ColorIcon(this);
    }

    public Color getIconColor() {
        return this.myColor;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        g.setColor(this.getIconColor());
        int size = this.getColorSize();
        int x = i + (iconWidth - size) / 2;
        int y = j + (iconHeight - size) / 2;
        g.fillRect(x, y, size, size);
        if (this.myBorder) {
            g.setColor(Gray.x00.withAlpha(40));
            g.drawRect(x, y, size, size);
        }
    }

    protected int getColorSize() {
        return this.scaleVal(this.myColorSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColorIcon icon = (ColorIcon)o;
        if (this.myBorder != icon.myBorder) {
            return false;
        }
        if (this.myColorSize != icon.myColorSize) {
            return false;
        }
        return !(this.myColor != null ? !this.myColor.equals(icon.myColor) : icon.myColor != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myColor != null ? this.myColor.hashCode() : 0);
        result = 31 * result + (this.myBorder ? 1 : 0);
        result = 31 * result + this.myColorSize;
        return result;
    }
}

