/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CastMethodArgumentFix
extends MethodArgumentFix
implements HighPriorityAction {
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private CastMethodArgumentFix(PsiExpressionList list, int i2, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i2, toType, factory);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            String string = QuickFixBundle.message("cast.single.parameter.text", JavaHighlightUtil.formatType(this.myToType));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("cast.parameter.text", this.myIndex + 1, JavaHighlightUtil.formatType(this.myToType));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix", "getText"));
        }
        return string;
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public CastMethodArgumentFix createFix(PsiExpressionList list, int i2, PsiType toType) {
            return new CastMethodArgumentFix(list, i2, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression.getType();
            if (exprType instanceof PsiClassType && toType instanceof PsiPrimitiveType) {
                toType = ((PsiPrimitiveType)toType).getBoxedType(expression);
                assert (toType != null);
            }
            return AddTypeCastFix.createCastExpression(expression, expression.getProject(), toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (exprType instanceof PsiClassType && parameterType instanceof PsiPrimitiveType && (parameterType = ((PsiPrimitiveType)parameterType).getBoxedType(context)) == null) {
                return false;
            }
            if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType) {
                if (PsiType.NULL.equals(exprType)) {
                    return true;
                }
                if ((parameterType = PsiPrimitiveType.getUnboxedType(parameterType)) == null) {
                    return false;
                }
            }
            return parameterType.isConvertibleFrom(exprType);
        }
    }
}

