/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertDoubleToFloatFix
implements IntentionAction {
    private final PsiExpression myExpression;

    public ConvertDoubleToFloatFix(PsiExpression expression) {
        this.myExpression = expression;
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Convert '" + this.myExpression.getText() + "' to float";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "isAvailable"));
        }
        if (this.myExpression.isValid() && !StringUtil.endsWithIgnoreCase(this.myExpression.getText(), "f")) {
            PsiLiteralExpression expression = (PsiLiteralExpression)this.createFloatingPointExpression(project);
            Object value = expression.getValue();
            return value instanceof Float && !((Float)value).isInfinite() && (((Float)value).floatValue() != 0.0f || TypeConversionUtil.isFPZero(expression.getText()));
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "invoke"));
        }
        this.myExpression.replace(this.createFloatingPointExpression(project));
    }

    private PsiExpression createFloatingPointExpression(Project project) {
        String text = this.myExpression.getText();
        if (StringUtil.endsWithIgnoreCase(text, "d")) {
            return JavaPsiFacade.getElementFactory(project).createExpressionFromText(text.substring(0, text.length() - 1) + "f", this.myExpression);
        }
        return JavaPsiFacade.getElementFactory(project).createExpressionFromText(text + "f", this.myExpression);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntentions"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntentions"));
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ConvertDoubleToFloatFix.registerIntention(expressions, highlightInfo, fixRange, candidate, list);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        PsiParameter[] parameters;
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntention"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntention"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntention"));
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && context.getManager().isInProject(method) && (parameters = method.getParameterList().getParameters()).length == expressions.length) {
            int length = parameters.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiParameter parameter = parameters[i2];
                PsiExpression expression = expressions[i2];
                if (!(expression instanceof PsiLiteralExpression) || !PsiType.FLOAT.equals(parameter.getType()) || !PsiType.DOUBLE.equals(expression.getType())) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new ConvertDoubleToFloatFix(expression));
            }
        }
    }
}

