/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class Java9ModuleExportsPackageToItselfInspection
extends BaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiJavaFile javaFile;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
        }
        PsiFile file = holder.getFile();
        if (file instanceof PsiJavaFile && (javaFile = (PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && javaFile.getModuleDeclaration() != null) {
            ExportedToSelfVisitor exportedToSelfVisitor = new ExportedToSelfVisitor(holder);
            if (exportedToSelfVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
            }
            return exportedToSelfVisitor;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static class DeleteExportsToModuleFix
    implements LocalQuickFix {
        private final String myModuleName;

        public DeleteExportsToModuleFix(PsiJavaModuleReferenceElement reference) {
            this.myModuleName = reference.getReferenceText();
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("exports.to.itself.delete.module.fix.name", this.myModuleName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("exports.to.itself.delete.module.fix.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(psiElement)) {
                return;
            }
            psiElement.delete();
        }
    }

    private static class ExportedToSelfVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public ExportedToSelfVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitExportsStatement(PsiExportsStatement statement) {
            super.visitExportsStatement(statement);
            PsiJavaModule javaModule = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiJavaModule.class);
            if (javaModule != null) {
                String moduleName = javaModule.getModuleName();
                ArrayList<PsiJavaModuleReferenceElement> referenceElements = ContainerUtil.newArrayList(statement.getModuleReferences());
                for (PsiJavaModuleReferenceElement referenceElement : referenceElements) {
                    if (!moduleName.equals(referenceElement.getReferenceText())) continue;
                    String message = InspectionsBundle.message("inspection.module.exports.package.to.itself.message", new Object[0]);
                    this.myHolder.registerProblem((PsiElement)referenceElement, message, new DeleteExportsToModuleFix(referenceElement));
                }
            }
        }
    }
}

