/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefImplicitConstructorImpl
extends RefMethodImpl
implements RefImplicitConstructor {
    private final RefClass myOwnerClass;

    RefImplicitConstructorImpl(@NotNull RefClass ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reference/RefImplicitConstructorImpl", "<init>"));
        }
        super(InspectionsBundle.message("inspection.reference.implicit.constructor.name", ownerClass.getName()), ownerClass);
        this.myOwnerClass = ownerClass;
    }

    @Override
    public void buildReferences() {
        this.getRefManager().fireBuildReferences(this);
    }

    @Override
    public boolean isSuspicious() {
        return ((RefClassImpl)this.getOwnerClass()).isSuspicious();
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message("inspection.reference.implicit.constructor.name", this.getOwnerClass().getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefImplicitConstructorImpl", "getName"));
        }
        return string;
    }

    @Override
    public String getExternalName() {
        return this.getOwnerClass().getExternalName();
    }

    @Override
    public boolean isValid() {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return RefImplicitConstructorImpl.this.getOwnerClass().isValid();
            }
        });
    }

    @Override
    public String getAccessModifier() {
        return this.getOwnerClass().getAccessModifier();
    }

    @Override
    public void setAccessModifier(String am) {
        RefJavaUtil.getInstance().setAccessModifier(this.getOwnerClass(), am);
    }

    @Override
    public PsiModifierListOwner getElement() {
        return this.getOwnerClass().getElement();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return ((RefClassImpl)this.getOwnerClass()).getContainingFile();
    }

    @Override
    public RefClass getOwnerClass() {
        return this.myOwnerClass;
    }
}

