/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.uncheckedWarnings;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedWarningLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNCHECKED_WARNING";
    public static final String DISPLAY_NAME = InspectionsBundle.message("unchecked.warning", new Object[0]);
    @NonNls
    private static final String ID = "unchecked";
    private static final Logger LOG = Logger.getInstance("#" + UncheckedWarningLocalInspectionBase.class);
    public boolean IGNORE_UNCHECKED_ASSIGNMENT;
    public boolean IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION;
    public boolean IGNORE_UNCHECKED_CALL;
    public boolean IGNORE_UNCHECKED_CAST;
    public boolean IGNORE_UNCHECKED_OVERRIDING;

    @NotNull
    static JCheckBox createSetting(@NotNull String cbText, boolean option, @NotNull Pass<JCheckBox> pass) {
        if (cbText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbText", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "createSetting"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "createSetting"));
        }
        JCheckBox uncheckedCb = new JCheckBox(cbText, option);
        uncheckedCb.addActionListener(e -> {
            if (pass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "lambda$createSetting$0"));
            }
            pass.pass(uncheckedCb);
        });
        JCheckBox jCheckBox = uncheckedCb;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "createSetting"));
        }
        return jCheckBox;
    }

    private static LocalQuickFix[] getChangeVariableTypeFixes(@NotNull PsiVariable parameter, @Nullable PsiType itemType, LocalQuickFix[] generifyFixes) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getChangeVariableTypeFixes"));
        }
        if (itemType instanceof PsiMethodReferenceType) {
            return generifyFixes;
        }
        LOG.assertTrue(parameter.isValid());
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : Extensions.getExtensions(ChangeVariableTypeQuickFixProvider.EP_NAME)) {
                for (IntentionAction action : fixProvider.getFixes(parameter, itemType)) {
                    if (!(action instanceof LocalQuickFix)) continue;
                    result.add((LocalQuickFix)((Object)action));
                }
            }
        }
        if (generifyFixes.length > 0) {
            Collections.addAll(result, generifyFixes);
        }
        return result.toArray(new LocalQuickFix[result.size()]);
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getGroupDisplayName"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getID"));
        }
        return ID;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "writeSettings"));
        }
        if (this.IGNORE_UNCHECKED_ASSIGNMENT || this.IGNORE_UNCHECKED_CALL || this.IGNORE_UNCHECKED_CAST || this.IGNORE_UNCHECKED_OVERRIDING || this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
            super.writeSettings(node);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(session.getFile());
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        UncheckedWarningsVisitor uncheckedWarningsVisitor = new UncheckedWarningsVisitor(isOnTheFly, languageLevel){

            @Override
            protected void registerProblem(@NotNull String message, @Nullable PsiElement callExpression, @NotNull PsiElement psiElement, @NotNull LocalQuickFix[] quickFixes) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1", "registerProblem"));
                }
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1", "registerProblem"));
                }
                if (quickFixes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1", "registerProblem"));
                }
                String rawExpression = UncheckedWarningLocalInspectionBase.isMethodCalledOnRawType(callExpression);
                if (rawExpression != null) {
                    String referenceName = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceName();
                    message = message + ". Reason: '" + rawExpression + "' has raw type, so result of " + referenceName + " is erased";
                }
                holder.registerProblem(psiElement, message, quickFixes);
            }
        };
        if (uncheckedWarningsVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
        }
        return uncheckedWarningsVisitor;
    }

    protected LocalQuickFix[] createFixes() {
        return null;
    }

    private static String isMethodCalledOnRawType(PsiElement expression) {
        PsiClass qualifierClass;
        PsiExpression qualifierExpression;
        if (expression instanceof PsiMethodCallExpression && (qualifierExpression = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression()) != null && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType())) != null && PsiUtil.isRawSubstitutor(qualifierClass, ((PsiMethodCallExpression)expression).resolveMethodGenerics().getSubstitutor())) {
            return qualifierExpression.getText();
        }
        return null;
    }

    private abstract class UncheckedWarningsVisitor
    extends JavaElementVisitor {
        private final boolean myOnTheFly;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final LocalQuickFix[] myGenerifyFixes;

        UncheckedWarningsVisitor(@NotNull boolean onTheFly, LanguageLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor", "<init>"));
            }
            this.myOnTheFly = onTheFly;
            this.myLanguageLevel = level;
            this.myGenerifyFixes = onTheFly ? UncheckedWarningLocalInspectionBase.this.createFixes() : LocalQuickFix.EMPTY_ARRAY;
        }

        protected abstract void registerProblem(@NotNull String var1, PsiElement var2, @NotNull PsiElement var3, @NotNull LocalQuickFix[] var4);

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            if (JavaGenericsUtil.isUncheckedWarning(expression, result, this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", null, expression, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
            if (classReference != null && JavaGenericsUtil.isUncheckedWarning(classReference, expression.resolveMethodGenerics(), this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", expression, classReference, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CAST) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType exprType = operand.getType();
            if (exprType == null) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible(exprType, castType)) {
                return;
            }
            if (JavaGenericsUtil.isUncheckedCast(castType, exprType)) {
                String description = JavaErrorMessages.message("generics.unchecked.cast", JavaHighlightUtil.formatType(exprType), JavaHighlightUtil.formatType(castType));
                this.registerProblem(description, operand, expression, this.myGenerifyFixes);
            }
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            super.visitMethodReferenceExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            String description = this.getUncheckedCallDescription(expression, result);
            if (description != null) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                this.registerProblem(description, expression, referenceNameElement != null ? referenceNameElement : expression, this.myGenerifyFixes);
            }
        }

        @Override
        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult result = callExpression.resolveMethodGenerics();
            String description = this.getUncheckedCallDescription(callExpression, result);
            if (description != null) {
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                    return;
                }
                PsiCallExpression element = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression() : callExpression;
                this.registerProblem(description, null, element, this.myGenerifyFixes);
            } else {
                PsiMethod method;
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiExpressionList argumentList = callExpression.getArgumentList();
                if (argumentList != null && (method = (PsiMethod)result.getElement()) != null) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != 0) {
                        for (int i2 = 0; i2 < expressions.length; ++i2) {
                            PsiParameter parameter = parameters[Math.min(i2, parameters.length - 1)];
                            PsiExpression expression = expressions[i2];
                            PsiType parameterType = substitutor.substitute(parameter.getType());
                            PsiType expressionType = expression.getType();
                            if (expressionType == null) continue;
                            this.checkRawToGenericsAssignment(expression, expression, parameterType, expressionType, true, this.myGenerifyFixes);
                        }
                    }
                }
            }
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
                return;
            }
            PsiType initializerType = initializer.getType();
            this.checkRawToGenericsAssignment(initializer, initializer, variable.getType(), initializerType, true, this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(variable, initializerType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            PsiType parameterType = parameter.getType();
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType itemType = JavaGenericsUtil.getCollectionItemType(iteratedValue);
            LocalQuickFix[] fixes = this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(parameter, itemType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY;
            this.checkRawToGenericsAssignment(parameter, iteratedValue, parameterType, itemType, true, fixes);
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiElement element;
            super.visitAssignmentExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            if (!"=".equals(expression.getOperationSign().getText())) {
                return;
            }
            PsiExpression lExpr = expression.getLExpression();
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                return;
            }
            PsiType lType = lExpr.getType();
            PsiType rType = rExpr.getType();
            if (rType == null) {
                return;
            }
            PsiVariable leftVar = null;
            if (lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                leftVar = (PsiVariable)element;
            }
            this.checkRawToGenericsAssignment(rExpr, rExpr, lType, rType, true, this.myOnTheFly && leftVar != null ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(leftVar, rType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializer) {
            PsiExpression[] initializers;
            super.visitArrayInitializerExpression(arrayInitializer);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType type = arrayInitializer.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            boolean arrayTypeFixChecked = false;
            VariableArrayTypeFix fix = null;
            for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
                PsiType itemType = expression.getType();
                if (itemType == null || !TypeConversionUtil.isAssignable(componentType, itemType) || !JavaGenericsUtil.isRawToGeneric(componentType, itemType)) continue;
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(componentType));
                if (!arrayTypeFixChecked) {
                    PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                    fix = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                    arrayTypeFixChecked = true;
                }
                if (fix == null) continue;
                this.registerProblem(description, null, expression, new LocalQuickFix[]{fix});
            }
        }

        private void checkRawToGenericsAssignment(@NotNull PsiElement parameter, PsiExpression expression, PsiType parameterType, PsiType itemType, boolean checkAssignability, @NotNull LocalQuickFix[] quickFixes) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor", "checkRawToGenericsAssignment"));
            }
            if (quickFixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor", "checkRawToGenericsAssignment"));
            }
            if (parameterType == null || itemType == null) {
                return;
            }
            if (checkAssignability && !TypeConversionUtil.isAssignable(parameterType, itemType)) {
                return;
            }
            if (JavaGenericsUtil.isRawToGeneric(parameterType, itemType)) {
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(parameterType));
                this.registerProblem(description, expression, parameter, quickFixes);
            }
        }

        @Override
        public void visitMethod(PsiMethod method) {
            List<HierarchicalMethodSignature> superMethodSignatures;
            super.visitMethod(method);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_OVERRIDING) {
                return;
            }
            if (!(method.isConstructor() || (superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty() || method.hasModifierProperty("static"))) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
                    PsiMethod baseMethod = methodSignatureBackedByPsiMethod.getMethod();
                    PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(signature, methodSignatureBackedByPsiMethod);
                    if (substitutor == null) {
                        substitutor = methodSignatureBackedByPsiMethod.getSubstitutor();
                    }
                    if (PsiUtil.isRawSubstitutor(baseMethod, methodSignatureBackedByPsiMethod.getSubstitutor())) continue;
                    PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
                    PsiType overriderReturnType = method.getReturnType();
                    if (baseReturnType == null || overriderReturnType == null) {
                        return;
                    }
                    if (!JavaGenericsUtil.isRawToGeneric(baseReturnType, overriderReturnType)) continue;
                    String message = JavaErrorMessages.message("unchecked.overriding.incompatible.return.type", JavaHighlightUtil.formatType(overriderReturnType), JavaHighlightUtil.formatType(baseReturnType));
                    PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                    LOG.assertTrue(returnTypeElement != null);
                    this.registerProblem(message, null, returnTypeElement, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiType valueType;
            PsiExpression returnValue;
            super.visitReturnStatement(statement);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType returnType = null;
            Object psiElement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, PsiLambdaExpression.class);
            if (psiElement instanceof PsiMethod) {
                returnType = ((PsiMethod)psiElement).getReturnType();
            } else if (psiElement instanceof PsiLambdaExpression) {
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)psiElement);
            }
            if (returnType != null && !PsiType.VOID.equals(returnType) && (returnValue = statement.getReturnValue()) != null && (valueType = returnValue.getType()) != null) {
                LocalQuickFix[] localQuickFixArray;
                if (psiElement instanceof PsiMethod) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = QuickFixFactory.getInstance().createMethodReturnFix((PsiMethod)psiElement, valueType, true);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                this.checkRawToGenericsAssignment(returnValue, returnValue, returnType, valueType, false, fixes);
            }
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression) {
            PsiType type;
            PsiType interfaceReturnType;
            super.visitLambdaExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiElement body = expression.getBody();
            if (body instanceof PsiExpression && (interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(expression)) != null && !PsiType.VOID.equals(interfaceReturnType) && (type = ((PsiExpression)body).getType()) != null) {
                this.checkRawToGenericsAssignment(body, (PsiExpression)body, interfaceReturnType, type, false, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Nullable
        private String getUncheckedCallDescription(PsiElement place, JavaResolveResult resolveResult) {
            PsiParameter[] parameters;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            final PsiMethod method = (PsiMethod)element;
            final PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!PsiUtil.isRawSubstitutor(method, substitutor)) {
                if (JavaVersionService.getInstance().isAtLeast(place, JavaSdkVersion.JDK_1_8)) {
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(method)) {
                        PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
                        if (extendsListTypes.length <= 0) continue;
                        PsiType subst = substitutor.substitute(parameter);
                        for (PsiClassType classType : extendsListTypes) {
                            if (!JavaGenericsUtil.isRawToGeneric(substitutor.substitute(classType), subst)) continue;
                            return JavaErrorMessages.message("generics.unchecked.call", JavaHighlightUtil.formatMethod(method));
                        }
                    }
                }
                return null;
            }
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                PsiType parameterType = parameter.getType();
                if (!parameterType.accept(new PsiTypeVisitor<Boolean>(){

                    @Override
                    public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return arrayType.getComponentType().accept(this);
                    }

                    @Override
                    public Boolean visitClassType(PsiClassType classType) {
                        PsiType[] parameters;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass instanceof PsiTypeParameter) {
                            if (((PsiTypeParameter)psiClass).getOwner() == method) {
                                return Boolean.FALSE;
                            }
                            return substitutor.substitute((PsiTypeParameter)psiClass) == null ? Boolean.TRUE : Boolean.FALSE;
                        }
                        for (PsiType parameter : parameters = classType.getParameters()) {
                            if (!parameter.accept(this).booleanValue()) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }

                    @Override
                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound != null) {
                            return bound.accept(this);
                        }
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean visitEllipsisType(PsiEllipsisType ellipsisType) {
                        return ellipsisType.getComponentType().accept(this);
                    }
                }).booleanValue()) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
                PsiClassType type = elementFactory.createType(method.getContainingClass(), substitutor);
                return JavaErrorMessages.message("generics.unchecked.call.to.member.of.raw.type", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatType(type));
            }
            return null;
        }
    }
}

