/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final T myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement;
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        PsiTreeElementBase psiTreeElementBase = this;
        if (psiTreeElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/common/PsiTreeElementBase", "getPresentation"));
        }
        return psiTreeElementBase;
    }

    @Override
    @NotNull
    public Object getKey() {
        String string;
        try {
            string = this.myValue.toString();
        }
        catch (Exception e) {
            Class<?> clazz = this.myValue.getClass();
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/common/PsiTreeElementBase", "getKey"));
            }
            return clazz;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/common/PsiTreeElementBase", "getKey"));
        }
        return string;
    }

    @Nullable
    public final T getElement() {
        return this.myValue.isValid() ? (T)this.myValue : null;
    }

    @Override
    public Icon getIcon(boolean open) {
        T element = this.getElement();
        if (element != null) {
            int flags = 2;
            if (!(element instanceof PsiFile) || !element.isWritable()) {
                flags |= 1;
            }
            return element.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    @Override
    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element = this.getElement();
        return element != null ? element.toString() : "";
    }

    @NotNull
    public final StructureViewTreeElement[] getChildren() {
        T element = this.getElement();
        if (element == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/common/PsiTreeElementBase", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        Collection<StructureViewTreeElement> baseChildren = this.getChildrenBase();
        result.addAll(CustomRegionStructureUtil.groupByCustomRegions(element, baseChildren));
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element.getProject());
        Class<?> aClass = element.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            StructureViewTreeElement[] children = extension.getChildren((PsiElement)element);
            if (children == null) continue;
            ContainerUtil.addAll(result, children);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = result.toArray(new StructureViewTreeElement[result.size()]);
        if (structureViewTreeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/common/PsiTreeElementBase", "getChildren"));
        }
        return structureViewTreeElementArray;
    }

    @Override
    public void navigate(boolean requestFocus) {
        T element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        T element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        Object value = this.getValue();
        return value == null ? that.getValue() == null : value.equals(that.getValue());
    }

    public int hashCode() {
        Object value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    public boolean isValid() {
        return this.myValue != null && this.myValue.isValid();
    }
}

